/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) diskreq.c: version 25.1 created on 11/27/91 at 14:34:19	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)diskreq.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "types.h"
#include "icb.h"
#include "spm.h"
#include "devcmd.h"
#include "vreg.h"
#include "icb_config.h"
#include "rtb.h"
#include "misc.h"
#include "disp.h"

extern unsigned char ioinit;
extern unsigned char myslot;
extern char diskflg;
extern	struct	icb_config	*edt_icb_ptr[19];

dskreq(drive,command,count,block,maddr)
unsigned maddr,drive,count,block;
{
	struct icb_config	*icbp;
	unsigned char 		mem_slot;
	char 			iom_slot;
	unsigned bcnt = drive >> 4;
	unsigned i,i1;

	if((iom_slot = (unsigned char)findiom()) == 18)	 { /* first IOM */
		printf("No IO module found\n");
		return(-1);
	}

	if((mem_slot = (unsigned char)findmem()) == 18)	{
		printf("No memory board found\n");
		return;
	}

	iominit(iom_slot);	/* initial IO module */
	if (!ioinit)	{ 

		/* initial IO module interrupt vector table */
		iom_int_tbl_init(iom_slot,0);
		ioinit = 1;
	}
	sp_int_set();	/* set SPM to receive int itself */

	find_edt();

	icbp = (struct icb_config *)0; /* uses first iom? */

	i1 = 0;	/* ok, let's keep track of controllers. */
	for(i = 0; i < MAX_IO_SLOT; i++) /* loop through entire table. */
	{
		if(edt_icb_ptr[i])	 /* if something is here. */
		{
			if(i1 != bcnt) /* if this is not the controller number we want. */
			{
				i1++;
				continue;
			}
			icbp = edt_icb_ptr[i];
			break;
		}
	}
	if(!icbp)
	{
		printf("No EDT board found\n");
		return;
	}
	if (count % 0x400) {
		printf("No partial block.\n");
		return;
	}
	diskflg = 1;
	while (count) {
		i = dtreq(icbp,command,maddr,block,0x400,mem_slot,drive&0xf,DTDISK);
		if (i) {
			diskflg = 0;
			return(i);
		}
		block++;
		maddr += 0x400;
		count -= 0x400;
	}
	diskflg = 0;
	return(i);
}
