/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) devreq.c: version 25.1 created on 11/27/91 at 14:34:12	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)devreq.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/******************************************************************************
 *
 * request the service of a DTB block device through the vreg structure
 *
 ******************************************************************************/
#include "icb.h"
#include "spm.h"
#include "types.h"
#include "vreg.h"
#include "icb_config.h"
#include "rtb.h"
#include "misc.h"
#include "iom.h"

extern	unsigned char	dtcintp;
unsigned 	int_data;


dev_req(icbp,devptr, stat)
struct icb_config	*icbp;
struct devq		*devptr;
unsigned *stat;
{
	struct devq 	*req, *xdq;
	unsigned 	delay;
	unsigned 	sp_slot;
	unsigned short 	status;


	sp_slot = (unsigned)((*STATUSREG >> 24) & 0x0f); /* get sp slot # */

	dtcintp = 0;
	/*
	 * lock the test and set on the EDT to prevent the EDT from
	 * manipulating the queues at the same time we are.
	 */

	if ( locktas(icbp->iop_base) ) {
		printf("Devreq: locktas failed\n");
		return(1);
	}

	/* grab a free request pointer of off the freelist */
#ifdef	REMOVE
	printf("icb->bdptr:%x\n",icbp->bdptr); 
#endif
	if ( (req = icbp->bdptr->freefst) == 0 ) {   /* nothing on freelist */
		unlocktas(icbp->iop_base);
		printf("Devreq: nothing on freelist\n");
		return(1);
	}

	/*
	 * convert EDT pointer address (64k offset)
	 * to SPM address (map address to base of EDT, plus
	 * the EDT offset
	 */

	req = (struct devq *)((unsigned int)req+(unsigned int)(icbp->iop_base));
#ifdef	REMOVE
	printf("Req:%x\n",req); 
#endif

	/* remove entry from freelist, by setting freelist to next */

	icbp->bdptr->freefst = req->q_next;

	bcopy((unsigned char *)devptr, (unsigned char *)req, (unsigned int)sizeof(struct devq));

	/* put the request onto the request queue */

	if ( icbp->bdptr->reqfst == 0 ) {	/* nothing on request list */
		icbp->bdptr->reqfst =
			icbp->bdptr->reqlst=(struct devq *)((int)req&0xffff);
	}
	else {
		xdq = (struct devq *)
		  ((int)icbp->bdptr->reqlst + (unsigned int)(icbp->iop_base));
		xdq->q_next = (struct devq *)((int)req & 0xffff);
		icbp->bdptr->reqlst = (struct devq *)((int)req & 0xffff);
	}
	req->q_next = (struct devq *)0;

	unlocktas(icbp->iop_base);

	if (devptr->q_devtype == DTDISK)
		delay = 0x200000;
	else
		delay = 0x2000000;
/* Issue interrupt */

	icbp->iop_base->intreg = RTB_VI;

/* Wait for interrupt */

#ifdef	REMOVE
	while(!(icbp->iop_base->bdtypreg & 0x40) && (delay != 0)) 
		delay--;
#endif
	while(!dtcintp && (delay != 0)) /* */
		delay--;
	status = icbp->iop_base->intreg & 0xff;

	if (delay == 0)	{
		printf("Time-out on DTC interrupt\n");
		return(-1);
	}

	if (dtcintp == 0)
	{
		printf("No interrupt\n");
		return(-1);
	} /*  it's ok by me! */
	dtcintp = 0;

	locktas(icbp->iop_base);

	/* pick request off of response queue */

	if( (req = icbp->bdptr->rsfst) == 0) { /* nothing on response list */
		printf("Devreq: nothing on response queue\n");
		unlocktas(icbp->iop_base);
		return(1);
	}

	if ( icbp->bdptr->rslst != req ) {
		printf("Devreq: rsfst != rslst\n");
		unlocktas(icbp->iop_base);
		return(1);
	}

	/*
	 * convert EDT pointer address (64k offset)
	 * to SPM address (map address to base of EDT, plus
	 * the EDT offset
	 */

	req = (struct devq *)((unsigned int)req+(unsigned int)(icbp->iop_base));
#ifdef	REMOVE
	printf("Response q:%x\n",req); /* */
#endif

	/* remove entry from response list */

	icbp->bdptr->rsfst = icbp->bdptr->rslst = (struct devq *)NULL;

	/* copy request back to io request */

	bcopy((unsigned char *)req, (unsigned char *)devptr, (unsigned int)sizeof(struct devq));


	/* clear the request block */

	bzero((char *)req,(unsigned int)sizeof(struct devq));

	/* put it back on free list */

	req->q_next = icbp->bdptr->freefst;
	icbp->bdptr->freefst = (struct devq *)((int)req & 0xffff);;

	unlocktas(icbp->iop_base);
#ifdef	REMOVE
	printf("Done\n"); /* */
#endif

#ifdef	SPM_IMAGE
	sp_int_ack2(sp_slot); /* stop sending and ack. */
#endif
	return(0);
}

locktas(base)
unsigned int	base;
{
	register unsigned short	*tasp, x;
	register unsigned 	i, i1;

	i = 0;
	
	tasp = (unsigned short *)(base | 0xfffc);

	while((x = *tasp) & RTB_TAS)
	{
/* FIX THIS : This delay has been put in to work around a H/W ***>>BUG!!!!! */
		for(i1 = 0; i1 < 400000; i1++) ;
		if ( i++ > 300 ) 
		{
			printf("Tasp: %x tas: %x\n",tasp,x);
			return(1);
		}
	}
	return(0);
}

unlocktas(base)
unsigned int	base;
{
	register unsigned short	*tasp;

	tasp = (unsigned short *)(base | 0xfffc);
	*tasp = 1;
}


bcopy(saddr,daddr,size)
unsigned char	*saddr,*daddr;
unsigned int size;
{
	unsigned int i;

#ifdef	REMOVE
	printf("Src addr:%x dest addr:%x\n",saddr,daddr); /* */
#endif
	for (i = 0; i< size; i++)	
		*daddr++ = *saddr++;
}

bzero(addr,size)
char	*addr;
unsigned int size;
{
	unsigned int i;

#ifdef	REMOVE
	printf("Zero addr:%x \n",addr); /* */
#endif
	for (i = 0; i< size; i++)	
		*addr++ = 0;
}

