/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) debug.c: version 25.1 created on 11/27/91 at 14:34:07	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)debug.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * debug.c
 *
 */

#include "types.h"
#include "menu.h"
#include "routines.h"
#include "globl.h"
#include "spm.h"
#include "global.h"
#include "rtc.h"
#include "disp.h"
#include "ipcc.h"
#include "dev.h"
#include "novram.h"
#include "misc.h"

extern uchar	css_slot;
extern uchar	sub_slot;
extern uchar	phys_dev;
extern uchar	log_dev;

struct slotst sf;

extern unsigned char HndlBerr;
extern char cpuack;		/* set if we want to only print out junk. */
unsigned int em_addr;
extern unsigned char emulate;
extern char got_berr;			/* set if we got bus error */
extern	unsigned char myslot;

unsigned char bdhere[16];		/* slots for CSS boards */
unsigned int pattsave;		/* pattern matches what we are looking for. */

#define MAP00		00		/* map ram 0 */
#define MM_INIT 0x78	/* Turn green LED, EDAC and error interrupt bits */

extern unsigned char *CTL_REG;

extern	unsigned int get_iopm_blk_num ();
extern	int iopm_prom_ver ();

int slot_cntl();
int exemem();
int show_em();
int rd_iopm_tst ();
int iopm_blk_num ();
int iready_prt();
int rready_prt();
int init_css_prt();

struct init_menu i_debugger [] = {
	
	"jsr", "addr <arg1>..<arg6>",
	"Jump to subroutine",'c',1,7,jsr,    (char *)0,
	
	"memd", "",
	"Memory Debugger Utility",'m',0,0,(PFI)i_debugger_mem,  (char *)0,
	
	"flagd", "",
	"Debugger Flag Set/Reset",'m',0,0,(PFI)i_debugger_flag,  (char *)0,
	
	"busd", "",
	"Debugger CSS Bus Utility",'m',0,0,(PFI)i_debugger_bus,  (char *)0,
	
	"iod", "",
	"Debugger I/O Utility",'m',0,0,(PFI)i_debugger_io,  (char *)0,
	
	"", "", "", '\0', 0, 0, 0, (char *)0,
	};
	
	
struct init_menu i_debugger_flag [] = {
	"ca", "on/off",
	"Turn CPU cache on or off", 'c',1,1, cache020, (char *)0,
	
	"me","on/off",
	"Enter memory simulation mode", 'c',1,1,mem_simulate, (char *)0,
	
	"sbl", "",
	"Set buserr loop flag ", 'c', 0, 0, set_berr_loop, (char *)0,
	
	"em", "",
	"Set buserr emulate flag ", 'c', 0, 0, berr_em, (char *)0,
	
	"emn", "",
	"Reset buserr emulate flag ", 'c', 0, 0, berr_em_n, (char *)0,
	
	"", "", "", '\0', 0, 0, 0, (char *)0,
	};
	
	
struct init_menu i_debugger_bus [] = {
	"ic", "",
	"Initialize CSS activity", 'c', 0,0,init_css_prt, (char *)0,
	
	"id","<d> (diag mode)",
	"Initialize Dispatcher",'c',0,1,init_dispatcher,(char *)0,
	
	"ir", "",
	"Increase ready count in arbiter", 'c',0,0,iready_prt, (char *)0,
	
	"rr", "",
	"Reset ready count in arbiter", 'c',0,0,rready_prt, (char *)0,
	
	"rc", "",
	"Reset CSS bus", 'c', 0, 0, css_reset1, (char *)0,
	
	"pol","",
	"Poll CSS slots", 'c', 0,0, pollsl, (char *)0,
	
	"eslot","if/mod/all slot [slot <slot..>]",
	"Enable CSS IF or MODULE ", 'c', 2,9, slot_cntl, (char *)0,
	
	"dslot","if/mod/all slot [slot <slot..>]",
	"Disable CSS IF or MODULE ", 'c', 2,9, slot_cntl, (char *)0,
	
	"Eslot","if/mod/all slot board_id",
	"Enable CSS IF or MODULE ", 'c', 3,3, slot_cntl, (char *)0,
	
	"Dslot","if/mod/all slot board_id",
	"Disable CSS IF or MODULE ", 'c', 3,3, slot_cntl, (char *)0,
	
	"iop", "",
	"Poll I/O system slots ", 'c', 0, 0,poll_io, (char *)0,
	
	"con(trol)","cmd [slot]",
	"Send a control write to map 6 slot",'c',1,2,ifcntl,(char *)0,
	
	"iot", "",
	"Show I/O system config ", 'c', 0, 0,iotbl, (char *)0,
	
	"", "", "", '\0', 0, 0, 0, (char *)0,
	};
	
	
struct init_menu i_debugger_mem [] = {
	"map", "map# slot# addr",
	"Map slot and address", 'c', 0,3,mslot, (char *)0,
	
	"dm<.[bwl]>", "<addr <size>>",
	"Display memory", 'c', 0, 2, dmem, (char *)0,
	
	"fm<.[bwl]>", "addr data <size>",
	"Fill memory block", 'c', 2,3,fmem, (char *)0,
	
	"mm<.[bwl]>", "<addr <data>>",
	"Modify memory", 'c', 0, 2, mmem, (char *)0,
	
	"rdb<.[bwl]>", "addr <size>",
	"Read block loop", 'c', 1, 2, rdblock, (char *)0,
	
	"wrb<.[bwl]>","addr data <size>",
	"Write block loop",'c',2,3,wrblock,(char *)0,
	
	"mov<.[bwl]>", "src dest size",
	"Move memory", 'c', 3,3,move_mem, (char *)0,
	
	"lmov<.[bwl]>","sre dest size",
	"Loop move memory",'c',3,3,move_mem,(char *)0,
	
	"cmp<.[bwl]>","src dest size",
	"Compare memory",'c',3,3,compare_mem,(char *)0,
	
	"lcmp<.[bwl]>", "src dest size",
	"Loop compare memory", 'c', 3,3,compare_mem, (char *)0,
	
	"ecmp<.[bwl]>", "src dest size",
	"Loop compare memory, stop on error", 'c', 3,3,compare_mem, (char *)0,
	
#ifdef	SPM_PROM
	"sea<.[bwl]>", "pat [addr] [leng]",
	"Search for pattern in memory", 'c', 1,3,search_mem, (char *)0,
	
	"lmem","",
	"Local SPM memory test.",'c', 0, 0,lramtst,(char *)0,
	
	"exm","slot# #Mbytes",
	"Execute test from main memory",'c',1,2,exemem,(char *)0,
#endif
	
	"", "", "", '\0', 0, 0, 0, (char *)0,
	};
	
	
struct init_menu i_debugger_io [] = {
	"rd_iopm", "slot dev block count [sub_slot]",
	"Read block(s) from an IOPM device",'c', 4, 5, rd_iopm_tst, (char *)0,
	
	"blk_num", "css phys_dev log_dev [sub_slot]",
	"Find starting block number",'c', 3, 4, iopm_blk_num, (char *)0,
	
	"e_i(opm_ver)", "<slot>",
	"Display IOPM EPROM Version",'c', 0, 1, iopm_prom_ver, (char *)0,
	
	"ee_i(opm_ee_ver)", "<slot>",
	"Display IOPM EEPROM Version",'c', 0, 1, iopm_prom_ver, (char *)0,
	
	"", "", "", '\0', 0, 0, 0, (char *)0,
	};

struct menu *debugger = (struct menu *)i_debugger;
struct menu *debugger_mem = (struct menu *)i_debugger_mem;
struct menu *debugger_flag = (struct menu *)i_debugger_flag;
struct menu *debugger_io = (struct menu *)i_debugger_io;
struct menu *debugger_bus = (struct menu *)i_debugger_bus;

/*
 *	Memory related commands
 *
 *	dmem(comm_str, arg_cnt)
 *	char *comm_str;
 *	int arg_cnt;
 *
 *	dm(emory)<.[bwl]> <addr <count>> - Display memory
 *		This is the ubiquitous display memory command. The minimum
 *		required to operate this command is 'dm xxxx', where xxxx is
 *		the desired address. The result is that the memory is dumped
 *		to the screen with the applicable ascii equivalents in the
 *		right hand margin for a page, waiting for a <RET> for another
 *		page, <SP> for another line, or any other key to quit back to
 *		the prompt.
 *		When the count is specified, just that amount is displayed
 *		with no paging.
 */

unsigned char *lastmem;
char mref_siz;		/* Memory reference size, defaults to long */
int pagsize;
extern char comm_args[][MAXARGSIZE];
static	char linbuf[17];
static	int nline;
static	unsigned count;


dmem(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	register int i,j;

	linbuf[16] = '\0';

	/* Arg_cnt will be either 0, 1 or 2 */
	switch (arg_cnt) {
		case 0:
			lastmem = (unsigned char*)0x00;
			count = 0xffffffff; /* max size */
			break;
		case 1:
			lastmem = (unsigned char*)atox(comm_args[1]);
			count = 0xffffffff; /* max size */
			break;
		case 2:
			lastmem = (unsigned char*)atox(comm_args[1]);
			count = atox(comm_args[2]);/* get the number of bytes */
			break;
	}

	if((unsigned)lastmem & (unsigned)0x80000000 ) {	/* if css check clock */
		if(clokpr(0))	 /* and if it returns bad, so do we. */
			return;
	}

	/* determine how many fields to print per line */
	switch(mref_siz) {
		case 'l': nline = 4; break;
		case 'w': nline = 8; break;
		case 'b': nline = 16; break;
		default:
			printf ("Illegal output type\n");
			return(-1);
	}
	/* Main loop */
	while(1) {
		for(j=0; (j<pagsize) && (count);j++) {
			one_lne(); /* show one page from current pointers */
			if(!count)			/* done */
				return(0);
		}
		while(1) {
			linbuf[0] = Getchar(); /* wait for key input */
			switch(linbuf[0]) {    /* read the input */
				case '\r': 
				case '\n':
					break;
				case ' ':
					one_lne(); /* show one more line */
					continue;
				default:
					return(0);
			}
			break;
		}
	}
}

one_lne()
{
int i;
register	uchar	rd_char;
		printf("%08x  ", lastmem); /* Beginning addr of line */
		for( i=0; i<nline; i++) {
			switch(mref_siz) {		
				case 'l':
					printf("%08x ", *(unsigned *)lastmem);
					lastmem += 4;
					break;
				case 'w':
					printf("%04x ", *(unsigned short*)lastmem);
					lastmem += 2;
					break;
				case 'b':
					printf("%02x ", 
					(rd_char = *(uchar *)lastmem));
					if((rd_char >= ' ') && (rd_char <= '~'))
						linbuf[i] = rd_char;
					else
						linbuf[i] = '.';
					lastmem++;
					break;
				default:
					break;
			}
			count--; /* remove one byte from length */
			if(!count) {
				if(mref_siz == 'b') /* if done and byte mode */
					for(i++; i<nline; i++) {
						linbuf[i] = ' ';
						printf("   ");
					}
				break;
			}
		}
		if(mref_siz == 'b') {
			linbuf[i] = 0;  /* terminate */
			printf(" %s",linbuf);
		}
	putchar('\n');
}


/*
 *	mmem(comm_str, arg_cnt)
 *	char *comm_str;
 *	int arg_cnt;
 *
 *	mm(emory)<.[bwl]> <addr <data>>  -  Modify memory
 */

mmem(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	char inline[64];
	register unsigned data;
	register int val;

	/* Arg cnt will be either 0, 1 or 2 */
	if(arg_cnt == 2)
		data = atox(comm_args[2]);
	if(arg_cnt>=1)
		lastmem = (unsigned char *)atox (comm_args[1]);
        /* if in CSS RAM check which clock we are on */
	if(lastmem >= (unsigned char*)0x80000000) 
	{
		if(clokpr(0))	 /* and if it returns bad, so do we. */
			return;
	}
	do {
		printf("%08x  ",lastmem);
/*		if(*comm_str == 'm') {		*/
			switch(mref_siz) {
				case 'l':
					printf("%08x ", *(unsigned*)lastmem);
					break;
				case 'w':
					printf("%04x ", *(unsigned short *)lastmem);
					break;
				case 'b':
					printf("%02x ", *lastmem);
					break;
				default:
					printf("Illegal output type\n");
					return(-1);
			}
/*		}		*/
		if(arg_cnt == 2) {
			switch(mref_siz) {
				case 'l':
					printf("< %08x\n", (unsigned)data);
					break;
				case 'w':
					printf("< %04x\n", (unsigned short)data);
					break;
				case 'b':
					printf("< %02x\n", (unsigned char)data);
					break;
			}
		}
		else {
			val = (int)gets(inline,64);
			if(val == -1)
				return(0);
			if(*inline == '\0')
				goto nextspot;
			if(*inline == '-') {
				switch(mref_siz) {
					case 'l':
						lastmem -= 4;
						break;
					case 'w':
						lastmem -= 2;
						break;
					case 'b':
						lastmem--;
						break;
				}
				continue;
			}
			data = atox(inline);
		}
		switch(mref_siz) {
			case 'l':
				*(unsigned *)lastmem = (unsigned)data;
				break;
			case 'w':
				*(unsigned short *)lastmem = (unsigned short)data;
				break;
			case 'b':
				*lastmem = (unsigned char)data;
				break;
		}
		if(arg_cnt != 2) {
nextspot:		switch(mref_siz) {
				case 'l':
					lastmem += 4;
					break;
				case 'w':
					lastmem += 2;
					break;
				case 'b':
					lastmem++;
					break;
			}
		}
	}
	while(arg_cnt <= 1);
}

				
/*
 * rdloop - continuous read of one location
 */

rdloop(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	register int i;
	register short j;
	register char k;
	register unsigned l,m;

	m = 0x10000;
	if(arg_cnt ==1)
		lastmem = (unsigned char*)atox(comm_args[1]);
	/* if in CSS RAM, check which clock we are on */ 
	if(lastmem >= (unsigned char*)0x80000000) 
	{
		if(clokpr(0))	 /* and if it returns bad, so do we. */
			return;
	}
	switch(mref_siz) {
		case 'l':
			while(con_in() == -1)
				for(l=0; l<m; l++) i= *(int *)lastmem;
			break;
		case 'w':
			while(con_in() == -1)
				for(l=0; l<m; l++) j= *(short *)lastmem;
			break;
		case 'b':
			while(con_in() == -1)
				for(l=0; l<m; l++) k= *(char *)lastmem;
			break;
	}
}

/*
 * wrloop - write loop on one location
 */

wrloop(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	register int i;
	register short j;
	register char k;
	register unsigned l,m;

	m=0x10000;

	i=atox(comm_args[1]);
	j=i;
	k=i;
	if(arg_cnt == 2)
		lastmem = (unsigned char*)atox(comm_args[2]);
	/* if in CSS RAM, check which clock we are on */ 
	if(lastmem >= (unsigned char*)0x80000000) 
	{
		if(clokpr(0))	 /* and if it returns bad, so do we. */
			return;
	}
	switch(mref_siz) {
		case 'l':
			while(con_in() == -1)
				for(l=0; l<m; l++)
					*(int *)lastmem = i;
			break;
		case 'w':
			while(con_in() == -1)
				for(l=0; l<m; l++)
					*(short *)lastmem = j;
			break;
		case 'b':
			while(con_in() == -1)
				for(l=0; l<m; l++)
					*(char *)lastmem = k;
			break;
	}
}
	
/*
 * rdblock - read block loop
 */

rdblock(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	register unsigned char *dp, *end;
	register int i;
	register short j;
	register char k;
	register unsigned int size = 0;
	register unsigned l,m;

	lastmem = (unsigned char *)atox(comm_args[1]);
	if(lastmem >= (unsigned char*)0x80000000) { /* if CSS, check clock */

		if(clokpr(0))	 /* and if it returns bad, so do we. */
			return;
	}

	if(arg_cnt == 2) {
		size = atox(comm_args[2]);
		if(size)
			size--;	/* decrement for offset by one count. */
	}

	if(!size)
		size = 0x10000;

	printf ("Press ESC to exit.\n");
	end=lastmem + size;
	while(con_in() == -1) {
		dp = lastmem;
		switch(mref_siz) {
			case 'l':
				while(dp < end) {
					i = *(unsigned *)dp;
					dp += 4;
				}
				break;
			case 'w':
				while(dp < end) {
					j = *(short *)dp;
					dp += 2;
				}
				break;
			case 'b':
				while(dp < end) {
					k = *(char *)dp;
					dp++;
				}
				break;
		}
	}
	return(0);
}


/*
 * wrblock - write block loop
 */

wrblock(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	register unsigned char *dp, *end;
	register int i;
	register short j;
	register char k;
	register unsigned size;
	register unsigned l,m;

	size=0;
	lastmem = (unsigned char *)atox(comm_args[1]);
	if(lastmem >= (unsigned char*)0x80000000) { /* if CSS, check clock */
	
		if(clokpr(0))	 /* and if it returns bad, so do we. */
			return;
	}

	i=atox(comm_args[2]);
	j=(short)i;
	k=(char)i;

	if(arg_cnt ==3)
	{
		size = atox(comm_args[3]);
		if(size) 
			size--;	/* decrement by one for offset. */
	}

	if (!size) 
		size = 0x10000;

	end = lastmem + size;
	while(con_in() == -1) {
		dp = lastmem;
		switch(mref_siz) {
			case 'l':
				while(dp <= end) {
					*(unsigned *)dp =i;
					dp += 4;
				}
				break;
			case 'w':
				while(dp <= end) {
					*(short *)dp =j;
					dp += 2;
				}
				break;
			case 'b':
				while(dp <= end) {
					*(char *)dp =k;
					dp++;
				}
				break;
		}
	}
	return(0);
}

/*
 * fmem - fill memory block
 */

fmem(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	register unsigned char *dp, *end;
	register int i;
	register short j;
	register char k;
	unsigned size;
	register unsigned l,m;

	size=0;
	lastmem = (unsigned char *)atox(comm_args[1]);
	/* if in CSS RAM check which clock we are on */
	if(lastmem >= (unsigned char*)0x80000000) 
	{
		if(clokpr(0))	 /* and if it returns bad, so do we. */
			return;
	}
	i=atox(comm_args[2]);
	j=i;
	k=i;
	if(arg_cnt ==3)
		size = atox(comm_args[3]);
	end = lastmem + size;
	dp = lastmem;
	switch(mref_siz) {
		case 'l':
			while(dp < end) {
				*(unsigned *)dp =i;
				dp += 4;
			}
			break;
		case 'w':
			while(dp < end) {
				*(short *)dp =j;
				dp += 2;
			}
			break;
		case 'b':
			while(dp < end) {
				*(char *)dp =k;
				dp++;
			}
			break;
	}
}


iready_prt()
{
	printf ("Increase ready count in arbiter.\n");
	iready();
}

/*------------------------------------------------------------------------------
		iready()  : increase ready count in the arbiter for the SPM
                            toggle ready bit
-----------------------------------------------------------------------------*/
iready()
{
	*WRCNTL1 |= WR1_IRDY; /* only once.. */
	*WRCNTL1 &= ~WR1_IRDY;	
	*WRCNTL1 |= WR1_IRDY;
}

rready_prt()
{
	printf ("Reset ready count in arbiter.\n");
	rready();
}

/*------------------------------------------------------------------------------
		rready() :  reset ready count in the arbiter for the SPM
                            toggle reset bit
-----------------------------------------------------------------------------*/
rready()
{
	int i;

	if(clokpr(0))
		return(-1);
	*WRCNTL1 &= ~WR1_RRDY;	
	for(i = 0; i < 100; i++) ;
	*WRCNTL1 |= WR1_RRDY;
	for(i = 0; i < 100; i++) ;
}

/*------------------------------------------------------------------------------
-----------------------------------------------------------------------------*/
css_reset1()
{
	int i;

	printf ("Reset CSS Bus.\n");
	css_reset();
	slotson();	/* enable boards who passed first time */
	cpu_idle(0,0);	/* Go thru the whole table and put the CPUs in idle. */
	for(i = 0; i < 16; i++) {
		if(bdhere[i] == MEMHERE){
			cssmap(MAP01,i,(char)0x0f);
			*(char *)CTL_REG = MM_INIT;
		}
	}
	iominit();
}

/*------------------------------------------------------------------------------
-----------------------------------------------------------------------------*/
css_reset()
{
	register i;

	if(clokpr(0))
		return(-1);
	*WRCNTL1 &= ~WR1_CSSRST;		/* and assert it. */
	for(i = 0; i < 300000; i++);		/* small delay loop. */
	*WRCNTL1 |= WR1_CSSRST;			/* and assert it. */
	for(i = 0; i < 300000; i++);		/* small delay loop. */
	rready();
	iready();
}

/*------------------------------------------------------------------------------
	cpu_idle : If 'flg' is a non zero then use 'slt' for target.
		   else use the table and do all the found CPUs for target.
		   Of course the idea is to 'idle the cpus', but you already
		   know that... right!!!.
------------------------------------------------------------------------------*/
cpu_idle(flg,slt)
char flg,slt;
{
	int i,x;
	if(!flg) {
		for(i=0;i<Sbus_Num_Slot;i++) {		/* loop for cpu's. */
			if(bdhere[i] == CPUHERE) {	/* if a cpu, send SPM
							   slot and the idle
							   command.   */
				ipccsend(i, IPCC_SM_SLOT, myslot);
				ipccsend(i, IPCC_PM_PUTR, -1);
			}
		}
	}
	else {
		if((slt>15) || (slt<0) || (bdhere[slt] != CPUHERE))	{
			printf("\nInvalid PM slot number.\n");
			return(1);
		}	
		ipccsend(slt, IPCC_SM_SLOT, myslot);	/* SPM slot. */
		ipccsend(slt, IPCC_PM_PUTR, -1);	/* idle command. */
	}
	return(0);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
init_css_prt ()
{
	printf ("Initialize CSS activity.\n");
	init_css ();
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
init_css()
{
	register unsigned  slot,inv_slot;
	unsigned int i;

	if(clokpr(0)) return(1); /* If in local CLOCK No can do!!!. */
	BusFault = 0;
	*WRCNTL2 = *WRCNTL2 | WR2_BDRST;	/* set board reset */
	slot = (*STATUSREG & STAT_SLOTMASK) >> STAT_SLOTSH;
	inv_slot = ~slot & 0x0f; 
	*WRCNTL0 = WR0_FRC_INH7 | (slot << 8) | (slot << 12) |
								(slot << 16) | (inv_slot << 20);
	*WRCNTL1 = WR1_FRC_RST_ACK | WR1_IRDY | WR1_RRDY | WR1_FMOD
			| WR1_FDEST | WR1_DATYPE | WR1_FINTREC | WR1_DREQ
			| WR1_IDLERST | WR1_RSTREC | WR1_TPOL | WR1_CSSRST
			| WR1_UFTYPE | WR1_ID_RST | WR1_4BYTE_RD
			| WR1_MOTOR | WR1_FDACK | WR1_FRES | WR1_TP
			| (slot << WR1_DEST_SH)
			| WR1_POL; 
	for(i=0;i<0x60000;i++);		/* Give it some time to wake up. */
	return(0);
}

mslot(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	register unsigned mapnum, i1;
	register unsigned char slotnum,slotadd;
	register unsigned char* i;
 
	if(clokpr(0))
		return(-1);
	if(!arg_cnt)
	{	/* display map ram contents instead.*/
		for(i1 = 0; i1 < 8; i1++)
		{
			i=(unsigned char*)((unsigned)MAPBASE | (i1 << 28));
			slotadd = (*i & 0x0f);	/* get the data. */
			slotnum = (*i >> 4) & 0x0f;
			printf("Map: %d  Slot: %X  addr: %X:\n", 
				i1, slotnum, slotadd);
		}
		printf("\n");
		return(0);
	}
	if(arg_cnt != 3)	/* else, it's bad. */
	{
		printf("Error: argument count is 3.\n");
		return(-1);
	}
	printf ("Set SPM map register.\n");
	mapnum = (unsigned)atox(comm_args[1]);
	slotnum = (unsigned char)atox(comm_args[2]);
	slotadd = (unsigned char)atox(comm_args[3]);
	i=(unsigned char*)((unsigned)MAPBASE | (mapnum << 28));
	*i = (slotnum << 4) | slotadd;
}

temp()
{
	register short result,i;
	register temp;
	register volts;

	*ADC_CNTL = ADC_SC | ADC_CH7;
	for(i=0 ; i<=0x1000; i++) {
		result=*ADC_ADATA;
		if(result & ADC_EOC)
			break;
	}
	if(i==0x1000)
		printf("\nUnsuccessful A/D conversion on channel 7\n");
	else {
		temp = *ADC_ADATA & 0x00ff;
		volts = (temp * 10000) * 176;	/* no floating point */
		temp = ((volts - 300) / 703);
		volts = temp/10000;	/* and make it an int again. */
		printf("\nCard cage temperature = %02d degrees Celsius\n",volts); 
	}
}			

char *days[]= {
	"Monday",
	"Tuesday",
	"Wednesday",
	"Thursday",
	"Friday",
	"Saturday",
	"Sunday",
};

tod(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	register struct rtc *rtcptr = RTC;

	if(arg_cnt == 0) {
		printf("\nTime: %02x:%02x:%02x", rtcptr->hour, rtcptr->min, 
			rtcptr->sec);
		printf("\nDate: %s %02x/%02x/%02x\n", 
			days[((rtcptr->day - 1) % 7)], rtcptr->month, 
			rtcptr->date, rtcptr->year);
	}
	else {
		/* stop the oscillator */
		rtcptr->control = C_WR;		/* set write bit */
		rtcptr->sec = 0x00;		/* stop bit = 0 */
		rtcptr->hour = H_KSTART;	/* kick start = 1 */
		rtcptr->control = 0x00;		/* write bit = 0 */
		sleep(2);			/* wait 2 secs */	
		rtcptr->control = C_WR;		/* set write bit */
		rtcptr->hour = 0x00;		/* kick start = 0 */
		
		/* set time and date */
		
		if(arg_cnt >= 1)
			rtcptr->hour = atox(comm_args[1]);
		if(arg_cnt >= 2)
			rtcptr->min =  atox(comm_args[2]);
		if(arg_cnt >= 3)
			rtcptr->sec = atox(comm_args[3]);
		if(arg_cnt >= 4)
			rtcptr->day = atox(comm_args[4]);
		if(arg_cnt >= 5)
			rtcptr->month = atox(comm_args[5]);
		if(arg_cnt >= 6)
			rtcptr->date = atox(comm_args[6]);
		if(arg_cnt == 7)
			rtcptr->year = atox(comm_args[7]);
		rtcptr->control = 0x00;		/* write bit = 0 */
	}
}

init_dispatcher(comm_str,arg_cnt)
{
	register unsigned mapnum;
	register unsigned char slotnum,slotadd;
	register unsigned char* i;
	register unsigned *j;

	printf ("Initialize interrupt dispatcher.\n");
	if(clokpr(0))	 /* and if it returns bad, so do we. */
		return;
	init_css();
	rready();
	iready();
	mapnum = 0;
	slotnum = 0x0b;
	slotadd = 0x0f;
	i=(unsigned char*)((unsigned)MAPBASE | (mapnum << 28));
	*i = (slotnum << 4) | slotadd;
	*WRCNTL1 &= ~WR1_ID_RST;
	*WRCNTL1 |= WR1_ID_RST;
	if(arg_cnt)
		/* setup for cpu access to dispatcher rams */
		*WRCNTL1 &= ~(WR1_FINTREC | WR1_DREQ);
	else
		*WRCNTL1 &= ~WR1_DREQ; 
	/* reset interrupt dispatcher */
	/* source slot */
	*WRCNTL0 = (*WRCNTL0 & 0xff00ffff) | 0x004b0000;
	/* slot id */
	*WRCNTL0 = (*WRCNTL0 & 0xffff00ff) | 0x0000bf00;
	/* initialize the queue ram */
	for(j=QUEUE_RAM; j<QUEUE_RAM + QUEUE_LWORDS;j++) 
		*j = ((unsigned)j << 16) | ((unsigned)j & 0x0000ffff);
	/* initialize the pointer rams */
	for(j=POINTER_RAM; j<POINTER_RAM + POINTER_LWORDS;j++)
		*j= 0x7f7f0000;
	/* initialize the miscellaneous rams */
	for(j=MISC_RAM; j<MISC_RAM + MISC_LWORDS; j++)
		*j= 0x1f0003ff;
	if(arg_cnt)
		*WRCNTL1 = (*WRCNTL1 & 0x00ffffff) | WR1_FRC_RST_ACK | WR1_IRDY
			| WR1_RRDY | WR1_FMOD | WR1_DATYPE | WR1_DREQ | WR1_CSSRST; 
	else
		*WRCNTL1 = (*WRCNTL1 & 0x00ffffff) | WR1_FRC_RST_ACK | WR1_IRDY
			| WR1_RRDY | WR1_FMOD | WR1_DATYPE | WR1_FINTREC
			| WR1_DREQ | WR1_CSSRST; 
	*WRCNTL1 &= ~WR1_ID_RST; /* reset again.. sigh. */
	*WRCNTL1 |= WR1_ID_RST;
}

jsr(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	register int (*mem)();
	register int j;
 
	mem = (int (*)())(atox(comm_args[1]));
	if(arg_cnt == 1)
		(*mem)();
	if(arg_cnt == 2)
		(*mem)(atox(comm_args[2]));
	if(arg_cnt == 3)
		(*mem)(atox(comm_args[2]),atox(comm_args[3]));
	if(arg_cnt == 4)
		(*mem)(atox(comm_args[2]),atox(comm_args[3]),atox(comm_args[4]));
	if(arg_cnt == 5)
		(*mem)(atox(comm_args[2]),atox(comm_args[3]),atox(comm_args[4]),atox(comm_args[5]));
	if(arg_cnt == 6)
		(*mem)(atox(comm_args[2]),atox(comm_args[3]),atox(comm_args[4]),atox(comm_args[5]),atox(comm_args[6]));
	if(arg_cnt == 7)
		(*mem)(atox(comm_args[2]),atox(comm_args[3]),atox(comm_args[4]),atox(comm_args[5]),atox(comm_args[6]),atox(comm_args[7]));
}


#ifdef	SPM_PROM
extern int mtinit();
exemem()
{
#define MaxSlots 16
unsigned char *MemBase,*Map;
unsigned char slot;
unsigned char i;
int laps_to_do,siz;

	HndlBerr = 1;
	MemBase=(unsigned char *)0x80000000;
	Map = (unsigned char *)MAPBASE;
	BusFault = 0; 			/* Insure BusFault hasn't been set */
	slot = atox(comm_args[1]);
					/* aim the 0th map entry at the slot */
	*Map = (unsigned char)(slot << 4);
	IntToMon = 0;
	Verbose = 1;
				/* now check to see if it's a ram board. */
#ifdef NOTNOW
	*MemBase = 0xad; 	/* Write a value to address on a slot */
	if(!BusFault) {        	/* If no bus error, read it back */
				/* If data's different, skip this slot */
		if(*MemBase == 0xad) { /* If it is what we wrote, */
				/* Figure out how much memory is there */
			for(siz=0x10000,laps_to_do=0; ; siz+=0x10000) {
				*(MemBase + siz) = 0xad;
				if(BusFault)
					break;
				else
					laps_to_do = siz+0xfffe;
			}
			BusFault = 0;
			/* Calculate how many laps of the program must be run */
			/* Pass the count to the program loader */
			mtinit(laps_to_do/32 - 1);
			if(BusFault)
				printf("ERROR: faulted.\n");
		}
	} else {
			/* Don't bother the operator, just go on */
		BusFault = 0;
	}
#else
	Verbose = 1;
	IntToMon = 1;
	HndlBerr = 0;
	/* how many 32bytes are in this board? */
	/* # * megabyte/32 - 1 */
	mtinit(  atox(comm_args[2]) * 0x8000 - 1 );
#endif
	Verbose = 1;
	IntToMon = 1;
	HndlBerr = 0;
}
#endif

set_berr_loop()
{
	HndlBerr = 0x01;
	emulate = 0x00;
	printf ("Set bus error loop\n");
}

berr_em()
{
	emulate = 0xff;
	printf ("Bus error emulation ON\n");
}

berr_em_n()
{
	emulate = 0x00;
	printf ("Bus error emulation OFF\n");
}

/*
 *	mov(comm_str, arg_cnt)
 *	char *comm_str;
 *	int arg_cnt;
 *
 *	mov<.[bwl]> src dest count  -  Move memory
 */

move_mem(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	register unsigned int dest, src, count;
	register int i;
	int	loop = 0;
	int	incr;

	src = (unsigned int)atox(comm_args[1]);
	dest = (unsigned int)atox(comm_args[2]);
	count = (unsigned int)atox(comm_args[3]);

	if(*comm_args[0] == 'l') { 	/* loop. */
		printf("Press ESC to exit.\n");
		loop = 1;
	}
	else {
		printf ("Move memory.\n");
	}

	switch(mref_siz) {
		case 'l':
			incr = 4;
			break;
		case 'w':
			incr = 2;
			break;
		case 'b':
			incr = 1;
			break;
	}

	do { 
		for(i = 0; i < count; i+=incr ) {
			emulate = 0xff;

			switch(mref_siz) {
			case 'l':
				*(unsigned int *)dest = *(unsigned int *)src; 
				break;
			case 'w':
				*(unsigned short *)dest = *(unsigned short *)src; 
				break;
			case 'b':
				*(unsigned char *)dest = *(unsigned char *)src; 
				break;
			}

			emulate = 0x00;
			dest += incr;
			src += incr;
		}

		if (loop)
			printf (".");

		if(ifesc())
			break;
		
	} while (loop);

	printf ("\n");
	return(0);
}

/*------------------------------------------------------------------------------
	compare_mem(comm_str, arg_cnt)
 	cmp<.[bwl]> dest src count  -  Compare memory
------------------------------------------------------------------------------*/
compare_mem(comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{ 
	unsigned int	start1, start2;
	register unsigned int dest, src, count, i;
	register unsigned int quit = 0;
	unsigned int looping = 0;
	unsigned int stop_on_error = 0;
	unsigned int error = 0;
	char	ret_val;

	switch (*comm_str) {
 		case 'l':
			looping = 1;
			break;
		case 'e':
			looping = 1;
			stop_on_error = 1;
			break;
	}

	start1 = (unsigned int)atox(comm_args[1]);
	start2 = (unsigned int)atox(comm_args[2]);
	count = (unsigned int)atox(comm_args[3]);
	if(!count) count = 1;		/* Default to at least one. */

	do {
		dest = start1;
		src = start2;
		emulate = 0xff;			/* Ignore bus errors. */
		for(i = 0; i < count; ) {
			switch(mref_siz) {
			case 'b':
				if(*(unsigned char *)dest != *(unsigned char *)src) {
					printf("Compare error -\n");
					printf("addr 0x%x = %x, addr 0x%x = 0x%x\n",
					dest,*(unsigned char *)dest,src,*(unsigned char *)src);
					if(stop_on_error)
						error = 1;			; /* pause & prompt on error */
				}
				dest += 1;
				src += 1;
				i += 1;
				break;
			case 'w':
				if(*(unsigned short *)dest != *(unsigned short *)src) {
					printf("Compare error -\n");
					printf("addr 0x%x = %x, addr 0x%x = 0x%x\n",dest,
					*(unsigned short *)dest,src,*(unsigned short *)src);
					if (stop_on_error)
						error = 1;			; /* pause & prompt on error */
				}
				dest += 2;
				src += 2;
				i += 2;
				break;
			case 'l':
			default:
				if(*(unsigned int *)dest != *(unsigned int *)src) {
					printf("Compare error -\n");
					printf("addr 0x%x = 0x%x, addr 0x%x = 0x%x\n",
					dest,*(unsigned int *)dest,src,*(unsigned int *)src);
					if (stop_on_error)
						error = 1;			; /* pause & prompt on error */
				}
				dest += 4;
				src += 4;
				i += 4;
				break;
			}

			if(ifesc()) {
				looping = 0;
				break;
			}

			if (error) {
				error = 0;
				printf("ESC to return to monitor, any key to continue.\n");
				if (getchar () == ESCAPE) {
					looping = 0;
					break;
				}
			}
		}
		emulate = 0x00;
	
	} while (looping);
}

#ifdef	SPM_PROM
/*------------------------------------------------------------------------------
	search_mem : search for a memory pattern as follows.
------------------------------------------------------------------------------*/
search_mem(comm_str, arg_cnt)	/* search for a memory pattern as follows.. */
char *comm_str;
int arg_cnt;
{
	register unsigned int pattern, leng;
	register unsigned char *start;
	register int i, found=0, i0, loop=0;
	char 	 chr;				

	pattern = (unsigned int)atox(comm_args[1]);
	if(pattern == pattsave)	/* same pattern.. */	
		loop = 1;	/* make it loop. */
	else
		pattsave = pattern;	/* save new one. */
	if(arg_cnt > 1)	/* if there is a two.. */
		start = (unsigned char *)atox(comm_args[2]);
	else	
		start = (unsigned char *)0; /* start it at zero.. */
	if(arg_cnt > 2)	/* if there is a two.. */
		leng = (unsigned int)atox(comm_args[3]);
	else
		leng = 0x20000;  /* only check length of whatever. */

	for(i = 0; i < leng; i++)	/* while memory to test... */
	{
		emulate = 0xff;
		got_berr = 0; /* make sure it's cleared. */
		switch(mref_siz)
		{
		case 'l':
			i0 = *(unsigned int *)start;	/* read in value. */
			break;
		case 'w':
			i0 = *(unsigned short *)start;	/* read in value. */
			break;
		case 'b':
			i0 = *(unsigned char *)start;	/* read in value. */
			break;
		case 'a':	/* ascii search.. */
			i0 = *(unsigned char *)start;	/* read in value. */
			break;
		}
		emulate = 0x00;	/* disallow bus errors. */
		if(got_berr) /* not usable memory.. */
			continue;	/* skip results, since it's bad. */
		switch(mref_siz)
		{
		case 'l':
			if((unsigned int)pattern == (unsigned int)i0)
				found =1;	/* do it. */
			break;
		case 'w':
			if((unsigned short)pattern == (unsigned short)i0)
				found =1;	/* do it. */
			break;
		case 'b':
			if((unsigned char)pattern == (unsigned char)i0)
				found =1;	/* do it. */
			break;
		}
		if(found)	/* if we finally found it.. */	
		{
			printf("Found: Address %8X\n", start); /* print it. */
			if(loop) /* more than once on the same pattern.. */
			{
				printf("Continue? (Y/N): ");
				chr = Getchar();
				if (! (Yes (chr)) ) { 
					printf("\n");
					return;	/* exit. */
				}
				found = 0;	/* skip it. */
				printf("\n");
			}
			else
				return;	/* done. */
		}
		if(ifesc()) 
		{
			printf("Search halted. (%8X)\n", start); /*loop until told not to*/
			return;
		}
		start++;	/* searches by chars.. */
	}
	printf("Pattern not found.\n");
	return;	/* it's ok anyway. */
}
#endif


#ifdef	SPM_PROM
/*------------------------------------------------------------------------------
	ipccsend: Set up MAP07 then send a command using the ipcc structure.
------------------------------------------------------------------------------*/
ipccsend(cpuslot, cmd, data)			/* Uses MAP07 for targeting. */
int cpuslot, cmd;
ulong data;
{
	register unsigned ipcmd;
	int i;

	got_berr = 0;			/* Get ready for any errors. */
	emulate = 1;			/* Set this. */

	cssmap(MAP01,cpuslot,myslot);		/* Setup the MAP before using */
	ipcmd = 0x90000000 | ((int)cmd<<8); 	/* Setup MAP1 in the BUS Ok */
	*((unsigned *)ipcmd) = (int)data;	/* Now send the command */
	if(got_berr) {				/* Failed command send. */
		printf("Bus error on send command : cpu=%x cmd=%x data=%x.\n",
		cpuslot,cmd,data);
		emulate = got_berr = 0;
		return(1);
	}
	for(i = 0; i < 7000; i++);				/* just pause here.. */
	emulate = got_berr = 0;			/* Clear the errors. */
	return(0);
}
#endif

#ifdef	SPM_PROM
/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
cssmap(mapnum,slotnum,slotadd)
register unsigned mapnum;
register unsigned char slotnum,slotadd;
{
	register unsigned char *map_ptr;
 
	map_ptr=(unsigned char*)((unsigned)MAPBASE | (mapnum << 28));
	*map_ptr = (slotnum << 4) | slotadd;
}
#endif

uchar
cssmap_save (mapnum)
register  uchar  mapnum;
{
	register uchar	*map_ptr;
	
	map_ptr = (uchar *)((unsigned)MAPBASE | (mapnum << 28));
	return (*(uchar *)map_ptr);
}

uint
cssmap_restore (mapnum, map_value)
register  uchar  mapnum;
register  uchar  map_value;
{
	register uchar *map_ptr;
	if (mapnum > NUM_CSS_MAPS)
		return (1);

	map_ptr = (uchar *)((unsigned)MAPBASE | (mapnum << 28));
	*map_ptr = (uchar)map_value;
	return (0);
}

show_em (comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	if (arg_cnt == 0) {
		show_css_table ();
		iotbl ();
		return;
	}

	if (strcmp (comm_args[1], "css") == 0) { /* show css stuff */
		show_css_table ();
		return;
	}

	if (strcmp (comm_args[1], "icb") == 0) { /* show css stuff */
		iotbl ();
		return;
	}
}
	
int
rd_iopm_tst (comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	uint	block;
	uint	count;
	uint	stat;
	
	printf ("Read IOPM device.\n");
	css_slot = (uchar)atox(comm_args[1]);
	phys_dev = (uchar)atox(comm_args[2]);
	block = atox(comm_args[3]);
	count = atox(comm_args[4]);
	if (arg_cnt == 5)
		sub_slot = (uchar)atox(comm_args[5]);
	else
		sub_slot = (uchar)NO_SUB_SLOT;

	stat = rd_iopm_dev (block, count);

	return(stat);
}

int
iopm_blk_num (comm_str, arg_cnt)
char *comm_str;
int arg_cnt;
{
	uint	block;
	
	css_slot = (uchar)atox(comm_args[1]);
	phys_dev = (uchar)atox(comm_args[2]);
	log_dev = (uchar)atox(comm_args[3]);
	if (arg_cnt == 4)
		sub_slot = (uchar)atox(comm_args[4]);
	else
		sub_slot = (uchar)NO_SUB_SLOT;

	block = get_iopm_blk_num(0);

	if (sub_slot == NO_SUB_SLOT)
		printf ("IOPM disk slice %dd%ds%d starts at %d.\n",
			css_slot, phys_dev, log_dev, block);
	else
		printf ("IOPM disk slice %d/%dd%ds%d starts at %d.\n",
			css_slot, sub_slot, phys_dev, log_dev, block);

	return(0);
}

/*------------------------------------------------------------------------------
	slot_cntl:	Calls ifenable or isdisable  which use 
			'flag' in this manner:
		
			flg == 0:  enable module and i/f
			flg == 1:  enable module
			flg == 2:  enable i/f
------------------------------------------------------------------------------*/
int
slot_cntl (comm_str, arg_cnt)
char	*comm_str;
int	arg_cnt;
{
	
	char	flag;
	uchar	slot;
	int	cnt;
	uchar	bd_id;

	switch (*comm_args[1]) {

		case 'a':		/* IF and MOD enable */
			flag = 0;
			break;
		
		case 'i':		/* IF enable only */
			flag = 2;
			break;

		case 'm':		/* MOD enable only */
			flag = 1;
			break;

		default:
			printf ("%s:  Invalid argument (%s); <if/mod/all>\n",
				comm_args[0], comm_args[1]);
			return(1);
	}

	switch (*comm_str) {
		case 'e':
			for (cnt = 2; cnt <= arg_cnt; cnt++) {
				slot = (uchar)atox(comm_args[cnt]);
				cssmap (MAP00, slot, (uchar)0x0f);
				ifenable(flag);
			}
			break;
		case 'E':
			slot = (uchar)atox(comm_args[2]);
			bd_id = (uchar)atox(comm_args[3]);
			bdhere[slot] = bd_id;
			sf.on[slot] = 1;
			cssmap (MAP00, slot, (uchar)0x0f);
			ifenable(flag);
			break;
		case 'd':
			for (cnt = 2; cnt <= arg_cnt; cnt++) {
				slot = (uchar)atox(comm_args[cnt]);
				cssmap (MAP00, slot, (uchar)0x0f);
				ifdisable(flag);
			}
			break;
		case 'D':
			slot = (uchar)atox(comm_args[2]);
			bd_id = (uchar)atox(comm_args[3]);
			bdhere[slot] = NOBOARD;
			sf.on[slot] = 0;
			cssmap (MAP00, slot, (uchar)0x0f);
			ifdisable(flag);
			break;
	}
	return(0);
}

