/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) console.c: version 25.1 created on 11/27/91 at 14:34:00	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)console.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* console routines for the cpu32 on board ascc */

#include "spm.h"
#include "ascc.h"
#include "misc.h"
#include "globl.h"
#include "rwi.h"
#include "rwicio.h"
#define CTL_Q 0x11
#define CTL_S 0x13

extern char lastchar;

#ifdef	SPM_IMAGE
extern unsigned mactime;
extern char inbuf1; /* if set, copy all chars into buffer. */
extern char forever; /* used for looping on command buffer. */
extern char frombuf;	/* set if executing from buffer.. */
extern char exitmac; /* used for looping on command buffer. */
extern char *macro;	/* pointer into buffer array. */
#endif

char escflag;	/* ok.. if press's escape, use this. */
char prtline;	/* if set, then send char to printer as well. */

con_out (c)
char c;
{
	register struct ascc *asccaptr = AUXASCC0A;
	register unsigned char i;

	   /* Wait for transmitter(s) empty */
	while(!(asccaptr->reg[0].reg & RR0_TX) && (asccaptr->reg[0].reg & RR0_DCD))
		;
	asccaptr->reg[8].reg = c;
	if(prtline == 0x5b)	/* if printing as well.. */
		prt_out(c);	/* send to printer. */
}

con_in()
{
	register struct ascc *asccaptr = AUXASCC0A;
	register unsigned i;

#ifdef	SPM_IMAGE
	cmd_int_poll();		/* test this, to see if we have something.. */
#endif

	if(asccaptr->reg[0].reg & RR0_RX) {
		i=asccaptr->reg[8].reg;
		lastchar = i;
#ifdef	SPM_IMAGE
		if(inbuf1) /* if set to copy ALL chars into buffer.. */
			*macro++ = (char) i; /* save char. */
#endif
	}
	else
		i=-1;	
	return(i);
}

prt_out (c)	/* send this character to printer port. */
char c;
{
	register struct ascc *asccaptr = AUXASCC1A; /* should be third port.. */
	register unsigned char i;

	if (ACRW_HERE)
		return;
	   /* Wait for transmitter(s) empty */
	while(!(asccaptr->reg[0].reg & RR0_TX) && (asccaptr->reg[0].reg & RR0_DCD))
		;
	asccaptr->reg[8].reg = c;
}

Getchar() /* this is used when MACRO buffer input is allowed as well. */
{
	register char c;

#ifdef	SPM_IMAGE
	if(frombuf) /* if we are reading in from the buffer.. */
		c = macchar();	/* use this character. */
	else
		while((c = con_in()) == -1); /* else, wait for one from keyboard.*/
#endif

#ifdef	SPM_PROM
	while((c = con_in()) == -1); /* else, wait for one from keyboard.*/
#endif
	return(c);
}

Putchar(c)
register char c;
{
	char in1;

	if (c != ESCAPE)
	{
		in1 = con_in(); /* get a character.. */
		if(in1==ESCAPE)	{ /* if escaped.. */
			escflag=1;	/* show it was pressed... */
#ifdef	SPM_IMAGE
			exitmac=1;	/* tell macro to exit now.. */
#endif
		}

		if(in1==CTL_S)	/* if pausing. */
			getchar(); /* wait until get another char.. */
		con_out (c);
		if (c == '\n')	/* if line feed, send return.. */
			con_out ('\r');
	}
	return;
}

ifesc() /* check for exit command.. yes? */
{
	char c;	/* buffer. */

	if(escflag) {	/* if one was pressed.. */
	
		escflag=0;	/* clear it. */
#ifdef	SPM_IMAGE
		mactime = 0;	/* make sure this is off as well. */
		forever = 0; /* clear this also.. */
		exitmac=1;	/* tell macro to exit now.. */
#endif
		return(1);	/* show it. */
	}

	if(con_in() == ESCAPE) {  /* if escape char. */
#ifdef	SPM_IMAGE
		mactime = 0;	/* kill this as well. */
		forever = 0; /* clear this also.. */
		exitmac=1;	/* tell macro to exit now.. */
#endif
		return(1);
	}
#ifdef	SPM_IMAGE
	if(mactime) {	/* if we are on macro buffer timer.. */
		if(!(--mactime))  /* if timer ran out.. */
			return(1);	/* show we got an escape. */
	}
#endif

	return(0);
}
	
