/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) cmds.c: version 25.1 created on 11/27/91 at 14:33:57	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)cmds.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "types.h"
#include "globl.h"
#include "global.h"
#include "spm.h"
#include "iom.h"
#include "menu.h"
#include "routines.h"
#include "disp.h"

extern char tsterrs;	      /* global interrupt counter */
extern char emulate;	      /* bus error emulation flag */
extern char ignore_it;	      /* if set, ignore CSS bus errors */

ifcntl(comm_str, arg_cnt)     /* send one command */
char *comm_str;
int arg_cnt;
{
	int *bog = (int *) 0xeffffffc;	/* pointer for sending commands */
	int i;
	unsigned char command; /* to hold slot number */

	printf ("Send control write.\n");

	if(arg_cnt > 1) /* set the slot */
	{
		command = (unsigned char)atox(comm_args[2]); /* set slot num */
		cssmap(MAP06, command, (unsigned char)0x0f);
	}
	command = (unsigned char)atox(comm_args[1]);         /* get slot num */
	_cache(0);		/* disable 68020 cache to bypass 68020 bug */
	emulate = tsterrs = ignore_it = 1;    /* ignore bus errors */
	*WRCNTL1 &= ~(WR1_FRES | WR1_UFTYPE); /* clear the force response bit */

	/* disable interface */
	*WRCNTL0 = (*WRCNTL0 & ~WR0_FTYPE_MASK) | command; 

	*bog = 0;	                      /* send any data, it's ignored */

	for(i = 0; i < 1000; i++) ;           /* pause */

	*WRCNTL1 |= (WR1_FRES | WR1_UFTYPE);  /* turn off forced stuff */
	emulate = tsterrs = ignore_it = 0;    /* ignore bus errors */
	_cache(1);		/* enable 68020 cache to bypass 68020 bug */
}
