/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) ckiomerr.c: version 25.1 created on 11/27/91 at 14:33:53	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)ckiomerr.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "spm.h"
#include "types.h"
#include "global.h"
#include "iom.h"
#include "misc.h"
#include "menu.h"
#include "ring.h"
#include "localmenu.h"
#include "loc_rout.h"
#include "bus.h"


char 	err_slot;
char 	lk_data_err;
char	iom_tst_flag;

#ifdef	SPM_IMAGE
extern char	parity_err;
extern char	data_err;
extern char	cmd_buff_ov;
extern char	resp_buff_ov;
extern char	time_out_flag;
extern char	resp_time_out;
extern char	source_err;
extern char	mis_match;
extern char	lk_type_err;
extern char	ioslot_err;
extern char	type_err;
#endif

#ifdef	SPM_IMAGE
iomerr(comm_str,arg_cnt)
char *comm_str;
int arg_cnt;
{
	register unsigned char iom_slot, addr ;

	if(arg_cnt < 1)	{
		return(-1);
	}

	iom_slot = (unsigned char)atox(comm_args[1]);
	iom_err(iom_slot);
}
#endif

iom_err(iom_slot)
char	iom_slot;
{
	unsigned char	cdata, src, dest, type;	
	unsigned short	wdata,*word_addr;	
	unsigned char	bdata,*byte_addr;	
	unsigned offset;
	unsigned char	upper_addr;

#ifdef	SPM_PROM
	iom_tst_flag = 0;
#endif

	offset = IOM_ERR;	/* IO module error register */
	byte_addr = (unsigned char *)CSSMAP(offset);
	upper_addr  = (unsigned char)CSSADD(offset);
	cssmap(MAP00,iom_slot,upper_addr);

	bdata = *byte_addr;	/* read IO module error register */

	if (bdata & 0xb7)	{

		if (!iom_tst_flag)
			printf("IOM Error Reg = %02x\n", bdata);

		if (bdata & 0x04)	{	/* Sbus error latched */

			offset = IOM_BUS_ERR0;
			word_addr = (unsigned short *)CSSMAP(offset);
			wdata = *word_addr;	/* read IOM bus err reg 0 */

			if (wdata & 0x3e00)	{  /* group 1 of err 0 */
				/* group 1 of bus error register0 */
				if (wdata & 0x0200)
					if (!iom_tst_flag)
						printf("DL resp buff overflow\n");
#ifdef	SPM_IMAGE
					else
						resp_buff_ov = 0xFF;
#endif
				if (wdata & 0x0400)
					if (!iom_tst_flag)
						printf("DL cmd buff overflow\n");
#ifdef	SPM_IMAGE
					else
						cmd_buff_ov = 0xFF;
#endif
					
				if (wdata & 0x0800)
					if (!iom_tst_flag)
						printf("I/O slot error\n");
#ifdef	SPM_IMAGE
					else
						ioslot_err = 0xFF;
#endif
				if (wdata & 0x1000)
					if (!iom_tst_flag)
						printf("RM seq error\n");

				if (wdata & 0x2000)
					if (!iom_tst_flag)
						printf("Bus read time-out\n");
#ifdef	SPM_IMAGE
					else
						resp_time_out = 0xFF;
#endif
			}
			/* group 2 of bus error register0 */
			if (wdata & 0x0100)	{

				/* IOM Bus error */
				if (wdata & 0x0001)
					if (!iom_tst_flag)
						printf("NACK error\n");

				if (wdata & 0x0004)
					if (!iom_tst_flag)
						printf("Data error\n");
#ifdef	SPM_IMAGE
					else
						data_err = 0xFF;
#endif
				if (wdata & 0x0008)
					if (!iom_tst_flag)
						printf("Type error\n");
#ifdef	SPM_IMAGE
					else
						type_err = 0xFF;
#endif
				if (wdata & 0x0010)
					if (!iom_tst_flag)
						printf("Resp src error\n");
#ifdef	SPM_IMAGE
					else
						mis_match = 0xFF;
#endif
				if (wdata & 0x0020)
					if (!iom_tst_flag)
						printf("Dest error\n");

				if (wdata & 0x0040)
					if (!iom_tst_flag)
						printf("Src error\n");
#ifdef	SPM_IMAGE
					else 
						source_err = 0xFF;
#endif
			}

			offset = IOM_BUS_ERR1;
			word_addr = (unsigned short *)CSSMAP(offset);
			wdata = *word_addr;	/* read IOM bus err reg 1 */
			src = (unsigned char)((wdata & 0xf000) >> 12);
			dest = (unsigned char)((wdata & 0x0f00) >> 8);
			type = (unsigned char)((wdata & 0x001f) >> 12);

			if (!iom_tst_flag) {
				printf("Src slot: %02x   ",src);
				printf("Dest slot: %02x   ",dest);
				printf("Cmd type: %02x\n",type);
			}
	
			offset = IOM_BUS_ERR2;
			word_addr = (unsigned short *)CSSMAP(offset);

			wdata = *word_addr;	/* read IOM bus err reg 2 */

			if (wdata & 0x1000)
				if (!iom_tst_flag)
					printf("Data parity\n");

			if (wdata & 0x2000)
				if (!iom_tst_flag)
					printf("Bus dest IOM\n");

			if (wdata & 0x4000)
				if (!iom_tst_flag)
					printf("IOM local grant\n");

			if (wdata & 0x8000)
				if (!iom_tst_flag)
					printf("IOM transmitter\n");

		}
		if (bdata & 0x02)	{	/* Link error */

			offset = IOM_LK_ERR0;
			word_addr = (unsigned short *)CSSMAP(offset);

			wdata = *word_addr;	/* read IOM link err reg 0 */

			if (wdata & 0x0800)
				if (!iom_tst_flag)
					printf("RM seq error\n");

			if (wdata & 0x0400)
				if (!iom_tst_flag)
					printf("UL cmd buff overflow\n");

			if (wdata & 0x0200)
				if (!iom_tst_flag)
					printf("UL resp buff overflow\n");

			if (wdata & 0x0100) {
				if (!iom_tst_flag)
					printf("Link error\n");

				if (wdata & 0x0080)
					if (!iom_tst_flag)
						printf("Strobe *\n");

				if (wdata & 0x0040)
					if (!iom_tst_flag)
						printf("Link dest error\n");

				if (wdata & 0x0020)
					if (!iom_tst_flag)
						printf("IO slot error\n");

				if (wdata & 0x0010)
					if (!iom_tst_flag)
						printf("SB slot error\n");

				if (wdata & 0x0008)
					if (!iom_tst_flag)
						printf("LK type error\n");
#ifdef	SPM_IMAGE
					else
						lk_type_err = 0xFF;
#endif
				if (wdata & 0x0004)
					if (!iom_tst_flag)
						printf("Data error\n");
#ifdef	SPM_IMAGE
					else
						parity_err = 0xFF;
#endif
				if (wdata & 0x0002)
					if (!iom_tst_flag)
						printf("ACK *\n");
	
				if (wdata & 0x0001)
					if (!iom_tst_flag)
						printf("NACK *\n");
			}
			offset = IOM_LK_ERR1;
			word_addr = (unsigned short *)CSSMAP(offset);
			wdata = *word_addr;	/* read IOM link err reg 1 */

			if (!iom_tst_flag)
				printf("Link Error Reg1 = %04x  ", wdata);

			offset = IOM_LK_ERR2;
			word_addr = (unsigned short *)CSSMAP(offset);
			wdata = *word_addr;	/* read IOM link err reg 2 */

			if (!iom_tst_flag)
				printf("Link Error Reg2 = %04x  ", wdata);

			err_slot = (char)((wdata & 0xf000) >> 12);
			lk_data_err = (char)((wdata & 0x0f00) >> 8);

			if (!iom_tst_flag) {
				printf("Error slot = %02x\n", err_slot);
				printf("DL error data = %02x\n", lk_data_err);
			}

		}
		if (bdata & 0x01)	{	/* Down Link error */
			offset = IOM_DL_ERR; /* IOM down link error register */
			byte_addr = (unsigned char *)CSSMAP(offset);
			bdata = *byte_addr;	/* read IOM down link err reg */
			if (!iom_tst_flag)
				printf("DL Error Reg = %2x  ", bdata);
		}

		if (bdata & 0x80)	/* Bus grant timeout */
			if (!iom_tst_flag)
				printf("IOM bus grant time-out\n");
#ifdef	SPM_IMAGE
			else
				time_out_flag = 0xFF;
#endif
		if (bdata & 0x20)	/* Bus grant timeout */
			if (!iom_tst_flag)
				printf("IOM local bus grant time-out\n");

		if (bdata & 0x10)	/* Bus grant timeout */
			if (!iom_tst_flag)
				printf("IOM interrupt request time-out\n");
	}
#ifdef	SPM_IMAGE
	else
		printf ("IOM OK in slot %02x \n", iom_slot);
#endif
}

