/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) boot_path.c: version 25.1 created on 11/27/91 at 14:33:49	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)boot_path.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "types.h"
#include "disp.h"
#include "sa_dir.h"
#include "dev.h"
#include "icb.h"
#include "icb_config.h"

#define 	Sbus_Num_Slot		16
#define 	BAD_BOOT_TYPE		(uint)0
#define 	ICB_BOOT_TYPE		(uint)1
#define 	IOPM_BOOT_TYPE		(uint)2

void	get_device_info();
void	display_help_message ();
void	find_icb_bootable ();
uint	check_boot ();

extern	uint  iopm_bootable ();

extern	unsigned char	bdhere [];
extern  struct  icb_config  io_conf[][MAXSLOTS];

uchar	css_slot;
uchar	sub_slot;
uchar	phys_dev;
uchar	log_dev;
char	filename[MAX_DIR_NAME];
uint	boot_type;
struct	icb_config	*icb_ptr;

void
get_device_info(str)
char	*str;
{
	int	i;
	uint	boot_flag;
	uint	tmp;

	filename[0] = '\0';
	css_slot = 0;
	sub_slot = NO_SUB_SLOT;
	phys_dev = 0;
	log_dev = 0;
	boot_type = DV_NO_DEV;
	icb_ptr = (struct icb_config *)0;

	if (*str == '?') {
		boot_type = DV_HELP_REQUEST;
		return;
	}

	if (!isdigit(*str)) {

		printf("Incorrect device specification %s\n",str);
		boot_type = DV_NO_DEV;
		return;
		
	}

	css_slot = (uchar)atoi(str);
	if (css_slot >= Sbus_Num_Slot) {
		printf("Invalid CSS slot number %x (%d)\n", css_slot, css_slot);
		boot_type = DV_NO_DEV;
		return;
	}

	while (isdigit(*str))
		++str;

	if (*str == '/') {
		str++;
		if (isdigit (*str)) {
			sub_slot = (uchar)atoi(str);
			while (isdigit(*str))
				++str;
		}
		else {
			printf ("Illegal subslot specification - not a digit\n");
			boot_type = DV_NO_DEV;
			return;
		}
	}
	else {
		sub_slot = NO_SUB_SLOT;
	}

	boot_flag = check_boot ();

	if (boot_flag == BAD_BOOT_TYPE) {
		boot_type = DV_NO_DEV;
		return;
	}


	switch (*str) {
	case 'm':
	case 'n':
		if (boot_flag == IOPM_BOOT_TYPE)
			boot_type = (*str == 'm') ? DV_IOPM_MT : DV_IOPM_9T;

		if (boot_flag == ICB_BOOT_TYPE)
			boot_type = (*str == 'm') ? DV_MT : DV_9T;

		if (*++str != 't') {
			printf("Incorrect tape device specification %s\n",str);
			boot_type = DV_NO_DEV;
			return;
		}

		str++;
		if (isdigit (*str)) {
			phys_dev = (uchar)atoi(str);
			while (isdigit (*str))
				++str;
		}

		break;
	case 'd':
		str++;
		if (isdigit (*str)) {
			phys_dev = (uchar)atoi(str);

			while (isdigit(*str))
				str++; 
		}
		else {
			printf ("Illegal drive number - not a digit\n");
			boot_type = DV_NO_DEV;
			return;
		}

		if (boot_flag == IOPM_BOOT_TYPE) {

			if (str[0] == 's' && isdigit (str[1])) {
				log_dev = (uchar)atoi(++str);
				while (isdigit(*str))
					str++;
			
				boot_type = DV_IOPM_DK;
			}
			else {
				boot_type = DV_IOPM_RV;
			}
		}

		if (boot_flag == ICB_BOOT_TYPE)
			boot_type = DV_RV;
		break;
	default : 
		printf("Incorrect device specification %s\n",str);
		boot_type = DV_NO_DEV;
		return;

	}
	strcpy (filename, str);
	return;
}

static char *help_message[] = {
#ifdef	SPM_PROM
"   X/Ymt[#]file | X/Ynt[#]file | X/Yd#file | X/Yd#s#file | flp/file; where",
#endif
#ifdef	SPM_IMAGE
"   X/Ymt[#]file | X/Ynt[#]file | X/Yd#file | X/Yd#s#file; where",
#endif
"   X = css slot (IOM or IOPM)",
"   Y = sub slot (EDT or SCSI)",
"   mt - archive; nt - nine track; d# - disk reserved; d#s# - disk slice",
#ifdef	SPM_PROM
"   flp/ - indicates floppy boot device",
#endif
"   Note:  \"/Y\" is null for an IOPM in the CSS",
"\n   Use the 'show' command to display system configuration",
""
} ;

void
display_help_message()
{
	int i = 0;

	printf("\n");
	while (*help_message[i]) {
		printf(help_message[i++]);
		printf("\n");
	}
	printf("\n");
	return;
}

void
find_icb_bootable ()
{
	uchar	css;
	char	iom_num = 0;	

	for (css = 0; css != css_slot; css++) 
		if (bdhere[css] == IOMHERE)
			iom_num++;
	
	if ((io_conf[iom_num][sub_slot].icb_slot_id == EDT) || 
	   (io_conf[iom_num][sub_slot].icb_slot_id == SCSI))
		icb_ptr = &io_conf[iom_num][sub_slot];

	return;
}	

uint
check_boot ()
{
	uint	boot_flag = BAD_BOOT_TYPE;

	if (sub_slot == NO_SUB_SLOT) {

		if ((bdhere[css_slot] & BDTYPEMASK) == IOPTYPE) {

			if (iopm_bootable (css_slot)) {
				return(IOPM_BOOT_TYPE);
			}
			else {
				printf ("IOPM in slot %x (%d) not bootable.\n",
					css_slot, css_slot);
				return(BAD_BOOT_TYPE);
			}
		}
		else {
			printf ("IOPM boot selected, no IOPM in slot: %x (%d)\n",
				css_slot, css_slot);
			return(BAD_BOOT_TYPE);
		}
	}

	if (bdhere[css_slot] != IOMHERE) {
		printf ("IOM boot selected, no IOM in slot %x (%d).\n", 
				css_slot, css_slot);
		return(BAD_BOOT_TYPE);
	}

	find_icb_bootable ();
	if (icb_ptr == (struct icb_config *)0) {
		printf ("No EDT/SCSI controller in subslot: %x (%d)\n",
				sub_slot, sub_slot);
		return(BAD_BOOT_TYPE);
	}

	return(ICB_BOOT_TYPE);
}

