/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) adc.c: version 25.1 created on 11/27/91 at 14:33:40	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)adc.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "types.h"
#include "novram.h"
#include "spm.h"
#include "rwi.h"
#include "rwicio.h"

#define ADC_START 0x0100
#define TIMEOUT 10000

extern struct novram *novram;
unsigned int ps_num;

/*------------------------------------------------------------------------------
	readsensor : This should read the Analog to Digital sensor and return
                     the value read.
		     If the timer times out then it returns a 0.
------------------------------------------------------------------------------*/

readsensor(mux_sel, chan_num)
int mux_sel;	/* mux selection */
int chan_num;	/* channel number */
{
 	unsigned short read_data = 0;
	unsigned int timer = 0;
	unsigned short *mux_chan = MUX_LE;
	unsigned short *adc_ctrl=ADC_CTRL_PORT;	/* AD control port address */
	unsigned short *adc_data=ADC_DATA_PORT;	/* AD data port address */

	if (ACRW_HERE)
		return(0);	/* no sensors in an ACRW system */

	*mux_chan = (unsigned short)mux_sel;		/* select proper mux */
	*adc_ctrl = (unsigned short)chan_num | ADC_START; /* start conversion */

	while(!(read_data & 0x8000) && (timer++ < TIMEOUT))	/* do or die */
		read_data = *adc_data;				/* read data */

	if(timer >= TIMEOUT) 			/* return timed out */
		return(0);
#ifdef DEBUG
	printf("Chan:%x: mux:%x: data:%x:\n",chan_num,mux_sel,read_data & 0x00ff);
#endif
	return(read_data & 0x00ff);		/* return value */
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
adc_conv(type,number,tenths)
register unsigned int	type, number, tenths;
{
	register unsigned int result;

	tenths = tenths * ONE_THOUSAND;
	result = number * TEN_THOUSAND;
	result = result + tenths;

	switch(type) {
		case INLET_AIR:
		case EXHAUST_AIR:
		case PS_TEMP:
		case CAGE_AIR:
			result = result * VOLTS_PER_DEGREE;
			result /= VOLTS_PER_BIT;
			result /= TEN_THOUSAND;
			break;
		case MAIN_FIVE_VOLT:
		case LOCAL_FIVE_VOLT:
		case AUX_FIVE_VOLT:
			result /= FIVE_VOLTS_PER_BIT;
			break;
		case MAIN_TWELVE_VOLT:
		case LOCAL_TWELVE_VOLT:
		case AUX_TWELVE_VOLT:
			result /= TWELVE_VOLTS_PER_BIT;
			break;
		case LOCAL_NEG_TWELVE_VOLT:
		case AUX_NEG_TWELVE_VOLT:
		case MAIN_NEG_TWELVE_VOLT:
			/* result = 0 when voltage is equal to -25.92 volts */
			/* change rate = -118.8 volts/bit */
			/* 0x00	= -25.92 */
			/* 0x75 = 12.00 */
			/* 0xda =  0.00 */
			result = (NEG_TWELVE_MAX - result) / 
						NEG_TWELVE_VOLTS_PER_BIT;
			if(result >= NEG_TWELVE_ZERO)
				result = 0;
			break;
		case MAIN_FIVE_VOLT_CURRENT:
			result *= novram->main_pwr[ps_num].scale_factor;
			result /= VOLTS_PER_BIT; 
			result /= TEN_THOUSAND;
			break;
		case LOCAL_VREF:
			result /= VOLTS_PER_BIT;
			break;
		default:
			break;
	}
 	return(result);
}

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/
conv_adc(type,result,number,tenths)
uint	type, *number, *tenths;
register int	result;
{
	switch(type) {
		case INLET_AIR:
		case EXHAUST_AIR:
		case PS_TEMP:
		case CAGE_AIR:
			result *= TEN_THOUSAND;
			result *= VOLTS_PER_BIT;
			result = (result - VOLTAGE_OFFSET) / VOLTS_PER_DEGREE;
			break;
		case MAIN_FIVE_VOLT:
		case LOCAL_FIVE_VOLT:
		case AUX_FIVE_VOLT:
			result *= FIVE_VOLTS_PER_BIT;
			break;
		case MAIN_TWELVE_VOLT:
		case LOCAL_TWELVE_VOLT:
		case AUX_TWELVE_VOLT:
			result *= TWELVE_VOLTS_PER_BIT;
			break;
		case LOCAL_NEG_TWELVE_VOLT:
		case AUX_NEG_TWELVE_VOLT:
		case MAIN_NEG_TWELVE_VOLT:
			/* result = 0 when voltage is equal to -25.92 volts */
			/* change rate = -118.8 volts/bit */
			/* 0x00	= -25.92 */
			/* 0x75 = 12.00 */
			/* 0xda =  0.00 */
			if(result >= NEG_TWELVE_ZERO) 
				result = 0;
			else
				result = NEG_TWELVE_MAX - 
					    (NEG_TWELVE_VOLTS_PER_BIT * result); 
			break;
		case MAIN_FIVE_VOLT_CURRENT:
			result *= TEN_THOUSAND;
			result *= VOLTS_PER_BIT; 
			result /= novram->main_pwr[ps_num].scale_factor;
			break;
		case LOCAL_VREF:
			result *= VOLTS_PER_BIT;
			break;
		default:
			break;
		}
		if(result < 0) result = 0;
		*number = result / TEN_THOUSAND;
		*tenths = result % TEN_THOUSAND;
		*tenths = *tenths / ONE_THOUSAND;
}

/*------------------------------------------------------------------------------
	overtmp: This will read the current temperature, and do some conversion,
		 then compare it with the warning and shutdown values.
------------------------------------------------------------------------------*/
overtmp()
{
 	register int wrk;		/* work area to store sensor data */
	unsigned int num0,tens0;
	unsigned int num1,tens1;

	wrk = readsensor(INLET_AIR,0); 		/* get the reading */

	conv_adc(INLET_AIR,wrk,&num0,&tens0);	/* current temperature */

#ifdef DEBUG
	printf("Card Cage temperature = %02d.%d C\n",num0,tens0);
#endif

	conv_adc(INLET_AIR,novram->inlet_air_low_shutdown,&num1,&tens1);
	if ((num0 <= num1) || ((num0 == num1) && (tens0 <= tens1)))
		return(1);

	conv_adc(INLET_AIR,novram->inlet_air_high_shutdown,&num1,&tens1);
	if ((num0 >= num1) || ((num0 == num1) && (tens0 >= tens1)))
		return(1);

	conv_adc(INLET_AIR,novram->inlet_air_low_warning,&num1,&tens1);
	if ((num0 <= num1) || ((num0 == num1) && (tens0 <= tens1))) {
		printf("\nLOW WARNING TEMPERATURE HAS BEEN REACHED.\n");
		return(0);
	}
	conv_adc(INLET_AIR,novram->inlet_air_high_warning,&num1,&tens1);
	if((num0 >= num1) || ((num0 == num1) && (tens0 >= tens1))) {
		printf("\nHIGH WARNING TEMPERATURE HAS BEEN REACHED.\n");
		return(0);
	}
	return(0);
}

