/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) ms_rtns.c: version 25.1 created on 11/27/91 at 14:32:40	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)ms_rtns.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	ms_rtns.c -routines that talk directly to the useq
 *
 *	- load uSeq program into static ram
 *	- clear all tables in uSeq ram
 *	- start execution of uSeq program
 *
 *	this program requires the file mscode.o, which is made
 *	from a data file by hextoc, and is the hex output of the
 *	uSeq program assembler
 *
 *	02-02/90 - gh01 - pass all chars upstream in tyd_read, not just 1st char
 *	02-26-90 - gh02 - process 'delay_msg' instead of freeing if FLUSHW rcv'd
 *	03-02-90 - gh03 - keep copy of hardware dtr regs (hardware write only)
 *			- set  'ms_start' and 'ms_stop' even if IXON not set
 *	03-06-90 - gh04 - don't send 'xon' if input stopped because of ioctl
 *	03-22-90 - gh05 - ignore input from port unless port is completely open
 *	07-12-90 - gh06 - check TTUSE in case called from 'bufcall' - IOPTTYVER5
 */
#include "sys/types.h"
#include "sys/user.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/stream.h"
#include "sys/strstat.h"
#include "sys/stropts.h"
#include "sys/signal.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/gctio.h"
#include "sys/termio.h"
#ifdef SAK
#include "sys/sakioctl.h"
#endif /* SAK */
#include "sys/tyd_tty.h"
#include "sys/strlog.h"
#include "sys/memdev.h"
#include "sys/tyd_clog.h"
#include "sys/cir_log.h"
#include "sys/tyd_sram.h"
#include "sys/tyd_uart.h"
#include "sys/sysinfo.h"
#include "sys/str_conf.h"
/*------------------------------------------------------------------*/
extern int tyd_cir_log_debug;	/* set non-zero to enable tyd_cir_log */
extern int tyd_cir_log_init_flag; /* non-zero if cur_log initialized */

extern int tyd_cir_index;	/* number of next tyd_cir_log_buf entry */

extern struct  cir_log	*tyd_cir_ptr;  /* ptr to next tyd_cir_log_buf entry */
extern struct	cir_log	tyd_cir_log_buf[TYD_CIR_LOG_SIZE];
/*------------------------------------------------------------------*/
extern int tyd_debug;		/* set non-zero to enable tyd_log */
/*------------------------------------------------------------------*/
#define LOG_DEBUG	tyd_debug
#define	LOG_RTN		tyd_log

#define CIRLOG_DEBUG	tyd_cir_log_debug
#define	CIRLOG_RTN	tyd_cir_logit

#include "sys/debuglog.h"
/*------------------------------------------------------------------*/
#define TYD_MOD		123
#define TYD_MSIZE	1024		/* max data msg size we will send up */
/*------------------------------------------------------------------*/
typedef struct	termio  termio_t;

mblk_t *tyd_alloc();
mblk_t *tyd_wsrv_data();

int	tyd_timer();

extern tyd_tty_t *tyd_tp_tab[];			/* check for activity in poll*/
extern int	tyd_timer_time;
extern int	tyd_timer_count;
extern int	tyd_poll_timer_id;		/* id of tyd_timer */
extern int	tyd_poll_timer_init;
extern uint	tyd_input_count;		/* no. characters received */
extern uint	tyd_output_count;		/* no. characters written */

extern int	ms_size;
extern uint	ms_code[];
int	tyd_ms_debug_flag = 0;	/* set non-zero to enable useq debugging */
int	ms_debug_step = 0; /* set to number of useq steps to execute */
int	ms_debug_addr = -1; /* set to address to stop at */
int	tyd_spin = 0;

tyd_tty_t tyd[TYD_NUM_PORTS];		/* one struct per port */
struct module_stat r_stat[TYD_NUM_PORTS]; /* one read module stat per port */
struct module_stat w_stat[TYD_NUM_PORTS]; /* one write module stat per port */
tyd_tty_t *tyd_tp_tab[TYD_NUM_PORTS];	/* check for activity in poll*/
int	tyd_num_ports = TYD_NUM_PORTS;

unchar *ms_debug_ctl_addr = NULL;
#define MS_MAX_STEP 63
ushort 	ms_debug_pc_buf[MS_MAX_STEP+1];
unchar	ms_debug_ctl_buf[sizeof(struct ms_ctl)];

int	ms_initialized = 0;		/* non-zero = useq initialized */

int	tyd_break_flag = 1;

/* one byte per 8 ports: if bit is set, dtr is raised for that port
 * bit 0 of first byte = port 0
 * bit 7 of first byte = port 7
 * bit 7 of last byte = port TYD_NUM_PORTS - 1
 */
char	dtr_reg_copy[TYD_NUM_PORTS/8];
/*------------------------------------------------------------------*/
/*
 *	baud rate conversion table, used to get the number to write
 *	to the COM78808 based on the value in cflag
 */
unchar	baud_table[] =
{
/*	COM78808 value		cflag value	speed */
/*	--------------		-----------	----- */
	0,			/*  0		    0	hang up */
	0,			/*  1		   50 */
	1,			/*  2		   75 */
	2,			/*  3		  110 */
	3,			/*  4		  134.5 */
	4,			/*  5		  150 */
	0xff,			/*  6		  200	not supported */
	5,			/*  7		  300 */
	6,			/*  8		  600 */
	7,			/*  9		 1200 */
	8,			/* 10		 1800 */
	10,			/* 11		 2400 */
	12,			/* 12		 4800 */
	14,			/* 13		 9600 */
	15,			/* 14		19200 */
	0xff,			/* 15		38400	not supported */
};
/* note: 2000 baud (COM78808 value = 9) and 7200 baud (COM78808 value = 13)
	 are not available to the user at this time */
/*------------------------------------------------------------------*/
/*
 *	baud_wait table - number of milliseconds  * 4 to wait for a
 *			  data byte to be output, depending on speed
 *
 *		the '* 4' is because it only takes 1/2 millisecond for
 *		a data byte to be output at 19200, and a simple way to
 *		express 1/2 in hex is to multiply by a constant first.
 *		4 was picked so later support for 38400 could be added
 *		(1/4 millisecond for one byte at 38400)
 *
 *	- indexed by speed in cflag
 */
#define BAUD_SCALE	4

int	baud_wait[] =
{
/*	no mills * 4		cflag value	speed */
/*	--------------		-----------	----- */
	0,			/*  0		    0	not supported */
	800,			/*  1		   50 */
	600,			/*  2		   75 */
	400,			/*  3		  110 */
	300,			/*  4		  134.5 */
	267,			/*  5		  150 */
	0,			/*  6		  200	not supported */
	133,			/*  7		  300 */
	67,			/*  8		  600 */
	33,			/*  9		 1200 */
	22,			/* 10		 1800 */
	17,			/* 11		 2400 */
	8,			/* 12		 4800 */
	4,			/* 13		 9600 */
	2,			/* 14		19200 */
	1,			/* 15		38400 */
};
/*------------------------------------------------------------------*/
ttydvrinit()
{
	static struct str_config  strconf;
	extern struct streamtab   ttydvrinfo;

	strconf.sc_version = SC_VERSION;
	strconf.sc_strtab = &ttydvrinfo;
	strconf.sc_start = 0;
	attach_streams_driver( &strconf );

	tyd_init();
}/*------------------------------------------------------------------*/

tyd_msinit()
{
	register unchar *ptr;
	register uint *iptr;
	register uint *msptr;
	register i;
	register count;
	struct ms_ctl *ms_ctl_ptr;
	uint tmp, first_port, last_port, j, mask;

	if (ms_initialized != 0)
		return;		/* non-zero = useq initialized */
	ms_initialized = 1;

	bzero(r_stat, sizeof(struct module_stat) * TYD_NUM_PORTS);
	bzero(w_stat, sizeof(struct module_stat) * TYD_NUM_PORTS);

	/* keep board halted, set RESET = 0 to reset board */
	*SRAM_CONTROL_REG = 0;		/*!RESET resets device board */
	for (i = 0; i < 10; i++)
		;			/* wait for board to complete reset */

	/* now set RESET bit to enable access to uSeq code space */
	*SRAM_CONTROL_REG = SRAM_CTL_RESET;	/*disable RESET */
	/* init uSeq code space first, then load program on top, in case
	   the program has holes
	   talk to useq code space 32 bits at a time, otherwise bus error */

	iptr = (uint *)START_OF_SRAM_CODE;
	for (i = 0; i < SRAM_CODE_SIZE/4; i++)
		*(iptr++) = 0;		/* set all of uSeq code space to 0 */

	iptr = (uint *)START_OF_SRAM_CODE;
	msptr = &ms_code[0];
	for (i = 0; i < ms_size; i++)
		*(iptr++) = *(msptr++);		/* load uSeq code */

	/* now set SEQEN bit to enable access to buffers */
	*SRAM_CONTROL_REG = SRAM_CTL_RESET |	/*disable RESET */
			    SRAM_CTL_SEQEN|	/*allow access to sram buffers*/
			    0;			/* !HALT keep useq halted */

	*SRAM_CONTROL_REG = 0;		/*!RESET resets device board */
	*SRAM_CONTROL_REG = SRAM_CTL_RESET;	/*disable RESET */
	*SRAM_CONTROL_REG = SRAM_CTL_RESET |	/*disable RESET */
			    SRAM_CTL_SEQEN|	/*allow access to sram buffers*/
			    0;			/* !HALT keep useq halted */

	ptr = START_OF_SRAM_SPEC_TAB;
	count = TYD_NUM_PORTS * 32;	/* 32 * 8 = 256 bits, 1 bit per char */
	for (i = 0; i < count; i++)
		*(ptr++) = 0;		/*clear special char tbl for each port*/

	ptr = START_OF_SRAM_BUF;
	count = TYD_NUM_PORTS * sizeof(struct ms_ctl);
	for (i = 0; i < count; i++)
		*(ptr++) = 0;		/*clear control tbls for each port */

	/* check to see how many (and which) ace cards are plugged in */
	/* xxxxx110 = ace # 1
	   xxxxx101 = ace # 2
	   xxxxx011 = ace # 3 */
	ptr = ACE_ID;
	for (i = 0; i < 3; i++, ptr += ACE_SIZE)
	{
		tmp = *ptr;
		tmp = (~tmp) & 7;	/* mask off lower 3 bits & compliment */
		mask = 1 << i;		/* check for 001, 010, 100 */
		if (tmp != mask)
		{
			first_port = (i + 1) * TYD_PORTS_PER_ACE;
			last_port = first_port + TYD_PORTS_PER_ACE;
			ms_ctl_ptr = (struct ms_ctl *)START_OF_SRAM_BUF;
			ms_ctl_ptr += first_port;
			for (j = first_port; j < last_port; j++, ms_ctl_ptr++)
				/* flag port as not available */
				ms_ctl_ptr->ms_status |= MSS_DISABLED;
		}
	}
	ptr = START_OF_SRAM_INPUT;
	count = TYD_NUM_PORTS * (256 + 256); /* 256 for input, 256 for output */
	for (i = 0; i < count; i++)
		*(ptr++) = 0;		/*clear control tbls for each port */

	ptr =  START_OF_OCTARTS;
	for (i = 0; i < TYD_NUM_PORTS/8; i++)
	{
		dtr_reg_copy[i] = 0xff;		/*drop our copy of 8-port dtr*/
		*(ptr + UT_DTR_OFFSET) = 0xff;	/*drop dtr for 8 ports */
		*(ptr + UT_LOOP_OFFSET) = 0x0f;	/*disable loopback for 8 ports*/
		ptr += OCTART_SIZE;
	}

	*SRAM_CONTROL_REG = SRAM_CTL_PC_TO_0 |	/*allow pc counter to advance*/
			    SRAM_CTL_HALT |	/* don't halt useq */
			    SRAM_CTL_RESET |	/*disable device board reset*/
			    SRAM_CTL_SEQEN;	/*let uSeq access uSeq code */
}/*------------------------------------------------------------------*/
tyd_ms_debug()
{
	register int i;
	register unchar *ptr;

	tyd_ms_debug_flag = 0;	/* set non-zero to enable useq debugging */
	if (ms_debug_step != 0) /* set to no. of useq steps to execute */
	{
		*SRAM_CONTROL_REG &= ~SRAM_CTL_HALT;	/* stop useq */
		for (i = 0; i < ms_debug_step; i++)
		{
			*SRAM_CONTROL_REG |= SRAM_CTL_STEP;	/* step useq */
			*SRAM_CONTROL_REG &= ~SRAM_CTL_STEP;
			ms_debug_pc_buf[i] = *SRAM_PC_REG; /* useq pc addr */
		}
		ms_debug_pc_buf[i] = -1;	/* flag end of buffer */
		ms_debug_step = 0;
	}
	else if (ms_debug_addr != -1)	/* set to address to stop at */
	{
		*SRAM_CONTROL_REG &= ~SRAM_CTL_HALT;	/* stop useq */
		for (i = 0; i < MS_MAX_STEP; i++) /* only so many steps */ 
		{
			*SRAM_CONTROL_REG |= SRAM_CTL_STEP;	/* step useq */
			*SRAM_CONTROL_REG &= ~SRAM_CTL_STEP;
			if ((ms_debug_pc_buf[i] = *SRAM_PC_REG) ==ms_debug_addr)
				break;
		}
		ms_debug_addr = -1;	/* set to address to stop at */
	}
	if (ms_debug_ctl_addr != NULL)
	{
		ptr = ms_debug_ctl_addr;
		for (i = 0; i < sizeof(struct ms_ctl); i++)
			*(ptr++) = *(ms_debug_ctl_buf + i);
	}
}/*------------------------------------------------------------------*/
/*
 *	INTERRUPT FROM TIMER
 *
 *------------------------------------------------------------------*
 *
 *	tyd_timer - check for output ready and input available
 */
int tyd_timer_toggle = 0;	/* non-zero = look at highest port first */
int tyd_timer_debug = 0; 	/* non-zero = call qenable instead of tyd_read*/

tyd_timer()
{
	register tyd_tty_t *tp;
	register i, j;
	register status;	/* new port eia status */
	unchar ms_event;
	extern queue_t *qhead;
	queue_t *rq;
	struct ms_ctl *sram_ctl;	/* ptr to input control struct in sram*/
	int bytes_in_inbuf;		/* no. bytes in input buffer in sram */

#ifdef TTYDEBUG_TIME
	extern int	tyd_timer_elapsed_time;
	int	tmp, tmp1;
	int start_time, elapsed_time;

	start_time = get_time_stamp();
	tmp = get_time_stamp();
	if ((tmp1 = tmp - tyd_timer_time) > tyd_timer_elapsed_time)
		tyd_timer_elapsed_time = tmp1;
	if (++tyd_timer_count >= HZ)
	{ 
		tyd_timer_count = 0;
		tyd_timer_elapsed_time = 0;
		BUGCIR_LOG(tyd_num_ports, tmp1, 0,TYD_CIR_TEST1, 10);
	}
	tyd_timer_time = tmp;
#endif /* TTYDEBUG_TIME */
	for (i = 0; i < TYD_NUM_PORTS; i++)
	{
		if (tyd_timer_toggle != 0)
			j = TYD_NUM_PORTS - 1 - i;
		else	j = i;
		if ((tp = tyd_tp_tab[j]) == NULL)
			continue;
		/* gh05 - ignore input from port unless port is open */
		if ((ms_event = tp->sram_ctl->ms_event) != 0
		  && tp->state & ISOPEN)
		{
			/* if waiting for msg and only input pending,
			   don't enable queue */
			if (ms_event & ~(MSE_INPUT_PENDING|MSE_OUTPUT_START_TRY))
				tyd_event(tp, ms_event);
			/* don't try to start output until the read service so
			 * that, if the char is a delete key (VINTR), it will
			 * have a chance to get to the streams module upstream
			 * (which will normally flush all queues), before we
			 * really start output. I. e., we don't want to send
			 * out what we have pending if we are stopped and the
			 * user hits the delete key, but this decision must be
			 * made by the tty module upstream. This change gives
			 * that module the chance to flush our buffers before
			 * we start up the output (assuming IXANY set)
			 */
			if (ms_event & MSE_OUTPUT_START_TRY)
				qenable(tp->rq);

			if (!(tp->state & WAITING_FOR_MSG)
			 && ms_event & MSE_INPUT_PENDING)
			{
				rq = tp->rq;
			  	if (!(rq->q_next->q_flag & (QFULL|QENAB))
				  && !(rq->q_flag & QENAB))
				{
					sram_ctl = tp->sram_ctl;
					bytes_in_inbuf = 
						(sram_ctl->ms_in_tail -
						 sram_ctl->ms_in_head) & 0xff;
				/*have tyd_rsrv call tyd_read if not half full*/
					if (bytes_in_inbuf < MS_HALF_BUF_SIZE
					 || tyd_timer_debug)
						qenable(rq);
					else	tyd_read(tp);
				}
			}
		}
		status = tyd_get_eia_status(tp);
		if ((status & (T_DCD | T_DSR)) != (tp->state & (T_DCD | T_DSR)))
		/* eia change */
			tyd_process_eia_change(tp, status);
		if (tp->sram_ctl->ms_out_head != tp->sram_ctl->ms_out_tail)
			tp->output_in_progress = 1;
		else	tp->output_in_progress = 0;
	}
	tyd_timer_toggle ^= 1;		/* switch directions every other pass */

	/* call this same routine on the next clock tick */
	tyd_poll_timer_id = timeout(tyd_timer, (tyd_tty_t *)NULL,1);
	if (tyd_ms_debug_flag != 0) /* set non-zero to enable useq debugging */
		tyd_ms_debug();
#ifdef TTYDEBUG_TIME
	elapsed_time = get_time_stamp() - start_time;
	BUGCIR_LOG(tyd_num_ports,elapsed_time, 0, TYD_CIR_TEST1,11);
#endif /* TTYDEBUG_TIME */
}/*------------------------------------------------------------------*/
tyd_rsrv(rq)
register queue_t *rq;
{
	register tyd_tty_t	*tp;

	tp = (tyd_tty_t *)rq->q_ptr;
	ASSERT(tp != NULL);
	tp->rq_stat->ms_scnt++;		/* bump count of read service calls */
	/* see if there are any messages on our own read queue */
	if (!(tp->state & WAITING_FOR_MSG)	/* if not waiting for msg */
	  && (tp->sram_ctl->ms_event & MSE_INPUT_PENDING))
		tyd_read(tp);	/* see if uSeq has data in S-ram */

	if (tp->sram_ctl->ms_event & MSE_OUTPUT_START_TRY)
	{	/* uSeq would like to send X-ON to terminal*/
		tp->sram_ctl->ms_event &= ~MSE_OUTPUT_START_TRY;
		BUGCIR_LOG(tp->min_dev,0,0,TYD_CIR_EV_OUTPUT_START,tp->state);
		BUGLOG1(tp,BUG_LERR, "output x-oned rq=%x", rq);
		tp->state &= ~T_TXSTOP;
		tyd_see_if_we_can_start_output(tp);
	}
}/*------------------------------------------------------------------*/
/*
 *		process events from the useq other that INPUT_PEINDING
 *
 *   1. when the poll timer expires, 'tyd_timer()' scans the event flag
 *	for each port, and for each port that has one or more events
 *	pending, the read queue is enabled.
 *
 *   2. When 'tyd_rsrv()' is called, each non-data event is processed
 *	and that event flag is cleared.
 *
 *   3. Then, if there is input data available, 'qenable()' is
 *	called for that port to enable the read service, 'tyd_rsrv()'
 *
 *   4. Finally, 'tyd_read()' is called to see if any data has been received
 *	from that device. All available data is put into one or more streams
 *	messages and sent upstream. The only possible messages that could
 *	be on this queue are data messages that were put on this queue
 *	because 'canput()' said they could not be sent upstream.
 *
 *	The possible non-data events that can occur are:
 *
 *	OVERRUN			set when input buffer wraps
 *	INPUT_STOPPED		set if X-OFF sent
 *	INPUT_STARTED		set if X-ON  sent
 *	OUTPUT_STOPPED		set if X-OFF received
 *	BREAK			set if break occurred 
 *
 * Argument: rq	read queue pointer
 */
tyd_event(tp, ms_event)
tyd_tty_t *tp;
unchar	ms_event;
{
	register unchar *event_ptr;	/* addr of event byte in input control*/
	queue_t *rq;
	unchar	dev;

	event_ptr  = &(tp->sram_ctl->ms_event);
	rq = tp->rq;
	dev = tp->min_dev;
	/* one or more non-data events occurred, see what they are */
	if (ms_event & MSE_OUTPUT_STOPPED)
	{	/* uSeq sent an X-OFF to terminal */
		*event_ptr &= ~MSE_OUTPUT_STOPPED;
		BUGCIR_LOG(dev,0,0,TYD_CIR_EV_OUTPUT_STOP,tp->state);
		BUGLOG1(tp,BUG_LERR,"output x-offed rq=%x", rq);
		tp->state |= T_TXSTOP;
	}
	if (ms_event & MSE_OVERRUN)
	{	/* lost data, output only log msg for now */
		*event_ptr &= ~MSE_OVERRUN;
		BUGCIR_LOG(dev,0,0,TYD_CIR_EV_OVERRUN,0);
		BUGLOG1(tp, BUG_LERR, "overrun rq=%x", rq);
	}
	/* check if input stopped */
	if (ms_event & MSE_INPUT_STOPPED)
	{
		*event_ptr &= ~MSE_INPUT_STOPPED;
		BUGCIR_LOG(dev,0,0,TYD_CIR_EV_INPUT_STOP,tp->state);
		if (!(tp->state & T_RXSTOP))
		{
			tp->state |= T_RXSTOP;
			BUGLOG1(tp,BUG_LERR, "input x-offed rq=%x",rq);
		}
		if (tp->sram_ctl->ms_in_head ==tp->sram_ctl->ms_in_tail
		 && !(tp->state & TBLOCK))
			tyd_send_xon(tp);	/* input empty */
	}
	/* check if input started, for debug/monitoring only */
	if (ms_event & MSE_INPUT_STARTED)
	{
		*event_ptr &= ~MSE_INPUT_STARTED;
		BUGCIR_LOG(dev,0,0,TYD_CIR_EV_INPUT_START,tp->state);
		if (tp->state & T_RXSTOP)
		{
			tp->state &= ~T_RXSTOP;
			BUGLOG1(tp,BUG_LERR,"input x-oned rq=%x", rq);
		}
	}
	if (ms_event & MSE_BREAK)
	{
		*event_ptr &= ~MSE_BREAK;
		BUGCIR_LOG(dev,0,0,TYD_CIR_EV_BREAK,0);
		BUGLOG0(tp, BUG_LGEN, "break received");
#ifdef SAK
		if (tp->sak.flags & SAK_BREAK)
			tyd_sak_event(tp);
		else	putctl(rq->q_next, M_BREAK);	/* send break upstream*/
#else
		putctl(rq->q_next, M_BREAK);	/* send break upstream*/
#endif /* SAK */
	}
}/*------------------------------------------------------------------*/
/*
 *	tyd_read - see if uSeq has data in S-ram
 *
 *	this routine attempts to move data from uSeq Ram to a
 *	streams message and pass the message upstream for processing
 *
 *	the buf_head points to the next byte to be removed from a buffer
 *	the buf_tail points to the next byte to be stored in a buffer
 *
 *	hence, for output, the driver uses the tail pointer
 *	while, for  input, the driver uses the head pointer
 *
 */
tyd_read(tp)
register tyd_tty_t	*tp;
{
	int bytes_in_inbuf;/* no. bytes in input buffer in sram */
	int in_head;		/* offset from base to head of input buf */
	int in_tail;		/* offset from base to tail of input buf */
	register unchar *msptr;		/* ptr to data in input buffer in sram*/
	register unchar *wptr;		/* ptr to data in streams msg */
	register i;
	unchar tmp, c;
	int chars_this_call;

	struct ms_ctl *sram_ctl;/* ptr to input control struct in sram*/
	mblk_t	*bp;		/* addr of M_DATA streams msg to send upstream*/
	int	total_room_in_msg; /*no. bytes that can be stored in msg*/
	int	bytes_this_msg;	/*no. bytes to actually store in msg*/
	int	bytes_to_move;	/* no. bytes to move at one time into msg */

	BUGLOG1(tp, BUG_LGEN, "tyd_read rq=%x", tp->rq);
	if (!(tp->state & TTUSE))
		return;			/* gh06 */
	tp->state &= ~WAITING_FOR_MSG;	/*msg is available */
	sram_ctl = tp->sram_ctl;
	in_head = sram_ctl->ms_in_head;
	in_tail = sram_ctl->ms_in_tail;
	chars_this_call = 0;
	while (in_head != in_tail)		/* while data in input buf */
	{
		bytes_in_inbuf = (in_tail - in_head) & 0xff;
		/* 'bytes_in_inbuf' should always be smaller than TYD_MSIZE,
		   but we do this just in case the buffer size or TYD_MSIZE
		   changes in the future */
		if (bytes_in_inbuf <  TYD_MSIZE)
			bytes_this_msg = bytes_in_inbuf;/*bytes this msg*/
		else	bytes_this_msg = TYD_MSIZE;	/*max msg size*/

		/* work our way down the different message sizes until
		   we either get a message or we get to the smallest size */
		bp = NULL;
		for (i = bytes_this_msg; i > 3; i >>= 1)
		{
			if ((bp = allocb(i, BPRI_MED)) != NULL)
				break;
		}
		if (bp == NULL
		 && (bp = tyd_alloc(4,BPRI_MED,tyd_read, tp)) == NULL)
		{	/* can't do any processing until streams message avail*/
			tyd_send_xoff(tp);
			tp->state |= WAITING_FOR_MSG;/*wait for available msg*/
			BUGLOG1(tp,BUG_LERR,"tyd_read no buf, rq=%x",tp->rq);
			return;
		}
		/* calculate the max amount of room in this msg */
		total_room_in_msg = bp->b_datap->db_lim - bp->b_datap->db_base;

		/* the no. of bytes we copy is the smaller of what will
		   actually fit in the msg and what is in the input buffer */
		if (total_room_in_msg < bytes_in_inbuf)
			bytes_this_msg = total_room_in_msg;
		else	bytes_this_msg = bytes_in_inbuf;
		while (bytes_this_msg != 0)
		{
			/* move in one step if data does not wrap, else
			   move in two steps if data wraps:
			   1. move from current loc to end of buffer
			   2. move from start of buffer to tail
			 */
			if (bytes_this_msg <  MS_BUF_SIZE - in_head)
				bytes_to_move = bytes_this_msg;
			else	bytes_to_move = MS_BUF_SIZE - in_head;
			if (bytes_to_move == 0)
				break;
			msptr = tp->sram_in_base + in_head; /*sram addr*/
			wptr = bp->b_wptr;	/* streams msg data block*/
			tyd_input_count += bytes_to_move;
			chars_this_call += bytes_to_move;
			sysinfo.rcvint += bytes_to_move;	/* stats */
			tp->pv_rstat.rcvin += bytes_to_move;	/* stats */
#ifdef SAK
/* gh01 - pass all characters upstream if available, not just first char */
			if (!(tp->sak.flags & SAK_KEYS))
			{
				for (i = 0; i < bytes_to_move; i++)
					*(wptr++) = *(msptr++);
			}
			else	for (i = 0; i < bytes_to_move; i++)
			{
				c = *(msptr++);
				*(wptr++) = c;
				switch(tp->sak_count)
				{
				case 0:
					if (c == tp->sak.sak_key1)
					{
						if (tp->sak.flags & SAK_1KEY)
						{
							tyd_sak_event(tp);
							return;
						}
						else	tp->sak_count++;
					}
					break;
				case 1:
					if (c == tp->sak.sak_key2)
					{
						if (tp->sak.flags & SAK_2KEYS)
						{
							tyd_sak_event(tp);
							return;
						}
						else	tp->sak_count++;
					}
					else	tp->sak_count = 0;
					break;
				case 2:	 /* SAK_3KEYS must be set to get here */
					if (c == tp->sak.sak_key3)
					{
						tyd_sak_event(tp);
						return;
					}
					else	tp->sak_count = 0;
					break;
				} /* switch(tp->sak_count) */
			}
#else
			for (i = 0; i < bytes_to_move; i++)
				*(wptr++) = *(msptr++);
#endif /* SAK */
			BUGCIR_LOG(tp->min_dev,
				(*(tp->sram_in_base + in_head) << 8) |
				chars_this_call,
				sram_ctl->ms_event,TYD_CIR_EV_INPUT,
				(in_head << 8) | sram_ctl->ms_in_tail);
			if ((in_head += bytes_to_move) >= MS_BUF_SIZE)
				in_head = 0;		/* buffer wrap */
			bp->b_wptr = wptr;
			bytes_this_msg -= bytes_to_move;
		}
		/* we now have the data moved into a stream message; send
		   it upstream */
		sram_ctl->ms_in_head = in_head;
		putnext(tp->rq, bp);	/* send data upstream */
	}
	sram_ctl->ms_event &= ~MSE_INPUT_PENDING;
	if (sram_ctl->ms_in_head != sram_ctl->ms_in_tail)
		sram_ctl->ms_event |= MSE_INPUT_PENDING;
	tyd_enable_receiver(tp);
	tp->sram_ctl->ms_in_limit = in_head + MS_LIMIT_SIZE;

	/* gh04 - if input is blocked, unblock it (start input going again)
	 * unless input stopped because of ioctl
	 */
	tmp = tp->sram_ctl->ms_status;
	if (!(tp->state & TBLOCK)
	 && (tp->state & T_RXSTOP || tmp & MSS_INPUT_STOPPED))
		tyd_send_xon(tp);
	/* if we have an activity timer running, looking for input or output,
	   restart the timer since we got input */
	if (tp->t_gctio.gt_tact != 0)
	{
		/* if activity timer running, turn off before restarting timer*/
		tyd_stop_act_timer(tp);
		tyd_start_act_timer(tp);
	}
}/*------------------------------------------------------------------*/
/*
 *		WRITE SERVICE - DATA
 *
 *------------------------------------------------------------------*
 *
 *	process write data - called from service routine
 *
 *	we only get here on M_DATA messages
 *
 *	the buf_head points to the next byte to be removed from a buffer
 *	the buf_tail points to the next byte to be stored in a buffer
 *
 *	hence, for output, the driver uses the tail pointer
 *	while, for  input, the driver uses the head pointer
 *
 * 	return	mp	if unable to process
 *		NULL	if processes successfully
 */
mblk_t *
tyd_wsrv_data(mp, tp)
register mblk_t		*mp;
register tyd_tty_t	*tp;
{
	register bytes_in_outbuf;/* no. bytes already in output buffer */
	register bytes_to_move;	/* no. bytes to copy to output buffer */
	register room_in_outbuf;/* space in outbuf from tail to end of buffer*/
	register bytes_in_msg;	/* no. bytes in message */
	int out_head; /* offset from base to head of output buf */
	int out_tail; /* offset from base to tail of output buf */
	struct	ms_ctl *sram_ctl; /* addr of sram control block*/
	register unchar	*msptr;		/* addr of next byte to get in sram */
	register unchar	*rptr;		/* addr of next byte in streams msg */
	mblk_t	*next;		/* addr of next msg block in msg */
	register i;
	int	n;

	/* if we have an activity timer running, looking for input or output,
	   restart the timer since we have data to output */

	/*  NOTE: THIS TIMER WILL NOT BE ACCURATE SINCE IT DOES NOT MEASURE
	    FROM THE TIME THE LAST BYTE IS OUTPUT BY THE MICROSEQUENCER, BUT
	    BUT INSTEAD MEASURES FROM THE TIME THE LAST BYTE IS PASSED TO
	    THE MICROSEQUENCER; IT CAN BE OFF BY AS MUCH AS THE TIME REQUIRED
	    TO OUTPUT A FULL MICROSEQUENCER BUFFER (256 BYTES CURRENTLY) */

	ASSERT(mp->b_datap->db_type == M_DATA);
	if (tp->t_gctio.gt_tact != 0)
	{
		/* if activity timer running, turn off before restarting timer*/
		tyd_stop_act_timer(tp);
		tyd_start_act_timer(tp);
	}
	sram_ctl = tp->sram_ctl;
	out_head = sram_ctl->ms_out_head;
	out_tail = sram_ctl->ms_out_tail;

	/* move as many bytes as we can into the output buffer in Static ram
	   each loop will either:
	   1. empty out one streams message,
	   2. fill S-ram to end of buffer, or
	   3. fill up S-ram
	*/
	if (mp != NULL)
	{
		BUGCIR_LOG(tp->min_dev, mp->b_wptr - mp->b_rptr,
	 				*mp->b_rptr,TYD_CIR_WRITE_DATA,(int)mp);
	}
	while (mp != NULL && (bytes_in_msg = mp->b_wptr - mp->b_rptr) != 0)
	{
		/* calculate number of bytes already in output buffer */
		bytes_in_outbuf = (out_tail - out_head) & 0xff;
		if (tp->state & (NO_OUTPUT_ALLOWED | T_SUSPEND | T_TXSTOP)
		 || bytes_in_outbuf >= tp->ms_out_max
		 || tp->sram_ctl->ms_command & MS_FLUSH_XMIT_BUF)
		{
			/* no room for more data */
			/* turn on 'output_pending timer' if allowed to */
			tyd_enable_transmitter(tp);
			if (!(tp->state&(NO_OUTPUT_ALLOWED|T_SUSPEND|T_TXSTOP)))
				tyd_restart_out_pending_timer(tp);
			BUGCIR_LOG(tp->min_dev, 0, 0,TYD_CIR_RPUTBQ3,mp);
			return(mp);	/* 'unable to process data */
		}
		/* calculate total room available in outbuf */
		bytes_to_move = MS_BUF_SIZE - bytes_in_outbuf - 1; 
		if (bytes_in_msg < bytes_to_move)
			bytes_to_move = bytes_in_msg;
		while (bytes_to_move != 0)
		{
			/* move in one step if data does not wrap, else
			   move in two steps if data wraps:
			   1. move from current loc to end of buffer
			   2. move from start of buffer to tail
			 */
			room_in_outbuf = MS_BUF_SIZE - out_tail;
			rptr = mp->b_rptr;
			msptr = tp->sram_out_base + out_tail;
			if (room_in_outbuf <  bytes_to_move)
				n = room_in_outbuf;
			else	n = bytes_to_move;
			BUGCIR_LOG(tp->min_dev,out_head,out_tail,TYD_CIR_WCOPY,
				 (int)((n << 16) + ((int)msptr & 0xffff))); 
			tyd_output_count += n;
			for (i = 0; i < n; i++)
				*(msptr++) = *(rptr++);
			sysinfo.xmtint += n; /* bump count of bytes output*/
			tp->pv_wstat.xmtin += n; /* bump count of bytes output*/
			if ((out_tail += n) >= MS_BUF_SIZE)
				out_tail = 0;		/* sram buffer wrap */
			bytes_to_move	-= n;
			bytes_in_msg	-= n;
			mp->b_rptr	= rptr;
		}
		sram_ctl->ms_out_tail = out_tail;
		if (bytes_in_msg == 0)
		{
			next = mp->b_cont;	/* next msg block in msg */
			freeb(mp);		/* free this message block */
			mp = next;
		}
	}
	tyd_enable_transmitter(tp);
	return(NULL);
}/*------------------------------------------------------------------*/
/*
 *	tyd_iflag_program
 *
 *	set uSeq control_flag and special character table
 *	based on settings in iflag
 */
tyd_iflag_program(tp)
register tyd_tty_t	*tp;
{
	register iflag;			/* input mode flag */
	register ms_iflag;	/* copy of ms control_flag */
	register i;
	register struct ms_ctl   *sram_ctl;
	unchar spec_tab[32];		/* local copy of special char tab */
	unchar *sc_ptr;			/* addr of spec char tab in sram*/

	unchar	i_xon;		/* index into spec_tab for un_stripped X-ON*/
	unchar	i_xof;		/* index into spec_tab for un_stripped X-OFF*/

	unchar	xon_mask;	/* bit index into spec_tab byte for X-ON */
	unchar	xof_mask;	/* bit index into spec_tab byte for X-OFF */

	sram_ctl = tp->sram_ctl;
	iflag = tp->termio.c_iflag;
	ms_iflag = 0;
	if (iflag & IGNBRK)
		ms_iflag |= MS_IGNBRK;
	if (iflag & BRKINT)
		ms_iflag |= MS_BRKINT;
	if (iflag & IGNPAR)
		ms_iflag |= MS_IGNPAR;
	if (iflag & PARMRK)
		ms_iflag |= MS_PARMRK;
	if (iflag & INPCK)
		ms_iflag |= MS_INPCK;
	if (iflag & IXOFF)
		ms_iflag |= MS_IXOFF;
	if (iflag & ISTRIP)
		ms_iflag |= MS_ISTRIP;
	if (iflag & IXANY)
		ms_iflag |= MS_IXANY;
	tp->ms_iflag = ms_iflag;		/* copy for debugging */
	sram_ctl->ms_ctl_flag = ms_iflag;

	for (i = 0; i < 32; i++)
		spec_tab[i] = 0;	/* clear spec char tbl in local ram*/
	if (iflag & PARMRK && !(iflag & ISTRIP))
	/* tell uSeq to look for 0xff as a special character*/
		spec_tab[31] |= 0x80;

	/* now set the appropriate bits in the special character table
	   so the uSeq will automatically know when certain
	   characters are received. The table is 32 bytes long, which
	   means there is one byte in the table for each possible ascii byte.
	   the upper 5 bits of an ascii byte points to a particular byte
	   in the 32-byte table, while the lower 3 bits is an index within
	   that byte (e.g., the ascii letter 'A' in hex is 0x41, with the
	   upper 5 bits being 8 (01000 in binary) and the lower 3 bits
	   is 1. to flag this as a special character, OR in the value 2
	   in the 9th byte of the table (8 = 9th byte, 2 = 2nd bit) */
	if (iflag & IXON)	/* tell ms X-ON & X-OFF are special */
	{
			/* X-ON character */
		i_xon = (tp->xonc >> 3) & 0x1f; /* index into 32-byte tbl */
		xon_mask = 1 << (tp->xonc & 7); /* index into byte */
			/* X-OFF character */
		i_xof = (tp->xofc >> 3) & 0x1f; /* index into 32-byte tbl */
		xof_mask = 1 << (tp->xofc & 7); /* index into byte */

		spec_tab[i_xon] |= xon_mask;
		spec_tab[i_xof] |= xof_mask;
		if (iflag & ISTRIP || (tp->termio.c_cflag & CSIZE) != CS8)
		{
			/* recognize stripped version of char */
			spec_tab[i_xon & 0xf] |= xon_mask;
			spec_tab[i_xof & 0xf] |= xof_mask;

			/* recognize unstripped version of char */
			spec_tab[(i_xon & 0xf) | 0x10] |= xon_mask;
			spec_tab[(i_xof & 0xf) | 0x10] |= xof_mask;
		}
	}
 	/* gh03	- set  'ms_start' and 'ms_stop' even if IXON not set */
	sram_ctl->ms_start = tp->xonc;
	sram_ctl->ms_stop  = tp->xofc;
	/* modify special character table in sram for this device */
	for (i = 0, sc_ptr = tp->sram_spec_tab; i < 32; i ++, sc_ptr++)
		*sc_ptr = spec_tab[i];
}/*------------------------------------------------------------------*/
/*
 *	routines which communicate with the uSeq
 *
 *---------------------------------------------------------------------*/
/*
 *	initialize sram pointers, tables
 */
tyd_init_pointers(tp)
register tyd_tty_t	*tp;
{
	register octart_num;	/* octart number for this device */
	register unchar *sramptr;	/* used to zero out sram in buf tbl */
	register unchar *octart_base;	/* addr of octart containing this port*/
	register i;
	uint	dev;

 	dev = (uint)tp->min_dev;	/* relative device no. on board */

	/* --- control table (flags, pointers, etc.) for this device --- */
	sramptr = START_OF_SRAM_BUF + (sizeof(struct ms_ctl) * dev);
	tp->sram_ctl = (struct ms_ctl *)sramptr;
	for (i = 0; i < sizeof(struct ms_ctl); i++)
		*sramptr++ = 0;	/* zero out control tbl for this device */

	/* --- special character table for this device --- */
	tp->sram_spec_tab = (unchar *)((32 * dev) + START_OF_SRAM_SPEC_TAB);
	/* --- input character buffer for this device --- */
	tp->sram_in_base = (unchar *)((dev << 9) + START_OF_SRAM_INPUT);
	/* --- output character buffer for this device --- */
	tp->sram_out_base = tp->sram_in_base + 256; 

	/* set up octart/uart pointers for this device */
	octart_num = (dev & (TYD_NUM_PORTS - 1)) >> 3;
	octart_base = (unchar *)((octart_num * OCTART_SIZE) + START_OF_OCTARTS);

	/* --- dtr register for every device in this octart --- */
	tp->octart_dtr_reg = octart_base + UT_DTR_OFFSET;
	tp->dtr_reg_mask = 1 << (dev & 7);

	/* --- base address of uart for this device --- */
	tp->uartptr = octart_base + ((dev & 7) * UT_OFFSET);

	tp->ms_out_max = MS_BUF_SIZE - 6;	/* max no bytes in out buf*/
	tp->sram_ctl->ms_in_limit = tp->sram_ctl->ms_in_head + MS_LIMIT_SIZE;
	tp->sram_ctl->dev = dev & 0xff;	/* for debugging dumps of ms_ctl */
}/*------------------------------------------------------------------*/
/*
 *	see if ace board present for this port
 *
 *	return	0 if ace board present
 *		1 if not present
 */
tyd_check_if_port_available(dev)
dev_t dev;
{
	struct ms_ctl *ms_ctl_ptr;

	ms_ctl_ptr = (struct ms_ctl *)START_OF_SRAM_BUF;
	ms_ctl_ptr += (uint)dev;
	if (ms_ctl_ptr->ms_status & MSS_DISABLED)
		return(1);
	else	return(0);
}/*------------------------------------------------------------------*/
/*
 *	tell uSeq to send an X-ON character to terminal
 *	to start input going again
 */
tyd_send_xon(tp)
register tyd_tty_t	*tp;
{
	tp->state &= ~(TBLOCK | T_RXSTOP);
	if (tp->termio.c_iflag & IXOFF) /* if terminal understands X-ON/X-OFF */
	{
		BUGCIR_LOG(tp->min_dev,0, tp->sram_ctl->ms_status, TYD_CIR_XON, tp->state);
		tp->sram_ctl->ms_spec_char = tp->xonc;
		tp->sram_ctl->ms_command |= MS_SEND_SPEC_CHAR;
		tyd_enable_transmitter(tp);
	}
}/*------------------------------------------------------------------*/
/*
 *	tell uSeq to send an X-OFF character to terminal
 *	to stop input from terminal
 */
tyd_send_xoff(tp)
register tyd_tty_t	*tp;
{
	if (tp->termio.c_iflag & IXOFF) /* if terminal understands X-ON/X-OFF */
	{
		BUGCIR_LOG(tp->min_dev,0,0,TYD_CIR_XOF, NULL);
		tp->state |= T_RXSTOP;
		tp->sram_ctl->ms_spec_char = tp->xofc;
		tp->sram_ctl->ms_command |= MS_SEND_SPEC_CHAR;
		tyd_enable_transmitter(tp);
	}
}/*------------------------------------------------------------------*/
#ifdef SAK
/*
 *	secure attention key
 *
 *------------------------------------------------------------------*/
/*
 *	secure attention key (SAK) event occurred
 */
tyd_sak_event(tp)
register tyd_tty_t	*tp;
{
	tyd_stop_act_timer(tp);
	tyd_flush_read_side(tp);
	tyd_flush_write_side(tp);
	putctl1(tp->rq->q_next, M_FLUSH, FLUSHR|FLUSHW);
	if (putctl1(tp->rq->q_next, M_PCSIG, SIGSAK) == 0)
		tyd_sak_wait_for_buf(tp->rq);
}/*------------------------------------------------------------------*/
tyd_sak_wait_for_buf(rq)
register queue_t *rq;
{
	register size;
	mblk_t	*bp;

	for (size = 4; size < TYD_MSIZE; size += size)
	{
		if ((bp = allocb(size, BPRI_HI)) != NULL)
			break;
	}
	if (bp == NULL)		/* no msgs in system !!! */
		timeout(tyd_sak_wait_for_buf, rq, HZ);
	else
	{
		bp->b_datap->db_type = M_PCSIG;
		*bp->b_wptr++ = SIGSAK;
		putnext(rq, bp);
	}
}/*------------------------------------------------------------------*/
#endif /* SAK */
/*
 *	flush handling
 *
 *------------------------------------------------------------------*/
tyd_flush_write_side(tp)
register tyd_tty_t	*tp;
{
	flushq(tp->wq, FLUSHALL);		/* flush streams write queue */
	/* flush uSeq output queue */
	tp->sram_ctl->ms_command |= MS_FLUSH_XMIT_BUF;
	/* don't enable transmitter for flush since 'tyd_start_output' will */
	tyd_start_output(tp);
	/* gh02 - process possible 'delay_msg' normally so IOCTLs are acked */
	tp->output_in_progress = 0;
	tyd_process_msg_output_empty(tp);	/*do output empty step*/
}/*------------------------------------------------------------------*/
/* flush uSeq input queue */
tyd_flush_read_side(tp)
tyd_tty_t	*tp;
{
	flushq(tp->rq, FLUSHALL);		/* flush streams read queue */
	tp->sram_ctl->ms_in_head = tp->sram_ctl->ms_in_tail;
	tp->sram_ctl->ms_in_limit = tp->sram_ctl->ms_in_head + MS_LIMIT_SIZE;
	if (tp->sram_ctl->ms_status & MSS_INPUT_STOPPED)
		tyd_send_xon(tp);
}/*------------------------------------------------------------------*/
/*
 *	start up output
 *
 *	clear any suspend condition and any output flow control
 */
tyd_start_output(tp)
register tyd_tty_t	*tp;
{
	tp->state &= ~(T_SUSPEND|T_TXSTOP);
	tp->sram_ctl->ms_event &= ~MSE_OUTPUT_START_TRY;
	tp->sram_ctl->ms_command &= ~MS_STOP_OUTPUT;
	tp->sram_ctl->ms_command |= MS_START_OUTPUT;
	qenable(tp->wq);
	tyd_enable_transmitter(tp);
}/*------------------------------------------------------------------*/
tyd_stop_output(tp, reason)
register tyd_tty_t	*tp;
uint	reason;
{
	tp->state |= reason;
	tp->sram_ctl->ms_command |= MS_STOP_OUTPUT;
}/*------------------------------------------------------------------*/
/* this routine is called when the 'output pending' timer expires
 * hence we now want to enable the output service routine to see if
 * we can again transfer data to the microsequencer
 */
tyd_out_pending_expired(tp)
register tyd_tty_t	*tp;
{
	tp->timer_enable &= ~OUTPUT_PENDING_TIMER;
	if (!(tp->state & (NO_OUTPUT_ALLOWED | T_SUSPEND | T_TXSTOP)))
		qenable(tp->wq);
}/*------------------------------------------------------------------*/
tyd_check_if_output_empty(tp)
register tyd_tty_t	*tp;
{
	int old_total_delay;	/* no. mills to wait for all byte to go out*/

	ASSERT(tp != NULL);
	if (tp->timer_enable & OUTPUT_EMPTY_TIMER)
	{
		tp->timer_enable &= ~OUTPUT_EMPTY_TIMER;
		untimeout(tp->output_empty_id);
	}
	old_total_delay = tp->total_delay;
	if ((tp->total_delay = tyd_compute_delay(tp)) == 0)
	{
		tp->output_in_progress = 0;
		tyd_process_msg_output_empty(tp);	/*do output empty step*/
	}
	else
	{
		tp->output_in_progress = 1;
		if (tyd_see_if_output_is_busy(tp))
		{	/* if transmit interrupt are enabled */
			/* output in progress, wait for it to empty */
			if (!(tp->timer_enable & OUTPUT_EMPTY_TIMER) &&
			    tp->total_delay == old_total_delay)
			{
				BUGLOG0(tp, BUG_LERR, "output stuck");
				tyd_start_output(tp);
			}
		}
		else if (tp->state & (T_SUSPEND|T_TXSTOP) && tp->t_closing != 0)
			tyd_start_output(tp);
		/*flag 'output_empty timer on'*/
		tp->timer_enable |= OUTPUT_EMPTY_TIMER;
		tp->output_empty_id =
			timeout(tyd_check_if_output_empty,tp,tp->total_delay);
	}
}/*------------------------------------------------------------------*/
tyd_restart_out_pending_timer(tp)
register tyd_tty_t	*tp;
{
	if (tp->timer_enable & OUTPUT_PENDING_TIMER)
		untimeout(tp->out_pending_id);
	tp->total_delay = tyd_compute_delay(tp)/2;	/* wait til 1/2 empty */
	if (tp->total_delay == 0)
		tp->total_delay = 1;
	tp->out_pending_id
		= timeout(tyd_out_pending_expired, tp, tp->total_delay);
	tp->timer_enable |= OUTPUT_PENDING_TIMER;
}/*------------------------------------------------------------------*/
/*
 *	compute amount of time it should take for the output buffer to empty
 *
 *	return	number of clock ticks (0 if buffer is empty)
 */
tyd_compute_delay(tp)
register tyd_tty_t	*tp;
{
	register struct ms_ctl *sram_ctl;
	int one_delay;		/* no. mills needed to output one byte */
	int total_delay_mills;	/* no. mills needed to output msq buffer */
	int total_delay;	/* no. clock ticks needed to output msq buffer*/
	int bytes_in_outbuf;

	sram_ctl = tp->sram_ctl;
	bytes_in_outbuf = sram_ctl->ms_out_tail - sram_ctl->ms_out_head;
	if (sram_ctl->ms_command & MS_FLUSH_XMIT_BUF || bytes_in_outbuf == 0)
		return(0);
	if (bytes_in_outbuf < 0)	/* deal with wrap of cir. buf */
		bytes_in_outbuf += MS_BUF_SIZE;
	one_delay = baud_wait[tp->termio.c_cflag & CBAUD];
	total_delay_mills = one_delay * bytes_in_outbuf;
	/* now convert milliseconds (times BAUD_SCALE) to clock ticks */
	total_delay = (total_delay_mills * HZ)/(1000 * BAUD_SCALE);

	/*round up, plus one more tick because next tick may be about to occur*/
	total_delay += 2;
	return(total_delay);
}/*------------------------------------------------------------------*/
/*
 *	routines that talk directly to the COM78808
 *
 *------------------------------------------------------------------*
 *
 *	tyd_cflag_program - program uart for this port
 */
tyd_cflag_program(tp, cflag)
register tyd_tty_t	*tp;
register cflag;
{
	register	mode_1;		/* mode 1 register */
	register	mode_2;		/* mode 2 register */
	register	cmd_reg;	/* command register */
	register	unchar *uartptr;

	/* if baud rate == B0, drop dtr */
	if ((cflag & CBAUD) == B0)
	{
		tyd_turn_off_dtr(tp);
		tp->termio.c_cflag = cflag;		/* control mode flag */
		return;
	}
	else	tyd_turn_on_dtr(tp);
	/* don't allow switch to unsupported baud rate (keep old speed) */
	if (baud_table[cflag & CBAUD] == 0xff)
		cflag = (tp->termio.c_cflag & CBAUD) | (cflag & ~CBAUD);
	tp->termio.c_cflag = cflag;		/* control mode flag */
	mode_1  = 0;
	if (cflag & CSTOPB)
		mode_1 |= UT_MODE_STOP2;	/* 2   stop bits */
	else	mode_1 |= UT_MODE_STOP1;	/* 1   stop bit */
	if (cflag & PARENB)
	{
		if (cflag & PARODD)
			mode_1 |= UT_MODE_PAR_O;	/* odd  parity */
		else	mode_1 |= UT_MODE_PAR_E;	/* even parity */
	}
	else	mode_1 |= UT_MODE_PAR_N;		/* no   parity */
	switch (cflag & CSIZE)
	{
		case CS5: mode_1 |= UT_MODE_CS5;	/* 5-bit byte */
			break;
		case CS6: mode_1 |= UT_MODE_CS6;	/* 6-bit byte */
			break;
		case CS7: mode_1 |= UT_MODE_CS7;	/* 7-bit byte */
			break;
		case CS8: mode_1 |= UT_MODE_CS8;	/* 8-bit byte */
			break;
	} /* switch (cflag & CSIZE) */
	mode_2 = baud_table[cflag & CBAUD]; /* convert to baud hardware knows*/
	mode_2 |= (mode_2 << 4);	/* transmit and receive are same speed*/

	cmd_reg = UT_CMD_OMNO  |	/* operating mode = normal operation */
		  UT_CMD_RxEN  |	/* receiver enable */
		  UT_CMD_TxIE  |	/* transmitter interrupt enable */
		  UT_CMD_TxEN;		/* transmitter enable */

	if (cflag & CREAD)		/* enable receiver if CREAD */
		  cmd_reg |= UT_CMD_RxIE;	/* receiver interrupt enable */
	if (tp->state & BREAK_IN_PROGRESS)
		  cmd_reg |= UT_CMD_TxBRK;	/* transmit break */

	uartptr = tp->uartptr;
	tp->cmd_reg = *(uartptr + UT_COMMAND); /*read cmd reg points to mode 1*/
	/* store in tp->cmd_reg rather than in junk,because if we use junk,
	   the compiler optimizer deletes the read into junk */
	*(uartptr + UT_MODE) = mode_1;  /*1st write=mode 1 after cmd read*/
	*(uartptr + UT_MODE) = mode_2;  /*2nd write automatically mode 2*/
	*(uartptr + UT_COMMAND) = cmd_reg | UT_CMD_RERR;
	*(uartptr + UT_COMMAND) = cmd_reg;
	tp->mode_1 = mode_1;
	tp->mode_2 = mode_2;
	tp->cmd_reg = cmd_reg;
}/*------------------------------------------------------------------*/
/*
 *	return non-zero if output in progress
 */
tyd_see_if_output_is_busy(tp)
register tyd_tty_t	*tp;
{
	return(*(tp->uartptr + UT_COMMAND) & UT_CMD_TxIE);
}/*------------------------------------------------------------------*/
/*
 *	enable transmit interrupts for a device
 */
tyd_enable_transmitter(tp)
register tyd_tty_t	*tp;
{
	*(tp->uartptr + UT_COMMAND) |= UT_CMD_TxIE | UT_CMD_TxEN;
}/*------------------------------------------------------------------*/
/*
 *	enable receive interrupts for a device
 */
tyd_enable_receiver(tp)
register tyd_tty_t	*tp;
{
	*(tp->uartptr + UT_COMMAND) |= UT_CMD_RxIE | UT_CMD_RxEN;
}/*------------------------------------------------------------------*/
/*
 *	turn on dtr by setting dtr bit to zero
 */
tyd_turn_on_dtr(tp)
register tyd_tty_t	*tp;
{
	int octart = tp->min_dev/8;		/* octart number */

	/* gh03 - keep track of dtr in ram since hardware is write-only */
	dtr_reg_copy[octart] &= ~tp->dtr_reg_mask;	/* turn on DTR */
	*(tp->octart_dtr_reg) = dtr_reg_copy[octart];
	tp->state |= T_DTR_SET;				/* flag DTR on*/
}/*------------------------------------------------------------------*/
/*
 *	turn off dtr by setting dtr bit to one
 */
tyd_turn_off_dtr(tp)
register tyd_tty_t	*tp;
{
	int octart = tp->min_dev/8;		/* octart number */

	dtr_reg_copy[octart] |= tp->dtr_reg_mask;	/* turn off DTR */
	*(tp->octart_dtr_reg) = dtr_reg_copy[octart];
	tp->state &= ~T_DTR_SET;			/* flag DTR off*/
}/*------------------------------------------------------------------*/
/*
 *	tell uart to start sending a break to the terminal
 */
tyd_start_break(tp, delay)
register tyd_tty_t	*tp;
int	delay;			/* break duration in milliseconds */
{
	/*tell uart to send break*/
	if (tyd_break_flag & 1)
		*(tp->uartptr + UT_COMMAND) |=
				UT_CMD_TxBRK | UT_CMD_TxIE | UT_CMD_TxEN;
	else	*(tp->uartptr + UT_COMMAND) |= UT_CMD_TxBRK;
	tp->state |= BREAK_IN_PROGRESS;
	tyd_start_timer_for_step(tp, (delay * HZ)/1000);
}/*------------------------------------------------------------------*/
/*
 *	tell uart to stop sending a break to the terminal
 */
tyd_stop_break(tp)
register tyd_tty_t	*tp;
{
	*(tp->uartptr + UT_COMMAND) &= ~UT_CMD_TxBRK;/*tell uart - stop break*/
	if (tyd_break_flag & 2)
		tyd_enable_transmitter(tp);
	tp->state &= ~BREAK_IN_PROGRESS;
}/*------------------------------------------------------------------*/
tyd_get_eia_status(tp)
register tyd_tty_t	*tp;
{
	uint tmp, status;

	tmp = 0;
	status = *(tp->uartptr + UT_STATUS);
	if (status & UT_STATUS_DSR)
		tmp |= T_DSR;
	if (status & UT_STATUS_DCD)
		tmp |= T_DCD;
	return(tmp);
}/*------------------------------------------------------------------*/
