#include "edtccpu.h"
#include "edtdtc.h"
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevstr.h"
#include "devcmd.h"
#include "edtdevdq.h"
#include "edttape.h"
#include "edttape9.h"
#include "edterror.h"
#include "edtextrn.h"
#include "vreg.h"


struct tcmd {
	short opr; int (*io)();
};

#ifdef ARCH

extern int taperw(), tapepos(), trwfm();
int tapstatus();
struct tcmd taptbl[] = {
	0,	0,		/* 0 */
	TREAD,	taperw,		/* 1 */
	TWRITE,	taperw,		/* 2 */
	TREW,	tapepos,	/* 3 */
	TWFM,	trwfm,		/* 4 */
	TRFM,	trwfm,		/* 5 */
	TSTATUS,tapstatus,	/* 6 */
	TENS,	tapepos,	/* 7 */
	TERAS,	tapepos,	/* 8 */
	0,	0,		/* 9 */
	0,	0,		/* a */
	0,	0,		/* b */
	0,	0,		/* c */
	TQ11,	tapepos,	/* d */
	TQ24,	tapepos,	/* e */
};
#endif

#ifdef TRACK9
extern int tape9rw(), t9control();
int tap9status(), t9reset();
struct tcmd tap9tbl[] = {
	0,		0,		/* 0 */
	T9READ,		tape9rw,	/* 1 */
	T9WRITE,	tape9rw,	/* 2 */
	T9REW,		t9control,	/* 3 rewind */	
	T9FMW,		t9control,	/* 4 write filemark */
	T9FMF,		t9control,	/* 5 read filemark */
	T9STATUS,	tap9status,	/* 6 */
	0,		0,		/* 7 tension */
	T9ERASE,	t9control,	/* 8 erase to end */
	T9ERAFIX,	t9control,	/* 9 erase fix length */
	T9RECF,		t9control,	/* a space record forword */
	T9RECR,		t9control,	/* b space record reverse */
	0,		0,		/* c position */
	0,		0,		/* d unused */
	0,		0,		/* e unused */
	T9DENHI,	t9control,	/* f density */
	T9STR_HI,	t9control,	/* 10 tapespeed, hi or low */
	T9STR_HI,	t9control,	/* 11 tapemode, stream or start/stop */
	T9FMR,		t9control,	/* 12 space filemark reverse */
	T9STATUS,	t9reset,	/* 13 reset 9 track */
};
#endif
	
taparse(dev)
register struct devdq *dev;
{
	register unsigned short intfcard;
	register struct tcmd *p;
	register struct tp *taptr;
	register struct devdq *dq;
	register rc;

	/* check if tape is online */

	dev->forward = 0;
	dev->backward = 0;

	
	if ( bddesc.tas1 & STOPTPIO ) {
		dev->rc1 = TP_ABORT;
		dev->flag |= OPRDONE;
		return;
	}

	if ( dev->devnum >= MAX_TDRIVE ) {
		dev->rc1 = TP_NRDY;
		dev->flag |= OPRDONE;
		return;
	}
	taptr = &tapdr[dev->devnum];

	if ( dev->device == TAPE9 ) {
		/* better be 9 track interface card */
		if ( (*TP_SR & TP_INFC) != TP_9TRKIF ) {
			dev->rc1 = TP_INVIF;
			dev->flag |= OPRDONE;
			return;
		}
	}

#ifdef ARCH
	if ( (taptr->tp_type & TAPEON) == 0 ) {
		/* only check archive tape drive is it is not online */
		if ( (intfcard = *TP_SR & TP_INFC) != TP_9TRKIF ) {
			if ( setape(dev->devnum) ) {
				dev->rc1 = TP_NRDY;
				dev->flag |= OPRDONE;
				return;
			}
		}
	}
#endif

#ifdef TRACK9
	/* 9 TRACK */
	if ( taptr->tp_type & TP_9TRK ) {
		
		p = &tap9tbl[dev->cmd];
		if ( (p->opr == 0) || (dev->cmd >= TOT9CMD) ) {
			dev->rc1 = DER_ILLCMD;
			dev->flag |= OPRDONE;
			return;
		}

		/* put in 9 track operation code */
		dev->opr = p->opr;

		/* don't allow partial tape blk */
		if ( (dev->cmd == TPREAD) || (dev->cmd == TPWRITE) ) {
			if ((((int)dev->mem & 0x03) && (bd_in_system==A1000)) 
		 	|| (dev->totcnt == 0) || (dev->totcnt > T9MAXCNT) ) {
				dev->rc1 = DER_INF;
				dev->flag |= OPRDONE;
				return;
			}
			else 
				if (bd_in_system == S90)
					FIXDEVMEM(dev); /* 871202 */
				else 
					dev->mem = (char *)((int)dev->mem >> 2);
		}

		if ( dev->cmd == DENSITY ) {
			if ( dev->q_devun.block == DENS_1600 )
				dev->opr = T9DENLOW;
			else if ( dev->q_devun.block == DENS_6250 )
				dev->opr = T9DENHI;
			else {
				dev->rc1 = DER_ILLCMD;
				dev->flag |= OPRDONE;
				return;
			}
		}

		/* set the speed of 9 track */
		else if  ( dev->cmd == TAPESPEED ) {
			if ( dev->q_devun.block == SPEED_HI )
				dev->opr |= (taptr->tp_stat[2] & MASK_SPEED)
					 | HISPEED;
			else if ( dev->q_devun.block == SPEED_LOW )
				dev->opr |= (taptr->tp_stat[2] & MASK_SPEED) 
					| LOWSPEED;
			else {
				dev->rc1 = DER_ILLCMD;
				dev->flag |= OPRDONE;
				return;
			}
		}

		/* set the 9 track in stream mode or start_stop mode */
		else if ( dev->cmd == TAPEMODE ) {
			if ( dev->q_devun.block == MODE_STARTSTP )
				dev->opr |= ( taptr->tp_stat[2] & MASK_STRM ) | STARTSTP;
			else if ( dev->q_devun.block == MODE_STREAM )
				dev->opr |= (taptr->tp_stat[2] & MASK_STRM) | STREAM;
			else {
				dev->rc1 = DER_ILLCMD;
				dev->flag |= OPRDONE;
				return;
			}
		}


		/* disable interrupt */
		rc = spl6();

		/* ****************************************** */
		/* 	9 track is busy(curtapreq !=0 )       */
		/* que up request on the correct drive        */
		/* ****************************************** */

		if ( curtapreq ) {
			if ( dq = taptr->next ) {
				/* current tape drive got que */
				printf ("p8");
				while ( dq->forward != (struct devdq *)0 )
					dq = dq->forward;
				dq->forward = dev;
			}
			else
				/* *********************** */
				/* busy with other 9 track */
				/* *********************** */
				taptr->next = dev;
			splx(rc);
			return;
		}


		/* leave interrupt off */
		/* no tape is active, perform 9 track io */
		(p->io) (dev);

		splx(rc);

		/* might not start tape */
		/* should have no more tape que */
		/* if OPRDONE bit set in dev->flag */
		/* ckreq routine will send response back */
		return;
	}
#endif

#ifdef ARCH

	if ( taptr->tp_type & TP_ARCH ) {
		/* ******************** */
		/* archive tape command */
		/* ******************** */
	
		p =  &taptbl[dev->cmd];
		/* check for valid tape command */
		if ( (p->opr == 0) || (dev->cmd >= TOTPCMD) ) {
			dev->rc1 = DER_ILLCMD;
			dev->flag |= OPRDONE;
			return;
		}
	
		/* don't allow partial tape blk */
		if ( (dev->cmd == TPREAD) || (dev->cmd == TPWRITE) ) {
			if ( (dev->totcnt % TAPEBLK) || (dev->totcnt == 0)
			|| (((int)dev->mem & 0x03)&&(bd_in_system == A1000))){ 
			 	dev->rc1 = DER_CNT;
				dev->flag |= OPRDONE;
				return;
			}
			else
				if (bd_in_system == S90)
					FIXDEVMEM(dev); /* 871202 */
					else
					dev->mem = (char *)((int)dev->mem >> 2);
		}

		/* if archive tape is busy, don't que */
		if ( curtapreq ) {
			printf ("no que arch");
			dev->rc1 = TP_HANG;
			dev->flag |= OPRDONE;
			return;
		}
	
		/* setup archive tape cmd code */
		dev->opr = p->opr;
	
		/* perform io */
		(p->io) (dev);
		
		if ( dev->rc1 == TP_HANG ) {
			printf ("p9");
			resetape();
			dev->rc1 = TP_RSET;
			dev->flag |= OPRDONE;
		}
		return;
	}
#endif

	/* not archive, not 9 track */
	dev->rc1 = TP_NRDY;
	dev->flag |= OPRDONE;
	return;
}
#ifdef ARCH

tapstatus(dev)
register struct devdq *dev;
{
	tstatus(dev);

	/* *********************** */
	/* get archive tape status */
	/* *********************** */
	*((short *)&dev->q_extdtb)= *((short *)tapdr[0].tp_stat);

	/* get type of tape in dev->totcnt */
	tapetype(dev);
}
#endif

tapetype(dev)
register struct devdq *dev;
{	register unsigned char type;
	type = tapdr[dev->devnum].tp_type;
	if ( type & TP_ARCH )
		dev->totcnt = TP_ARCH;
	else if ( type & TP_9TRK )
		dev->totcnt = TP_9TRK;
	else
		dev->totcnt = 0;
}

#ifdef TRACK9
tap9status(dev)
struct devdq *dev;
{
		
	tp9status(dev);

	/* get type of tape in dev->totcnt */
	tapetype(dev);
}
t9reset(dev)
struct devdq *dev;
{
	resetape9();
	dev->flag |= OPRDONE;
}
#endif

prtbl (value, tbl)
register value; char *tbl[];
{	register i;

	for (i=0; i<8; i++) {
		if ( value & 0x80 )
			printf ("%s", *tbl);
		tbl++;
		value = value << 1;
	}
	printlf();
}

ckbyte (dev, status, num, err)
register struct devdq *dev;
register unsigned char status; register num; register char *err;
{
	register i;
	for (i=0; i<8; i++) {
		if ( status & 0x80 ) {
			if ( *(err+i) ) {
				if ( num == 0 )
					dev->rc1 = *(err+i);
				else
					dev->rc2 = *(err+i);
				num++;
			}
			if ( num == 2 )
				return (num);
		}
		status = status << 1;
	}
	return (num);
}
