#include "edtdisksect.h"
#include "edt.h"
#include "edtdtc.h"
#include "edtextrn.h"
#include "devcmd.h"
#include "vreg.h"


memxfer(locmem, mainmem, lwordcnt, direction, loopchar, cmd)
int locmem, mainmem, lwordcnt, direction; char loopchar;
register unsigned char cmd;
{
	register loop;
	register unsigned char *bufptr;
	bufptr = (unsigned char *)dtbbuf;
	/* setup 8 bytes parameters in buf:buf[2],buf[3] = long word count
	   buf[4]-buf[7] = main memroy address >>2 */

	extra2 = lwordcnt << 2;
	if ((cmd != MSTARTREAD) && (cmd != MSTARTWRITE))
		*(short *)(bufptr+2) = lwordcnt;	/* long word cnt */

	if (bd_in_system == S90) 
		*(int *)(bufptr+4) = mainmem;
	else
		*(int *)(bufptr+4) = mainmem >> 2;

	loop=1;
	while ( con_in() != 'Q' ) {
		xferdata ( bufptr, locmem, direction, DTBWAIT, cmd );
		if ( loopchar != 'L' )
			return;
		if ( PRINT1 )
			printf ("loop=%x   \r",loop++);
		blinkled();
	}
	return;
}

