#include "edtdisksect.h"
#include "edt.h"
#include "edtdtc.h"
#include "edtextrn.h"
#include "vreg.h"

/*
A1000:	I[L]  <main memory > <DTC memory address> <long word cnt>
S90:	I[L]  <mem_slot> <main memory > <DTC memory address> <long word cnt>
*/

mm2lbuf(bufptr)
char *bufptr;
{
	register char cmd = 0x11;  /* dummy value for memxfer */
	unsigned int argu[4];

	if (bd_in_system == S90) {
		if ( getarg(bufptr, argu, 4) < 0 )
			return (-1);
		mem_slot = (unsigned short)argu[0];
		if (checkad (1, argu[1], argu[2], argu[3]<<2))
			return(-1);
		memxfer(argu[2], argu[1], argu[3], RD_DTB, *(bufptr+1),cmd);
	}
	else {		/* default A1000 system */
		if ( getarg(bufptr, argu, 3) < 0 )
			return (-1);
		if (checkad (1, argu[0], argu[1], argu[2]<<2))
			return(-1);
		memxfer(argu[1], argu[0], argu[2], RD_DTB, *(bufptr+1),cmd);
	}
	return (0);
}

/*
A1000:	O[L]  <DTC memory address>  <main memory>  <long word cnt>
S90:	O[L]  <mem_slot> <DTC memory address>  <main memory>  <long word cnt>
*/
lbuf2mm(bufptr)
char *bufptr;
{	unsigned int argu[4];
	register char cmd = 0x11;  /* dummy value for memxfer */


	if (bd_in_system == S90) {
		if ( getarg(bufptr, argu, 4) < 0 )
			return (-1);
		mem_slot = (unsigned short)argu[0];
		if (checkad (1, argu[2], argu[1], argu[3]<<2))
			return(-1);
		memxfer(argu[1], argu[2], argu[3], WR_DTB, *(bufptr+1), cmd);
	}
	else {
		if ( getarg(bufptr, argu, 3) < 0 )
			return (-1);
		if (checkad (1, argu[1], argu[0], argu[2]<<2))
			return(-1);
		memxfer(argu[0], argu[1], argu[2], WR_DTB, *(bufptr+1), cmd);
	}
	return (0);
}

/*
A1000:	Q[L]  <DTC memory address>  <main memory>  <long word cnt>
S90:	Q[L]  <mem_slot> <DTC memory address>  <main memory>  <long word cnt>
*/
mmloop(bufptr)
char *bufptr;
{	unsigned int argu[4]; register loop;
	register int *ptr1, *ptr2; register sbuf, rbuf, i, count;
	register char cmd = 0x11;  /* dummy value for memxfer */


	if (bd_in_system == S90) {
		if ( getarg(bufptr, argu, 4) < 0 )
			return (-1);
		mem_slot = (unsigned short)argu[0];
		if (checkad (2, argu[2], argu[1], argu[3]<<2))
			return(-1);
		sbuf = argu[1];
		rbuf = argu[1] + (argu[3]<<2);
		count = argu[3];
	}
	else {
		if ( getarg(bufptr, argu, 3) < 0 )
			return (-1);

		if (checkad (2, argu[1], argu[0], argu[2]<<2))
			return(-1);
		sbuf = argu[0];
		rbuf = argu[0] + (argu[2]<<2);
		count = argu[2];
	}

	loop = 1;
	while ( con_in() != 'Q' ) {
		if (bd_in_system == S90) {
			/* send data to main memory */
			memxfer(sbuf, argu[2], argu[3], WR_DTB, 0, cmd);
	
			/* read data from main memory to loc+len */
			memxfer(rbuf, argu[2],argu[3],RD_DTB,0, cmd);
		}
		else {
			/* send data to main memory */
			memxfer(sbuf, argu[1], argu[2], WR_DTB, 0, cmd);
	
			/* read data from main memory to loc+len */
			memxfer(rbuf, argu[1],argu[2],RD_DTB,0, cmd);
		}

		ptr1 = (int *)sbuf; ptr2 = (int *)rbuf;

		/* compare data (long word) */
		for (i=0; i<count; i++) {
			if ( *ptr1++ != *ptr2++) {
				ptr1--; ptr2--;
				printf ("\nno match %x(%x) %x(%x)\n",
					ptr1,*ptr1,ptr2,*ptr2);
				return (0);
			}
		}
		if ( *(bufptr+1) != 'L' )
			return(0);
		if ( PRINT1 )
			printf ("loop=%x   \r",loop++);
		blinkled();
	}
	printlf();
	return (0);

}

checkad (caller, mainaddr, edtaddr, count)
register caller, mainaddr, edtaddr, count;
{
	if ((mainaddr & 3) || (edtaddr & 3))
		return(-1);
	if (caller == 2) 
		count = count<<1;
	if ((edtaddr < 0x1000) || ((edtaddr + count) > 0xc000))
		return (-1);
	return (0);
}

#ifdef SETDMA
/* S setdma <channel number>.  sets global dma_used for building DTBIDR */
setdma(bufptr)
char *bufptr;
{
unsigned int argu[1];
	if ( getarg(bufptr, argu, 1) < 0 )
		return (-1);
	dma_used = (unsigned char)argu[0];
	return(0);
}
#endif
