/* **********************************************************

revisions

01.0  - initial release 
01.1  - 5/12/86
01.2  - 5/29/86
01.3  - 5/29/86 files changed: main.c, disk.c, edtvern.h, and makefile
1.4   - 8/6/86  changed tape9io.c to allow use of the Telex 9 track tape
		drive, also changed edtvern.h and main.c to change the 
		version # and add this comment
1.5   - 10/23/86 changed tape9io.c to fix bug using Fuji 9 track drives
		 caused by 1.4 change, changed edtvern.h and main.c
1.6,1.7- 04/30/87 m.tassano  Add slot address to commands "i","o",and "q"
		for use with the s3000 i/o adapter.
		02/05/88 m.tassano Add set global DMA chan to menu.
1.8   - 09/19/88 Alan combine A1000 and S90 systems firmware.

*******************************************************************

*/
#include "edtccpu.h"
#include "edtdata.h"
#include "edtdtc.h"
#include "edtextrn.h"
#include "edtvern.h"
#include "vreg.h"

extern int fill(), memrw(), compare();
extern int move(), display();
extern mm2lbuf(), lbuf2mm(), mmloop();
extern seek(), rwdisk(), readid(), wrloop();
extern format(), rezerodr(), tape();
extern help(), jump();
extern rdefectm(); tapearch();

extern ldlssp(), pdlssp(), pdls();
extern disksize(), loadeag();

extern unsigned char *system_flag;
extern unsigned short *esc_flag;

#define SETDMA  /* also in edt.h */

#ifdef SETDMA
extern setdma();
#endif

char *skipsp(); char *skiparg();
struct cmd  {
	char cmdchar; int (*func)();
} cmdtbl[] = {
	'C', compare,
	'D', display,
	'E', readid,
	'F', fill,
	'G', loadeag,
	'H', help,
	'I', mm2lbuf,
	'J', jump,
	'K', seek,
	'M', move,
	'O', lbuf2mm,
	'N', disksize,
	'Q', mmloop,
	'R', rezerodr,
	'S', setdma,   /* set the global dma channel  to use */
	'T', tape,	
	'X', rwdisk,	
	'Y', rdefectm,
	'Z', format,
	0, 0,
};


main() {
	char buffer[32];
	register struct bd_desc *bd;
	register char *bptr; register struct cmd *cmdptr;
	register int rc, i, oldpri;
	char *cptr;

	/* init EDT hardware */
	initedt();

	mem_slot = 0; /* 870511 used for I,O,Q only. */
	dma_used = 0; /* 880205 used for S, setdma */

	printf ("\ndatabase controller monitor v%d.%da\n#", EDT_VER, EDT_REL);

	bd = &bddesc;
	bd->bd_stst	= STCMPLT;		/* self test completed */
	*esc_flag = 0x7273;			/* "rs" */


	i = 0;
	for (;;) {
		if (bd->bd_opt == S90) 		/* default is A1000 system */
			*system_flag = bd_in_system = S90;
		else 
			bd_in_system = A1000;

		/* check for icb interrupt from main cpu or
			monitor command from keyboard */

		if ( inturpt & ICB_INT ) {
			/* get interrupt word */
			if ( icbdata & ICBI_MASK)
				icbparse();
			else {
				/* check disk/tape request on dual port */
				 ckreq();
				i=0;
			}
		}

		if ( (int)bddesc.reqfst != 0 ) {
			ckreq();
			i = 0;
		}


		/* blink green led */
		if ( i++ == 0x3000 ) {
			oldpri = spl6();
			if ( (dtc_ctl & 0x03) != yellowlit )
				i = yellowlit;
			else
				i = ledoff;
			LIGHT (i);
			splx(oldpri);
			i=0;
		}


		if ( head != tail) { 
			bptr = buffer;
			for (i=0; i < sizeof(buffer); i++)
				*bptr++ = ' ';

			rc = 0;
			if ( get(buffer,sizeof(buffer)-1) < 0 )
				rc = 1;

			else if ( buffer[0] != 0 ) {
				bptr = skipsp(buffer);
				rc = 1;

				/* search for valid command */
				for(cmdptr= cmdtbl; cmdptr->cmdchar; cmdptr++) {
					if ( *bptr == cmdptr->cmdchar ) {
						cptr = bptr + 1;
						if ((*bptr == 'C') || (*bptr == 'D') ||
						(*bptr == 'F') || (*bptr == 'M')
						|| (*bptr == 'J')) {
							if (*cptr != ' ')
								cptr++;
							rc=(*(cmdptr->func))(&cptr);
						}
						else
							rc=(*(cmdptr->func))(bptr);
					     	break;
					}
				}
			}
			if ( rc )
				printf ("?\n");
			printf ("+");
		}

	}	/* end of for loop */
}

/*	get a line of output into buffer, up to a carriage return.
	if character stream is greater then buffer size, return -1
	else return num of character in buffer
	also convert all lower case to upper case letters
			--------------------------------
	input:	character buffer pointer, buffer size
*/

get(bufptr, bsize)
char *bufptr; int bsize;
{
	register char *ptr; register int charnum ;
	register char c;

	ptr = bufptr;

	charnum =0;
	while ( (c=getchar()) != '\r' && c !=0 && charnum < bsize 
			&& c != '\n') {
		putchar(c);
		switch (c) {
			case 0x10:
				charnum = 0;
				ptr = bufptr;
				printf ("^\r");
				break;

			case '\b':
				if ( charnum ) {
					--ptr;
					--charnum;
					putchar(' ');
					putchar('\b');
				}
				break;
	
			default:
				if ( (c >='a') && (c <='z') )
					c -= 0x20;
				*ptr++ = c;
				charnum++;
				break;
		}
	}
	if ( charnum >= bsize ) return (-1);


	*ptr = 0;
	putchar ('\r');
	putchar ('\n');
	return (charnum);
}

/*	*******************************		*/
/*	skip over argument upto a space		*/
/*	or zero or \r or \n			*/
/*	*******************************		*/
char *
skiparg(ptr)
register char *ptr;
{	register char c;
	while ( (c= *ptr) != ' ' && c != 0 && c != '\r' &&
		c != '\n' ) ptr++;
	return (ptr);
}

/*	******************	*/
/*	skip over space		*/
/*	******************	*/
char *
skipsp(ptr)
register char *ptr;
{	register char c;
	while ( (c = *ptr) == ' ' )
			ptr++;
	return (ptr);	/* got char not space */
}

/*	********************************************	*/
/*	convert input ascii-char to 4 bits hex value	*/
/*	********************************************	*/

convert(c)
register char c;
{
 	if ( (c >= '0') && (c <= '9') ) {
		c -= '0';
		return (c);
	}
	else if ( (c >= 'a') && (c <= 'f') ) {
		c += 10 - 'a';
		return (c);
	}
	else if ( (c >= 'A') && (c <= 'F') ) {
		c += 10 - 'A';
		return (c);
	}
	else if ( (c == ' ') || (c == '\n') || (c == '\r') || (c == 0) )
		return (-2);
	else
		return (-1);
}


/*	*******************************************************	*/
/*	take the next argument and convert to 32 bits hex value */
/*	pptr = double pointer (contain a pointer to the buffer  */
/*	*******************************************************	*/
getlong(pptr, pvalue)
register char **pptr; register int *pvalue;
{
	register unsigned int hex32;
	register char c, *ptr;

	ptr = skipsp(*pptr);	/* skip over space */
	c = *ptr;		/* point to non-blank char */

	/* **************************** */
	/* check out any char out there */
	/* **************************** */

	c = convert(c);

	if ( (c == -1) || (c == -2) ) {
		*pptr = ptr;
		return ( -1 );	/* no hex value */
	}

	/* ****************************** */
	/* have not increment pointer yet */
	/* ****************************** */

	hex32 = 0;
	*pvalue = 0;

	while ( 1 ) {
		c = convert(*ptr++);
		if ( c != -1 && c != -2 )
			hex32 = (hex32 << 4) + c;
		else
			break;
	}
/* return  2 values */

	*pptr = --ptr;
	*pvalue = hex32;
	if ( c == -2 )
		return ( 0 );	/* 8 digits */
	else
		return (-1);	/* illegal character */
}


/*	********************************************	*/
/*	get the next three argument (expect to be long)	*/
/*	and convert them into three 32 bits value	*/
/*	store them at array pointed by argup		*/
/*	********************************************	*/

getarg(bufptr, argup, num)
char *bufptr; register int *argup, num;
{
	char *ptr; unsigned int temp;
	/* ***************** */
	/* skip over command */
	/* ***************** */
	ptr = skiparg (bufptr);

	while ( num--)  {
		if (  getlong(&ptr, &temp) < 0 ) 
			return (-1);
		else
			*argup++ = temp;
	}
	return(0);
}

