
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevstr.h"
#include "devcmd.h"
#include "edtdevdq.h"
#include "edtdtc.h"
#include "edttape.h"
#include "edterror.h"
#include "edtextrn.h"
#include "vreg.h"

/* inturpt is disable
   check any rw error, put que back in vreg, inturpt master cpu to take que
   check any tape xfer is pending, and start dtb xfer.
   check any fast tape waiting for dtb
   check any more que on same drive, if there is, check on same cyl, and 
	start rw, not on same cyl, give chance to other drive
   other drive have que, same cyl, then start rw, not same cyl, start seek
*/
finrw()
{
	register struct devdq *dev, *nextdq;
	register struct dkinf *dkptr;
	register char drive; register i;
	register sendqback;
	register seekon;

	dev = curwreq;

	/* check rw error and set error code */
	drive = dev->devnum;
	dkptr = &phydr[drive];

	/* incase there is tape req pending */
	nextdq = curwreq->forward;

	/* curwreq = 0; dev->flag |= OPRDONE, dkptr->pd_opr = 0; inturpt = 0; */
	checkrw (dev,dkptr);

	sendqback = 0;
	if ( (dev->rc1 == DER_ALT) && ((dev->flag & NOALT) == 0) ) {
		/* hit alt sector and need to reprg the c,h,s */
		if ( reprg (dev, dkptr) )
			sendqback = 1;		/* can't reprg c,h,s */
	}

	/* check if reading a alternate sector */
	else if ( dev->flag & ALT ) { 

		dev->flag &= ~ALT;

		/* just finish read a alt sector, check if got error, forget
			rest of the sector, no more sector left */
		if ( dev->rc1 || (dev->sectleft == 0) )
			sendqback = 1;
		else {
			/* there is more sector to do */
			*(int *)&dev->q_devun.pdisk.cyl = *(int *)&dev->orgsect;
			dev->q_devun.pdisk.sector++;

			dev->scnt = dev->sectleft;
			if (bd_in_system == S90)
				dev->mem += 0x400;
			else	/* default is in A1000 system */
				dev->mem += 0x100;
			dev->flag &= ~OPRDONE;
		}
	}

	/* ********************* RETRY **************************** */
	else if ( (dev->rc1 == DER_CRC) || (dev->rc1 == DER_OVR) ) {
		if ( (dev->flag & NRETRYB) || (++dev->retry >= RETRY) )
			sendqback = 1;

		/* ******************************** */
		/* later will put que back on dkptr */
		/* ******************************** */
		else
			dev->rc1 = 0;
	}
	else if ( dev->rc1 == DER_RDYCHG ) {
		if ( dev->flag & NRETRYB )
			sendqback = 1;
		else if (dkrezero(dev->devnum,dkptr)) /* curcyl = -1, opr=0 */
			/* rezero got problem */
			sendqback = 1;

		/* ******************************** */
		/* later will put que back on dkptr */
		/* ******************************** */
		else
			dev->rc1 = 0;
	}
	/* ********************* RETRY **************************** */
	else {
		sendqback = 1;

		/* finish a regular sectors */
		/* or hit alt sector, and no need to pick up the alt */
		if ( dev->flag & NOALT )
			*(int *)&dev->orgsect = *(int *)altbuf;
	}

	/* either send req back to master cpu, or put back on the que */
/* DDDDDDDDDDD */
	dev->flag &= ~OPRDONE;
	if ( sendqback ) {
		dev->totcnt = dev->totsdone << 10;
		finreq (dev);
	}
	else {
		/* dev->flag &= ~OPRDONE; */
		/* AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA */
		/* there is que lineup, put at the beginning */
		/* AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA */
		/* fix up sortdq and lastdq */
		
		printf ("DRTRY(%x)", dev->retry);
		if ( dkptr->next == 0 ) {
			dkptr->pd_sortdq = dev;
			dkptr->pd_lastdq = dev;
		}
		dev->forward = dkptr->next;
		dkptr->next = dev;
	}

	/* check any tape req data transfer pending (both archive & 9 track) */
	if ( nextdq ) {
		/* ***************************************** */
		/* there is tape req, setup dtb to xfer data */
		/* take care both archive and 9 track        */
		/* ***************************************** */

		if ( nextdq->cmd == TPREAD )
			/* read from tape, write to DTB */
			i = WR_DTB;
		else
			i = RD_DTB;
		/* there should not be any diskrw */
		tapexfer (nextdq, i);
		return;
	}

	/* no tape waiting */
	/* check any fast tape waiting for dtb */
	if ( ftaperw == WAIT_DK ) {
		ftaperw = 0;
		return;
	}


	/* no tape req pending, check any que ready to go on the same drive */
	dev = dkptr->next;

	if ( dev != (struct devdq *)0 ) {
		/* there is que waiting on same drive */
		dkptr = &phydr[dev->devnum];
		if ( dkptr->curcyl == dev->q_devun.pdisk.cyl ) {
			/* take que off the dkptr, put on curwreq by diskrw */
			dkptr->next = dev->forward;
			/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
			if ( dkptr->pd_sortdq == dev ) 
				dkptr->pd_sortdq = dev->forward;
			if ( dkptr->pd_lastdq == dev )
				dkptr->pd_lastdq = dev->forward;
			/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
			diskrw (dev, dkptr, 0);
			return;
		}
	}

	/* there is que on same disk, but not on same cylinder
		or no que , check other drive */

	if ( ++drive >= MAX_PDRIVE)
		drive=0;

	seekon = 0;			/* no drive is seeking */

	for (i=0; i<MAX_PDRIVE; i++) {
		dkptr= &phydr[drive];
		if ( (dev=dkptr->next) != 0 ) {
			if ( dkptr->curcyl != dev->q_devun.pdisk.cyl ) {
				if ( aseek (dev, dkptr, 0) )
					/* can't start seek, cancel all req */
					cancelreq (dev, dkptr);
				else
					seekon = 1;
			}
			else {
				/* insure there is no drive is seeking */
				if ( seekon == 0 ) {
					dkptr->next = dev->forward;
					/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
					if ( dkptr->pd_sortdq == dev ) 
						dkptr->pd_sortdq = dev->forward;
					if ( dkptr->pd_lastdq == dev )
						dkptr->pd_lastdq = dev->forward;
					/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
					diskrw (dev, dkptr, 0);
					return;
				}
			}
		}

		if ( ++drive >= MAX_PDRIVE )
			drive = 0;
	}

	/* 1. disks may be doing seeking */
	/* 2. no disk activity */
	return;
}

reprg (dev, dkptr)
register struct devdq *dev;
register struct dkinf *dkptr;
{
	register struct alt *altptr;

	altptr = (struct alt *)altbuf;

	/* the alt c,h,s is in altbuf */
	if ( PRINT1 )
		printf ("alt=%x ", *((int *)altbuf));

	if ( (dev->flag & ALT) || (altptr->cyl >= dkptr->cyldisk) ||
		(altptr->head >= dkptr->headcyl) ||
		(altptr->sector >= dkptr->sechead) || (altptr->cyl == -1) ) {
		printf ("bad alt ");
		dev->rc1 = DER_BADALT;
		return (-1);
	}


	/* save orginal c,h,s in dev->orgsect */
	dev->q_devun.pdisk.sector += dev->cursdone;
	dev->orgsect = *(unsigned int *)&dev->q_devun.pdisk.cyl;

	/* reprg c,h,s compute main memory address */
	*(int *)&dev->q_devun.pdisk.cyl = *(int *)altbuf; 
	/* dev->mem += (dev->sectdone) * 100; */
	/* FIX altive sector bug for S3000 */
	if (bd_in_system == S90)
		dev->mem += (dev->cursdone << 10);
	else		/*default is in A1000 system */
		dev->mem += (dev->cursdone << 8);
	dev->scnt = 1;
	
	dev->flag |= ALT;
	return(0);
}
