/*
 *	chip 6840 PTM registers
 */

#define PTM_REG1	0x01	/* select register 1, channel 2 only */
#define PTM_REG3	0x00	/* select register 3, channel 2 only */
#define PTM_RESET	0x01	/* internal reset, channel 1 only */
#define PTM_DIV8	0x01	/* divide by 8 prescale, channel 3 only */
#define PTM_ECLOCK	0x02	/* E clock pin 17 */
#define PTM_DUAL8	0x04	/* dual 8 bit counters, else single 16 */

#define PTM_IE		0x40	/* interrupt enable */
#define PTM_OE		0x80	/* output enable */

/* count to program timer 3 to interrupt every 80m.s */
#define TICKHZ	0xffff		/* PTM ticks for 80ms */

#define TICK_1SEC	12		/* tick count for 1 sec */
#define TICK_2SEC	24		/* tick count for 2 sec */
#define TICK_1MIN	0x2ee		/* tick count for 1 min */
#define TICK_3MIN	0x8ca
#define TICK_5MIN	0xea6
#define TICK_20MIN	0x3b00		/* tick count for 20 min */

#define TICK_240MS	3		/* each tick take 82 ms */
