/*
	DISK/TAPE errors

	the following is a list of the error
	codes returned by the disk/tape driver.
 */

 
#define DER_SYBAD	1		/* system sector bad */
#define DER_ILLCMD	2		/* illegal disk/tape dq command */
#define DER_ISEC	3		/* invalid sector num */
#define DER_UNFORM	4		/* disk not formatted */
#define DER_SYERR	5		/* invalid system sector information */
#define DER_NRDY	6		/* drive not ready */
#define DER_PHNMT	7		/* phy drive not mounted */
#define DER_NLOG	8		/* no such logical drive */
#define DER_DRLIMIT	9		/* phy/log drive out of range */

#define DER_INF		0xa		/* invalid data in req */
#define DER_CNT		0xb		/* illegal count */
#define DER_SKFULL	0xc		/* skip track table is full */
#define DER_SKTRK	0xd		/* skiptrack error */
#define DER_BADALT	0xe		/* hit double alternate sector */
					/* alt sector id field is -1 */
					/* hit invalid alt id field */
#define DER_MULS	0xf		/* too many sectors */


/* hard error start at 010h */
#define DER_ALT		0x10		/* 1.hit alternate sector */

#define DER_CRC		0x11		/* data CRC error */
#define DER_SEEK	0x12		/* SEEK error during SEEK */

#define DER_RDYCHG	0x13		/* ready change */
#define DER_DEVCK	0x13		/* device check error */
#define DER_CYLNON	0x13		/* cylinder not on */

#define DER_REZERO	0x14		/* can't rezero */

#define DER_IDER	0x16		/* header ID error */
#define DER_ENC		0x17		/* end of cylinder */
#define DER_OVR		0x18		/* overrun */
#define DER_NWR		0x1a		/* no writable */

#define DER_HDSR	0x1c		/* header search */
#define DER_TIMEOUT	0x1d		/* timeout on rw */
#define DER_ILTIM	0x1e		/* wrong gap length */
					/* disk unformatted */

#define DER_ABNOM	0x1f		/* abnormal termination */



/* ***************** */
/* tape return code */
/* ***************** */

#define TP_NOTAPE	0x20	/* cartridge not in place */
#define TP_NRDY		0x21	/* tape drive not ready */
#define TP_WPROT	0x22	/* write protected */
#define TP_EOM		0x23	/* end of media */
#define TP_DATER	0x24	/* unrecoverable data err */
				/* or BIE(block in error) not located */
				
#define TP_FMD		0x25	/* file mark detected */
#define TP_NDATA	0x26	/* no data detected */
#define TP_8RETRY	0x27	/* 8 or more retries */
#define TP_BOM		0x28	/* beginning of media */
#define TP_HANG		0x29	/* tape drive is hung */

#define TP_RSET		0x2a	/* tape drive was reset */
#define TP_NONL		0x2b	/* tape not online */
#define TP_OVRUN	0x2c	/* data overrun, tapeblk is bigger than request*/
#define TP_CDATER	0x2d	/* 9 track, error during write operation */
#define TP_ILLCMD	0x2e	/* illegal tape cmd */

#define TP_INVIF	0x2f	/* invalid io interface */
#define TP_ABORT	0x30	/* tape request abort,due to ups */
#define TP_NONINE	0x31    /* no nine track tape on this controller */
#define TP_NOBRST	0x32    /* no burst id detected */
#define TP_DENS		0x33    /* invalid density selection */
#define TP_SPEED	0x34    /* invalid tape speed selection */
#define TP_MODE		0x35    /* invalid tape mode selection */
#define TP_BUSY		0x36	/* tape drive is in the process of performing
				   a read/write request */
#define TP_MEM		0x37	/* invalid main memory address */
#define TP_CNT		0x38	/* invalid byte count in request */



#define RECOVERED_ERR		0x40
#define MEDIUM_ERR		0x41
#define HARDWARE_ERR		0x42
#define ILLEGAL_REQ		0x43
#define ABORTED_CMD		0x44
#define VOLUME_OVRFLOW		0x45
#define MISCMPR			0x46
#define INCORRECT_LENGTH_INDIC	0x47  /* invalid length in a request */
#define ENDOFMEDIA		0x48  /* a request past the end of physical
					media on the disk */
#define CHAN_FAIL		0x49  /* failure of one of the two scsi 
					controller channels */

