typedef	unsigned int	uint;
typedef	unsigned short	ushort;
typedef unsigned char	uchar;


#define PRINT1		( printflag >=1 )
#define PRINT2		( printflag >=2 )
#define PRINT3		( printflag >=3 )

#define SETDMA		/* 880205mtassano allow setting of the dmachan from menu */

#define RETRY		5	/* retry for disk io */

/* number of free que on hsdt board */
#define NQNUM	24

/* acknowledge data byte to master cpu for completing the request */
#define ICB_ACK		0x0

/* buffer use for formatting drive, setup sector zero */
/* used in mm<->loc memory xfer & tape r/w buffer */
#define LOCA	0x1000
#define LOCB	0x2000

#define LOC1	0x1000
#define LOC2	0x1800
#define LOC3	0x2000


#define DTBNOWAIT	0
#define DTBWAIT		1

/* from diskio routine */
#define	SKERR 		1
#define RWERR		2
#define TIMEOUT		3
#define ALTERR		4

/* value in DEVICE */
#define DISK	1
#define TAPE	2		/* arch tape or 9 track */
#define TAPE9	0x82		/* must be 9 track */


struct sizedk {
	ushort	cylnum;
	uchar	headnum;
	uchar	sectnum;
	ushort	seccyl;
	ushort	datapatt;
	uint	trkbytesec;
};


struct alt {
	ushort cyl;
	uchar head;
	uchar sector;
};


/* (dev->flag) value in disk request */
#define NRETRYB		1		/* bit 0: no retry on disk r/w */
#define NOALT		2		/* bit 1: no need to reprg c,h,s when
						hit alter sector */ 
					
#define TNOWAIT		0x4		/* bit 2: don't wait for completion */
#define FASTAPE		0x8		/* bit3: fast tape operation */
#define RAWused		0x10		/* bit4: used by unix kernel */

#define ALT		0x20		/* bit5: r/w on re-prg c,h,s */
#define OPRDONE		0x40		/* bit 6: set means req done */

#define DEST_M		0		/* bit 7: reset means main memory */
#define DEST_L		0x80		/*       set means local memory */

#define DUALTAPE	0x100		/* bit 8: use dual tape dma */
#define XFER		0x200		/* bit 9: transfer to main */


#define MAX_PDRIVE	4		/* max disk drive */
#define MAX_TDRIVE	4		/* max tape drive */
#define BLKSIZE		0x400

#define MAXCYL		0x400		/* hardware max cyl */

/* *************** CDC drive ******************* */
/* number of bytes in regular sector = 0x048c (including gap len) */
/* number of bytes in last sector = 0x0486 */
#define BYTECDC_SEC	0x048c0486

#define SECCDC_HEAD	26
#define HEADCDC_CYL	24
#define CYLCDC_DRV	711
#define LCYLCDC_DRV	710
#define SECCDC_CYL	26*24

/* *************** 84/168 drive ******************* */
/* number of bytes in regular sector = 0x0472 (including gap len) */
/* number of bytes in last sector = 0x046e */
#define BYTE84_SEC	0x0472046e

#define SEC84_HEAD	18
#define HEAD84_CYL	7
#define CYL84_DRV	589
#define LCYL84_DRV	588
#define SEC84_CYL	18*7

#define SEC168_HEAD	18
#define HEAD168_CYL	10
#define CYL168_DRV	823
#define LCYL168_DRV	822
#define SEC168_CYL	18*10

/* *************** EAGLE drive ******************* */
/* number of bytes in regular sector = 0x0467 (including gap len) */
/* number of bytes in last sector = 0x0458 */
#define BYTEEAG_SEC	0x04670458

#define SECEAG_HEAD	25
#define HEADEAG_CYL	20
#define CYLEAG_DRV	842
#define LCYLEAG_DRV	841
#define SECEAG_CYL	25*20

#define FORMDATA	0xa5
#define FMTFLAGS	0
#define DEFM_LEN	24	/* media defect list for each track */
#define ALT_LEN		16	/* 16 bytes for ID field */
#define ALTFLAG 	0x40	/* alt flag in sector ID field */

#define SEC0		0	/* system sector */
#define SPARESEC	2	/* spare sector */
#define SKTRKSEC	4	/* skip track sector */
#define MEDSEC		6	/* media defect sector */
#define BOOTSEC		8	/* boot information sector */
#define BADSCSEC	0x10	/* bad sectors found by disk test */

#define BOOTLEN		0x400	/* length in sectors of boot sw */


#define TOTLOG		64		/* 16 x 4 total log drive */
#define MAXDEV		8		/* max device num on hsdt board */
					/* tape, disk, mirror, console, boot */
#define NEXTSEC		0x12		/* next sector available for more
						spare, skip track table... */

/* this number is the same as SKTRKSIZ */
#define TOTSKLEN	254		/* total num of skip track list 
					   for single drive */
/* each physical drive has its own skip track list */
/* max 16 logical drives can have 254 skip track */
struct sktrkinf {
	ushort pd_totsklen;
	struct badtrck *pd_nxtskptr;
	struct badtrck pd_totsklist[254];
};

