#include "edtdisksect.h"
#include "edt.h"
#include "edtdevdq.h"
#include "edtdevstr.h"
#include "edterror.h"
#include "edtextrn.h"




/*	open physical drive if drive has not been opened
	output:	return -1 for can't opened drive
 */

ckopdrive(dev, dkptr)
struct dkinf *dkptr;
register struct devdq *dev;
{
	struct devdq dkreq; register struct devdq *p; register i;

	/* check if drive has been opened */
	if ( dkptr->pd_ststat & DK_INIT )
		return (0);

	/* DDDDDDDDDDDDDDDDDDDDDDDDDDDDDD */
	/* temporary bug fix, if drive is not ready */
	/* when download code is loaded, can never open that drive */
	/* DDDDDDDDDDDDDDDDDDDDDDDDDDDDDD */

	if ( (dkptr->pd_ststat & DK_READY) == 0 ) {
		dev->rc1 = DER_NRDY;
		return(-1);
	}

	dkptr->pd_ststat = DK_READY;

	/* setup new dev request and open the drive */
	p = &dkreq;
	initdevq (p);
	p->device = DISK;
	p->devnum = dev->devnum;

	/* will wait for disk completion */
	/* p->flag &= ~TNOWAIT; */
	diskopen (p, dkptr);

	if ( p->rc1 ) {
		dev->rc1 = p->rc1;
		return (-1);
	}
	return(0);
}


getphptr(dev)
register struct devdq *dev;
{
	if ( dev->devnum >= MAX_PDRIVE) {
		dev->rc1 = DER_DRLIMIT;
		printf ("D=%x invalid\n",dev->devnum);
		return (-1);
	}

	return ( (int)&phydr[dev->devnum] ) ;
}


convl2p (dev, dkptr)
register struct devdq *dev;
register struct dkinf *dkptr;
{
	int remsec, cyl, head, sect;

	/* ldivrem(dividend, divisor, quoteint, remainder) */
	/* ldivrem(logical sector #, #of sector/cylinder,cylinder #,remainder */

	ldivrem ( dev->q_devun.block, dkptr->seccyl, &cyl, &remsec ); 
	ldivrem ( remsec, dkptr->sechead, &head, &sect );

	if ( cyl >= dkptr->cyldisk ) {
		dev->rc1 = DER_ISEC;
		return (-1);
	}
	dev->q_devun.pdisk.cyl = cyl;
	dev->q_devun.pdisk.head = head;
	dev->q_devun.pdisk.sector = sect;
	return (0);
}

