#include "edtccpu.h"
#include "edtdtc.h"
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevstr.h"
#include "edtdevdq.h"
#include "edttape.h"
#include "edterror.h"
#include "edtextrn.h"



/*	return:	1 if seek error
		2 if read/write sector error
		0 if no error
 */
diskio(dev,dkptr)
register struct devdq *dev;
register struct dkinf *dkptr;
{
	register int retbyte; register oldpri;
	/* register struct devdq *dq; */
	struct dkinf *ndkptr; register i;
	struct alt *altptr;
	register struct devdq *ap, *cp;
rwstart:
	oldpri = spl6();
	*(short *)&dev->rc1 = 0;
	dev->forward = 0;

	/* %%%%%%%%%%%%%%%%% */
	++dkptr->pd_iocnt;
	/* %%%%%%%%%%%%%%%%% */

	/* make sure no disk activity  on that disk */
	if ( dkptr->next != 0 ) {
		/* disk drive is seeking,or waiting to do seeking, que up */
		/* ******************************************* */
		/* dq = dkptr->next; */
		/* while ( dq->forward != (struct devdq *)0 ) */
			/* dq = dq->forward; */
		/* dq->forward = dev; */

		/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
		/* sort the que */
		if ( (dkptr->pd_iocnt & 0x07) == 0 )
			dkptr->pd_sortdq =  dkptr->pd_lastdq;
		
		if ( dkptr->pd_sortdq == (struct devdq *)0 ) {
			printf ("STP");
	lop3:		goto lop3;
		}

		for (ap = (struct devdq *)dkptr->pd_sortdq;
			cp = ap->forward; ap=cp) {
			int s1, s2;
			if ((s1=ap->q_devun.pdisk.cyl-dev->q_devun.pdisk.cyl)<0)
					s1 = -s1;
			if ((s2=ap->q_devun.pdisk.cyl-cp->q_devun.pdisk.cyl)<0)
					s2 = -s2;
			if ( s1 < s2 ) {
				break;
			}
		}
		ap->forward = dev;
		if ( (dev->forward = cp) == 0 )
			dkptr->pd_lastdq = dev;
			
		
		/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
		splx (oldpri);
		return;
	}

	/* make sure no disk rw active  or fast tape active */
	if ( curwreq || (ftaperw == FT_ACT) ) {
		/* disk is busy rw or fast tape is busy with DTB */
		/* dkptr->next = dev; */
		/* %%%%%%%%%%%%%%%%%%%%%%% */
		dkptr->next = dev;
		dkptr->pd_lastdq = dev;
		dkptr->pd_sortdq = dev;
		/* %%%%%%%%%%%%%%%%%%%%%%% */
		splx (oldpri);
		return;
	} 
	

	/* no rw active, specfic disk is available */
	/* can do overlap seek */
	/* curwreq and dkptr->next both equal zero here */

	if ( dkptr->curcyl != dev->q_devun.pdisk.cyl ) {
		/* inturrpt is disable */
		/* **************************** */
		/* aseek put dev on dkptr->next */
		/* **************************** */

		/* %%%%%%%%%%%%%%%%%%%%%%%%%%%% */
		dkptr->pd_lastdq = dev;
		dkptr->pd_sortdq = dev;
		/* %%%%%%%%%%%%%%%%%%%%%%%%%%%% */
		retbyte =  aseek (dev, dkptr, oldpri);

		if ( dev->flag  & TNOWAIT ) {

			/* if aseek routine has problem before starting
				to seek, it will rezero drive, set rc1,
				set OPRDONE in dev->flag, 
				should send req here, so clear OPRDONE
				interrupt still disabled 
				should not have any new req pending
				dev->forward, backward should still be zero */

			if ( retbyte ) {
				dev->flag &= ~OPRDONE;
				finreq (dev);
			}
			/* 1. start the seek, interrupt will happen */
			/* 2. if can't seek, already send req back */ 

			splx (oldpri);
			return;
		}

		/* wait for operation to be completed */
		/* seek is done, inturrpt is enable */
		if ( dev->rc1 )
			return (SKERR);
		
		/* disable int. to do r/w, wait for completeion option */
		oldpri = spl6();
	}

	/* fall here 1. diskio: wait for completion
			2. no rw active, specifc disk is already
				on the right cyl, just rw */

	/* INTURPT STILL DISABLE */

	/* make sure no DTB activity  before starting disk rw */
	if ( dtbreq ) {
		/* dtb is busy */
		/* dkptr->next = dev; */
		/* %%%%%%%%%%%%%%%%%%%%%%% */
		dkptr->next = dev;
		dkptr->pd_lastdq = dev;
		dkptr->pd_sortdq = dev;
		/* %%%%%%%%%%%%%%%%%%%%%%% */
		splx(oldpri);
		return;
	}

	/* make sure no other disk is seeking */
	ndkptr = phydr;
	for ( i=0; i<MAX_PDRIVE; i++) {
		if ( ndkptr->pd_opr & DK_SEEK ) {
			/* other disk is seeking, can't rw, put on que */
			/* dkptr->next = dev; */
		/* %%%%%%%%%%%%%%%%%%%%%%% */
		dkptr->next = dev;
		dkptr->pd_lastdq = dev;
		dkptr->pd_sortdq = dev;
		/* %%%%%%%%%%%%%%%%%%%%%%% */
			splx(oldpri);
			return;
		}
		ndkptr++;
	}

	/* no seek on, no rw on, no tape */
	/* take que off the dkptr, and put on curwreq by diskrw */
	dkptr->next = dev->forward;
	/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
	if ( dkptr->pd_sortdq == dev ) 
		dkptr->pd_sortdq = dev->forward;
	if ( dkptr->pd_lastdq == dev )
		dkptr->pd_lastdq = dev->forward;
	/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
	retbyte = diskrw (dev, dkptr, oldpri);

	if ( dev->flag & TNOWAIT ) {
		splx (oldpri);
		return;
	}

	/* ************************************************** */
	/* must be a disk request need to wait for completion */
	/* ************************************************** */


	/* inturpt is enabled ,rw is completed */
	if ( retbyte == 0 )
		return(0);

	if ( PRINT1 )
		printrc (dev);

	if ( dev->rc1 == DER_ALT ) {
		/* the alt c,h,s is in altbuf */
		printf ("a(%x)", *((int *)altbuf));

		if ( dev->flag & ALT ) {
			printf ("dblealt ");
			dev->rc1 = DER_BADALT;
			return (ALTERR);
		}

		altptr = (struct alt *)altbuf;
		if ( (altptr->cyl >= dkptr->cyldisk) ||
			(altptr->head >= dkptr->headcyl) ||
			(altptr->sector >= dkptr->sechead) ||
			(altptr->cyl == -1) ) {
			dev->rc1 = DER_ALT;
			printf ("bdalt ");
			return (ALTERR);
		}
		
		if ( dev->scnt > 1 ) {
		/* need to cancel DMC for main memory, re figure
		main memory addrss , save the remaining sector cnt */
			printf ("nomult s");
			dev->rc1 = DER_ALT;
			return (ALTERR);
		}

		/* save orginal c,h,s in dev->orgsect */
		dev->orgsect = *(unsigned int *)&dev->q_devun.pdisk.cyl;

		*(int *)&dev->q_devun.pdisk.cyl = *(int *)altbuf; 
		dev->flag |= ALT;
		goto rwstart;
	}
	/* error return */
	return (retbyte);
}
