/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) copyright.h: version 25.1 created on 12/2/91 at 19:17:50	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)copyright.h	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

	
#ident	"@(#)lib/libcurses:copyright.h	25.1"


#ident	"@(#)curses:screen/termcap.ed	1.16"
/*
 * Simulation of termcap using terminfo.
 * This file is created from termcap.ed. DO NOT EDIT ME!
 */

/*
 * These are declared so people won't get undefineds if they use
 * old documentation.  We don't do anything with them.
 */

#include	"curses_inc.h"

char	*UP;
char	*BC;
char	PC;
short	ospeed;

/* ARGSUSED */
int
tgetent(bp, name)
char	*bp, *name;
{
    int	rv;

    if (setupterm(name, 1, &rv) >= 0)
	/* Leave things as they were (for compatibility) */
	reset_shell_mode();
    return (rv);
}

/* Make a 2 letter code into an integer we can switch on easily */
#define	_TWO(s1, s2)	(s1 + 256*s2)
#define	_TWOSTR(str)	_TWO(*str, str[1])

static	char	*
_stripdelays(inbuf, outbuf, size)
register	char	*inbuf, *outbuf;
register	int	size;
{
    char	*saveoutbuf = outbuf;

    if (inbuf == NULL)
	return (0);
    else
	while (size && *inbuf)
	    if (*inbuf == '$' && *(inbuf+1) == '<')
		while (*inbuf && *inbuf++ != '>')
		    ;
	    else
	    {
		size--;
		*outbuf++ = *inbuf++;
	    }
    return (saveoutbuf);
}

/* generated by sort on caps */
static	short	booloffsets[] =
		{		/* generated by sort on caps */
	/* "5i" */	22,
	/* "HC" */	23,
	/* "ND" */	26,
	/* "NP" */	25,
	/* "NR" */	24,
	/* "YA" */	30,
	/* "YB" */	31,
	/* "YC" */	32,
	/* "YD" */	33,
	/* "YE" */	34,
	/* "YF" */	35,
	/* "YG" */	36,
	/* "am" */	1,
	/* "bw" */	0,
	/* "cc" */	27,
	/* "da" */	11,
	/* "db" */	12,
	/* "eo" */	5,
	/* "es" */	16,
	/* "gn" */	6,
	/* "hc" */	7,
	/* "hl" */	29,
	/* "hs" */	9,
	/* "hz" */	18,
	/* "in" */	10,
	/* "km" */	8,
	/* "mi" */	13,
	/* "ms" */	14,
	/* "nx" */	21,
	/* "os" */	15,
	/* "ul" */	19,
	/* "ut" */	28,
	/* "xb" */	2,
	/* "xn" */	4,
	/* "xo" */	20,
	/* "xs" */	3,
	/* "xt" */	17,
		};

/* generated by sort on caps */
static	short	numoffsets[] =
		{
	/* "Co" */	13,
	/* "MW" */	12,
	/* "NC" */	15,
	/* "Nl" */	8,
	/* "Ya" */	16,
	/* "Yb" */	17,
	/* "Yc" */	18,
	/* "Yd" */	19,
	/* "Ye" */	20,
	/* "Yf" */	21,
	/* "Yg" */	22,
	/* "Yh" */	23,
	/* "Yi" */	24,
	/* "Yj" */	25,
	/* "Yk" */	26,
	/* "Yl" */	27,
	/* "Ym" */	28,
	/* "Yn" */	29,
	/* "co" */	0,
	/* "it" */	1,
	/* "lh" */	9,
	/* "li" */	2,
	/* "lm" */	3,
	/* "lw" */	10,
	/* "ma" */	11,
	/* "pa" */	14,
	/* "pb" */	5,
	/* "sg" */	4,
	/* "vt" */	6,
	/* "ws" */	7,
		};

/* generated by sort on caps */
static	short	stroffsets[] =
		{
	/* "!1" */	212,
	/* "!2" */	213,
	/* "!3" */	214,
	/* "#1" */	198,
	/* "#2" */	199,
	/* "#3" */	200,
	/* "#4" */	201,
	/* "%0" */	177,
	/* "%1" */	168,
	/* "%2" */	169,
	/* "%3" */	170,
	/* "%4" */	171,
	/* "%5" */	172,
	/* "%6" */	173,
	/* "%7" */	174,
	/* "%8" */	175,
	/* "%9" */	176,
	/* "%a" */	202,
	/* "%b" */	203,
	/* "%c" */	204,
	/* "%d" */	205,
	/* "%e" */	206,
	/* "%f" */	207,
	/* "%g" */	208,
	/* "%h" */	209,
	/* "%i" */	210,
	/* "%j" */	211,
	/* "&0" */	187,
	/* "&1" */	178,
	/* "&2" */	179,
	/* "&3" */	180,
	/* "&4" */	181,
	/* "&5" */	182,
	/* "&6" */	183,
	/* "&7" */	184,
	/* "&8" */	185,
	/* "&9" */	186,
	/* "*0" */	197,
	/* "*1" */	188,
	/* "*2" */	189,
	/* "*3" */	190,
	/* "*4" */	191,
	/* "*5" */	192,
	/* "*6" */	193,
	/* "*7" */	194,
	/* "*8" */	195,
	/* "*9" */	196,
	/* "@0" */	167,
	/* "@1" */	158,
	/* "@2" */	159,
	/* "@3" */	160,
	/* "@4" */	161,
	/* "@5" */	162,
	/* "@6" */	163,
	/* "@7" */	164,
	/* "@8" */	165,
	/* "@9" */	166,
	/* "AL" */	110,
	/* "CC" */	9,
	/* "CM" */	15,
	/* "CW" */	277,
	/* "DC" */	105,
	/* "DI" */	280,
	/* "DK" */	275,
	/* "DL" */	106,
	/* "DO" */	107,
	/* "F1" */	216,
	/* "F2" */	217,
	/* "F3" */	218,
	/* "F4" */	219,
	/* "F5" */	220,
	/* "F6" */	221,
	/* "F7" */	222,
	/* "F8" */	223,
	/* "F9" */	224,
	/* "FA" */	225,
	/* "FB" */	226,
	/* "FC" */	227,
	/* "FD" */	228,
	/* "FE" */	229,
	/* "FF" */	230,
	/* "FG" */	231,
	/* "FH" */	232,
	/* "FI" */	233,
	/* "FJ" */	234,
	/* "FK" */	235,
	/* "FL" */	236,
	/* "FM" */	237,
	/* "FN" */	238,
	/* "FO" */	239,
	/* "FP" */	240,
	/* "FQ" */	241,
	/* "FR" */	242,
	/* "FS" */	243,
	/* "FT" */	244,
	/* "FU" */	245,
	/* "FV" */	246,
	/* "FW" */	247,
	/* "FX" */	248,
	/* "FY" */	249,
	/* "FZ" */	250,
	/* "Fa" */	251,
	/* "Fb" */	252,
	/* "Fc" */	253,
	/* "Fd" */	254,
	/* "Fe" */	255,
	/* "Ff" */	256,
	/* "Fg" */	257,
	/* "Fh" */	258,
	/* "Fi" */	259,
	/* "Fj" */	260,
	/* "Fk" */	261,
	/* "Fl" */	262,
	/* "Fm" */	263,
	/* "Fn" */	264,
	/* "Fo" */	265,
	/* "Fp" */	266,
	/* "Fq" */	267,
	/* "Fr" */	268,
	/* "HU" */	279,
	/* "IC" */	108,
	/* "Ic" */	299,
	/* "Ip" */	300,
	/* "K1" */	139,
	/* "K2" */	141,
	/* "K3" */	140,
	/* "K4" */	142,
	/* "K5" */	143,
	/* "LE" */	111,
	/* "LF" */	157,
	/* "LO" */	156,
	/* "Lf" */	273,
	/* "MC" */	270,
	/* "ML" */	271,
	/* "MR" */	272,
	/* "PA" */	285,
	/* "PU" */	283,
	/* "QD" */	281,
	/* "RA" */	152,
	/* "RC" */	276,
	/* "RF" */	215,
	/* "RI" */	112,
	/* "RX" */	150,
	/* "SA" */	151,
	/* "SC" */	274,
	/* "SF" */	109,
	/* "SR" */	113,
	/* "SX" */	149,
	/* "Sb" */	303,
	/* "Sf" */	302,
	/* "TO" */	282,
	/* "UP" */	114,
	/* "WA" */	286,
	/* "WG" */	278,
	/* "XF" */	154,
	/* "XN" */	153,
	/* "ZA" */	304,
	/* "ZB" */	305,
	/* "ZC" */	306,
	/* "ZD" */	307,
	/* "ZE" */	308,
	/* "ZF" */	309,
	/* "ZG" */	310,
	/* "ZH" */	311,
	/* "ZI" */	312,
	/* "ZJ" */	313,
	/* "ZK" */	314,
	/* "ZL" */	315,
	/* "ZM" */	316,
	/* "ZN" */	317,
	/* "ZO" */	318,
	/* "ZP" */	319,
	/* "ZQ" */	320,
	/* "ZR" */	321,
	/* "ZS" */	322,
	/* "ZT" */	323,
	/* "ZU" */	324,
	/* "ZV" */	325,
	/* "ZW" */	326,
	/* "ZX" */	327,
	/* "ZY" */	328,
	/* "ZZ" */	329,
	/* "Za" */	330,
	/* "Zb" */	331,
	/* "Zc" */	332,
	/* "Zd" */	333,
	/* "Ze" */	334,
	/* "Zf" */	335,
	/* "Zg" */	336,
	/* "Zh" */	337,
	/* "Zi" */	338,
	/* "Zj" */	339,
	/* "Zk" */	340,
	/* "Zl" */	341,
	/* "Zm" */	342,
	/* "Zn" */	343,
	/* "Zo" */	344,
	/* "Zp" */	345,
	/* "Zq" */	346,
	/* "Zr" */	347,
	/* "Zs" */	348,
	/* "Zt" */	349,
	/* "Zu" */	350,
	/* "Zv" */	351,
	/* "Zw" */	352,
	/* "Zx" */	353,
	/* "Zy" */	354,
	/* "ac" */	146,
	/* "ae" */	38,
	/* "al" */	53,
	/* "as" */	25,
	/* "bl" */	1,
	/* "bt" */	0,
	/* "cb" */	269,
	/* "cd" */	7,
	/* "ce" */	6,
	/* "ch" */	8,
	/* "cl" */	5,
	/* "cm" */	10,
	/* "cr" */	2,
	/* "cs" */	3,
	/* "ct" */	4,
	/* "cv" */	127,
	/* "dc" */	21,
	/* "dl" */	22,
	/* "dm" */	29,
	/* "do" */	11,
	/* "ds" */	23,
	/* "eA" */	155,
	/* "ec" */	37,
	/* "ed" */	41,
	/* "ei" */	42,
	/* "ff" */	46,
	/* "fh" */	284,
	/* "fs" */	47,
	/* "hd" */	24,
	/* "ho" */	12,
	/* "hu" */	137,
	/* "i1" */	48,
	/* "i3" */	50,
	/* "iP" */	138,
	/* "ic" */	52,
	/* "if" */	51,
	/* "im" */	31,
	/* "ip" */	54,
	/* "is" */	49,
	/* "k0" */	65,
	/* "k1" */	66,
	/* "k2" */	68,
	/* "k3" */	69,
	/* "k4" */	70,
	/* "k5" */	71,
	/* "k6" */	72,
	/* "k7" */	73,
	/* "k8" */	74,
	/* "k9" */	75,
	/* "k;" */	67,
	/* "kA" */	78,
	/* "kB" */	148,
	/* "kC" */	57,
	/* "kD" */	59,
	/* "kE" */	63,
	/* "kF" */	84,
	/* "kH" */	80,
	/* "kI" */	77,
	/* "kL" */	60,
	/* "kM" */	62,
	/* "kN" */	81,
	/* "kP" */	82,
	/* "kR" */	85,
	/* "kS" */	64,
	/* "kT" */	86,
	/* "ka" */	56,
	/* "kb" */	55,
	/* "kd" */	61,
	/* "ke" */	88,
	/* "kh" */	76,
	/* "kl" */	79,
	/* "kr" */	83,
	/* "ks" */	89,
	/* "kt" */	58,
	/* "ku" */	87,
	/* "l0" */	90,
	/* "l1" */	91,
	/* "l2" */	93,
	/* "l3" */	94,
	/* "l4" */	95,
	/* "l5" */	96,
	/* "l6" */	97,
	/* "l7" */	98,
	/* "l8" */	99,
	/* "l9" */	100,
	/* "la" */	92,
	/* "le" */	14,
	/* "ll" */	18,
	/* "mb" */	26,
	/* "md" */	27,
	/* "me" */	39,
	/* "mh" */	30,
	/* "mk" */	32,
	/* "mm" */	102,
	/* "mo" */	101,
	/* "mp" */	33,
	/* "mr" */	34,
	/* "nd" */	17,
	/* "nw" */	103,
	/* "oc" */	298,
	/* "op" */	297,
	/* "pO" */	144,
	/* "pc" */	104,
	/* "pf" */	119,
	/* "pk" */	115,
	/* "pl" */	116,
	/* "pn" */	147,
	/* "po" */	120,
	/* "ps" */	118,
	/* "px" */	117,
	/* "r1" */	122,
	/* "r2" */	123,
	/* "r3" */	124,
	/* "rP" */	145,
	/* "rc" */	126,
	/* "rf" */	125,
	/* "rp" */	121,
	/* "sa" */	131,
	/* "sc" */	128,
	/* "se" */	43,
	/* "sf" */	129,
	/* "so" */	35,
	/* "sp" */	301,
	/* "sr" */	130,
	/* "st" */	132,
	/* "ta" */	134,
	/* "te" */	40,
	/* "ti" */	28,
	/* "ts" */	135,
	/* "u0" */	287,
	/* "u1" */	288,
	/* "u2" */	289,
	/* "u3" */	290,
	/* "u4" */	291,
	/* "u5" */	292,
	/* "u6" */	293,
	/* "u7" */	294,
	/* "u8" */	295,
	/* "u9" */	296,
	/* "uc" */	136,
	/* "ue" */	44,
	/* "up" */	19,
	/* "us" */	36,
	/* "vb" */	45,
	/* "ve" */	16,
	/* "vi" */	13,
	/* "vs" */	20,
	/* "wi" */	133,
		};

/*
 * Return the value of the boolean capability tcstr.
 * Return 0 if the capability is not found.
 */

tgetflag(tcstr)
register	char	*tcstr;
{
    register	char	*p;
    char	stripped[16];

    switch (_TWOSTR(tcstr))
    {
	/* Special cases that do not have exact terminfo equivalents */
	case _TWO('b','s'):
	    /* bs: true if ^H moves the cursor left */
	    p = _stripdelays(cursor_left, stripped, 16);
	    return (p && *p==8 && p[1] == 0);
	case _TWO('p','t'):
	    /* pt: true if terminal has ^I tabs every 8 spaces */
	    p = _stripdelays(tab, stripped, 16);
	    return (p && *p==9 && p[1] == 0);
	case _TWO('n','c'):
	    /* cr: true if ^M does not return the cursor */
	    p = _stripdelays(carriage_return, stripped, 16);
	    return (! (p && *p==13 && p[1] == 0));
	case _TWO('n','s'):
	    /* ns: true if no way to scroll the terminal */
	    return (scroll_forward == NULL);
    }
    {
	int	n = _NUMELEMENTS(booloffsets);
	int	offset = _tcsearch(tcstr, booloffsets, boolcodes, n, 2);
	char	*bool_array = (char *) cur_bools;

	if (offset == -1)
	    return (0);
	else
	    return (bool_array[offset]);
    }
}

/*
 * Return the value of the numeric capability tcstr.
 * Return -1 if the capability is not found.
 */

tgetnum(tcstr)
register	char	*tcstr;
{
    int		n = _NUMELEMENTS(numoffsets);
    int		offset = _tcsearch(tcstr, numoffsets, numcodes, n, 2);
    short	*num_array = (short *) cur_nums;

    if (offset == -1)
	return (-1);
    else
	return (num_array[offset]);
}

/*
 * Return the string capability for capability "id".  We also copy
 * it into *area for upward compatibility with a few programs that
 * actually expect it to be copied, at a slight cost in speed.
 */

char	*
tgetstr(tcstr, area)
register	char	*tcstr, **area;
{
    int		n = _NUMELEMENTS(stroffsets);
    int		offset = _tcsearch(tcstr, stroffsets, strcodes, n, 2);
    char	**str_array = (char **) cur_strs;
    char	*rv;

    if (offset == -1)
	return (0);
    rv = str_array[offset];
    if (area && *area && rv)
    {
	(void) strcpy(*area, rv);
	*area += strlen(rv) + 1;
    }
    return (rv);
}
