/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) whodo.c: version 25.1 created on 12/2/91 at 18:23:39	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)whodo.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	AT&T: #ident	"whodo:whodo.c	1.20"			*/

#ident	"@(#)whodo:whodo.c	25.1"

/* '/etc/whodo -- combines info from utmp file and process table' */
#include   <stdio.h>
#include   <fcntl.h>
#include   <nlist.h>
#include   <time.h>
#include   <sys/types.h>
#include   <sys/param.h>

#include   <utmp.h>
#include   <pwd.h>
#include   <sys/utsname.h>
#include   <sys/proc.h>
#include   <sys/var.h>
#include   <sys/stat.h>
#include   <sys/signal.h>
#include   <sys/fs/s5dir.h>
#include   <sys/user.h>
#include   <sys/sysmacros.h>

#ifdef S3000
#include	<sys/kmem.h>
#endif

#ifndef pdp11

#define KMEM    "/dev/kmem"
#else
#define KMEM    "/dev/mem"
#endif
#define MEM     "/dev/mem"
#define ENTRY   sizeof(struct psdata)
#define ERR     (-1)
#define PROC    nl[0]
#define SWAP    nl[1]
#define VAR     nl[2]
#define SBR     nl[3]
#define error(str)      fprintf(stderr, "%s: %s\n", arg0, str)
#define prerror(str)    fprintf(stderr, "%s: %s: %s\n", \
                                arg0, str, sys_errlist[errno])

#define PROC_STR        "proc"
#define V_STR           "v"
#define SWAPLO_STR      "swplo"

struct nlist nl[] = {
        { PROC_STR },
        { SWAPLO_STR },
        { V_STR },
        { 0 }
};

/**
 * file /etc/ps_data is built by ps command,
 * only use 1st part (device info) and
 * 3rd part (/unix namelist info)
 **/
struct psdata {
        char    device[DIRSIZ];
        short   dev;    /* major/minor of device */
} ;
struct udata {  /* only used for size of entry */
        ushort  userid;
        char    usernm[8];
} ;
int             ndevs;  /* number of dev info entries to follow */
struct psdata   *psptr;

struct proc     *pp;
struct uproc {
        short   p_ttyd;
        time_t  p_time;
        char    p_comm[DIRSIZ];
} *uproc_table;

extern	time_t	time();
struct passwd   *getpwnam(), *getpwuid();
struct var      v;
unsigned        Proc, V, size;
int             fd, kmem, memfd, swap;
char            *arg0;
long            swaplo;
extern int      errno;
extern char     *sys_errlist[];
extern char     *optarg;
int             uid;
struct user     uarea;

main(argc, argv)
int  argc;
char *argv[];
{
        register struct utmp    *ut;
        register struct tm      *tm;
        register struct proc    *p;
        struct user     *u, *getuarea();
        struct uproc    *up;
        unsigned        utmpend;
        struct tm       *localtime();
        struct stat     sbuf;
        struct utsname  uts;
        char            *malloc();
        char            *getty();
        long            clock;
        int             aflag = 0;
        int             uflag = 0;
        int             c;

        arg0 = argv[0];

        /**
         * print current time and date
         **/
        time(&clock);
        printf("%s", ctime(&clock));

        /**
         * print system name
         **/
        uname(&uts);
        printf("%s\n", uts.sysname);

        /**
         * read in device info from ps_data file
         **/
        if((fd = open("/etc/ps_data", O_RDONLY)) == ERR) {
                prerror("open error of /etc/ps_data");
                exit(1);
        }
        /* first int tells how many entries follow */
        if(read(fd, (char *)&ndevs, sizeof(ndevs)) == ERR) {
                prerror("read error of size of device table info");
                exit(1);
        }
        if((psptr = (struct psdata *)malloc(ndevs*ENTRY)) == NULL) {
                prerror("malloc error of ps_data device table");
                exit(1);
        }
        if(read(fd, (char *)psptr, ndevs*ENTRY) == ERR) {
                prerror("read error of /etc/ps_data device info");
                exit(1);
        }
        /**
         * skip past uid data in /etc/ps_data
         **/
        if(read(fd, (char *)&size, sizeof(size)) == ERR) {
                prerror("read error of number of /etc/ps_data uid entries");
                exit(1);
        }
        if(lseek(fd, (long)(size*sizeof(struct udata)), 1) == ERR) {
                prerror("seek error of skipping uid entries in /etc/ps_data");
                exit(1);
        }
        /**
         * fill in the name list table from /etc/ps_data
         **/
        if(read(fd, (char *)nl, sizeof(nl)) == ERR) {
                prerror("read error of namelist data from /etc/ps_data");
                exit(1);
        }
        close(fd);

        /**
         * check offsets into memory for pointers
         **/
        if(PROC.n_value == 0) {
                error("can't find process table");
                exit(1);
        }
        if(VAR.n_value == 0) {
                error("can't find variables table");
                exit(1);
        }
        if((swaplo = (long)SWAP.n_value) == 0L) {
                error("can't find base of swap");
                exit(1);
        }
        Proc = PROC.n_value;
        V = VAR.n_value;

        /**
         * open memory file(s)
         **/
        if((kmem = open(KMEM, O_RDONLY)) == ERR) {
                prerror("open error of /dev/kmem");
                exit(1);
        }
        if((memfd  = open(MEM,  O_RDONLY)) == ERR) {
                prerror("open error of /dev/mem");
                exit(1);
        }

        swap = openswap();
        initswaplo();

        /**
         * read in system variable table
         **/
#ifdef S3000
        if(lseek(kmem, kv_to_kmem((uint)V), 0) == ERR) {
#else
        if(lseek(kmem, (long)V, 0) == ERR) {
#endif
                prerror("seek error of variable table");
                exit(1);
        }
        if(read(kmem, (char *)&v, sizeof(struct var)) == ERR) {
                prerror("read error of variable table");
                exit(1);
        }

        /**
         * read in current /etc/utmp file
         **/
        if(stat(UTMP_FILE, &sbuf) == ERR) {
                prerror("stat error of /etc/utmp");
                exit(1);
        }
        size = (unsigned)sbuf.st_size;
        if((ut = (struct utmp *)malloc(size)) == NULL) {
                prerror("malloc error of utmp file");
                exit(1);
        }
        if((fd = open(UTMP_FILE, O_RDONLY)) == ERR) {
                prerror("open error of /etc/utmp");
                exit(1);
        }
        if(read(fd, (char *)ut, size) == ERR) {
                prerror("read error of /etc/utmp");
                exit(1);
        }
        utmpend = (unsigned)ut + size;  /* ptr to end of utmp data */
        close(fd);


        /**
         * allocate a process table
         **/
        if(sizeof(struct proc) < sizeof(struct uproc)) {
                error("size error: uproc larger than proc");
                exit(1);
        }
        size = ((uint)v.ve_proc - (uint)PROC.n_value) / sizeof(struct proc);
        if((pp = (struct proc *)malloc(sizeof(struct proc)*size)) == NULL) {
                prerror("malloc error of process table");
                exit(1);
        }
        if((uproc_table = (struct uproc *)malloc(sizeof(struct uproc)*size)) 
			== NULL) {
                prerror("malloc error of user table");
                exit(1);
        }
#ifdef S3000
        if(lseek(kmem, kv_to_kmem((uint)Proc), 0) == ERR) {
#else
        if(lseek(kmem, (long)Proc, 0) == ERR) {
#endif
                prerror("seek error of process table");
                exit(1);
        }
        if(read(kmem, (char *)pp, sizeof(struct proc)*size) == ERR) {
                prerror("read error of process table");
                exit(1);
        }

        /**
         * gather uarea and plug in applicable data
         * into the process table slot mask
         */
        for(p = pp, up = uproc_table; p < (struct proc *)&pp[size]; ++p,++up){
                if(! p->p_stat || p->p_stat==SZOMB || p->p_stat==SIDL)
                        continue;
                if((u = getuarea(p)) == NULL) {
                        /* process has disappeared */
                        p->p_stat = 0;
                        continue;
                }
                up->p_ttyd = u->u_ttyd;
                up->p_time = u->u_utime + u->u_stime;
                strncpy(up->p_comm, u->u_comm, DIRSIZ);
        }
        close(kmem);
        close(memfd);

        /**
         * loop through utmp file, printing process info
         * about each logged in user
         **/
        for(; ut < (struct utmp *)utmpend; ut++) {
                if(ut->ut_type != USER_PROCESS)
                        continue;
                tm = localtime(&ut->ut_time);
                printf("\n%-8.8s %-8.8s %2.1d:%2.2d\n",
                        ut->ut_line, ut->ut_name, tm->tm_hour, tm->tm_min);
                uid = getpwnam(ut->ut_name)->pw_uid;
                sproc(ut->ut_pid);
        }
}

sproc(pid)
register short pid;
{
        register struct proc    *p;
        register struct uproc   *up;
        char                    *getty();
        register int            found = 0;

        for(p = pp, up = uproc_table; p < &pp[size]; p++, up++) {
                if(! p->p_stat)
                        continue;

                if(pid == p->p_ppid || pid == p->p_pgrp)
                        found++;

                if(found || pid==p->p_pid) {
                        if(p->p_stat == SZOMB || p->p_stat == SIDL)
                                printf("    %-7.7s %5d %4.1ld:%2.2ld %s\n",
                                        "  ?", p->p_pid, 0L, 0L, "<defunct>");
                        else {
                                up->p_time = (up->p_time + HZ / 2L) / HZ;
                                printf("    %-7.7s %5d %4.1ld:%2.2ld %s\n",
                                        getty(up->p_ttyd), p->p_pid,
                                        up->p_time/60L, up->p_time%60L,
                                        up->p_comm);
                        }
                        p->p_stat =  0;
                }
                if(found) {
                        found = 0;
                        sproc(p->p_pid);
                }
        }
}

struct user *
getuarea(p)
register struct proc *p;
{
        register long   addr;
        register int    c;
        fd = memfd;

	/*
	 *	Pages in the user page table are contiguous on a 3b15 
	 *	but not on a 3b2.
	 */	


#ifdef S3000
	addr = kv_to_mem( (uint)p->p_userp );
#else
	addr=(p->p_addr.pgi.pg_pde & 0x0fff0000) >> 4;
#endif
	lseek(fd, addr, 0);
	if(read(fd, (char *)&uarea, sizeof (uarea)) != sizeof (uarea)){
                perror("read error on ublock");
		return(NULL);
	}
        return(&uarea);
}

char *
getty(dev)
register short dev;
{
        register struct psdata *ps;

        for(ps = psptr; ps < &psptr[ndevs]; ps++) {
                if(ps->dev == dev)
                        return(ps->device);
        }
        return("  ?  ");
}

openswap()
{
        int     swp;

        if((swp = open("/dev/swap", O_RDONLY)) == ERR) {
                prerror("open error of /dev/swap");
                exit(1);
        }
        return(swp);
}

initswaplo()
{
        /**
         * read in base of swap
         **/
#ifdef S3000
        if(lseek(kmem, kv_to_kmem((uint)swaplo), 0) == ERR) {
#else
        if(lseek(kmem, swaplo, 0) == ERR) {
#endif
                prerror("seek error of swplo symbol");
                exit(1);
        }
        if(read(kmem, (char *)&swaplo, sizeof(swaplo)) == ERR) {
                prerror("read error of swplo value");
                exit(1);
        }
}
