#	START NEW ARIX SCCS HEADER
#
#	@(#) misc.mk: version 25.1 created on 12/2/91 at 18:21:37
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)misc.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.
#	ATT: ident	"vi:misc/makefile	1.10"

#	Makefile for misc directory for vi

#ident	"@(#)vi:misc.mk	25.1"

include	$(IROOT)/macdefs

DIR = $(ROOT)/usr/bin

INC = $(ROOT)/usr/include

SIZE = size

#Must use cc not $(CC) for xstr and mkstr

MAKEFILE = makefile

MAINS = ctags fold mkstr xstr cxref

OBJECTS =  ctags.o fold.o mkstr.o xstr.o

SOURCES =  ctags.c fold.c mkstr.c xstr.c cxref.sh

ALL:		$(MAINS)

all : ALL

install: ALL
	$(INS) ctags $(DIR)/ctags
	chmod 755 $(DIR)/ctags
	chgrp bin $(DIR)/ctags
	chown bin $(DIR)/ctags

ctags:		ctags.o	
	$(CC)  ctags.o -o ctags $(LDFLAGS)

ctags.o:	ctags.c
	$(CC) $(CFLAGS) -c ctags.c

fold:		fold.o 
	$(CC)  fold.o -o fold  $(LDFLAGS)

fold.o:	fold.c
	$(CC) $(CFLAGS) -c fold.c

mkstr:		mkstr.c	
	$(SGS_NATIVE)/bin/cc -O -I$(LOCALINCS) mkstr.c -o mkstr

xstr:		xstr.c 
	$(SGS_NATIVE)/bin/cc -O -I$(LOCALINCS) xstr.c -o xstr

ctags.o:	 $(INCRT)/stdio.h $(INCRT)/ctype.h 

fold.o:		 $(INCRT)/stdio.h 

mkstr.o:	 $(INCRT)/stdio.h $(INCRT)/sys/types.h \
		 $(INCRT)/sys/stat.h 

xstr.o:		 $(INCRT)/stdio.h $(INCRT)/ctype.h \
		 $(INCRT)/sys/types.h $(INCRT)/signal.h	\
		 $(INCRT)/sys/signal.h 

GLOBALINCS = $(INCRT)/ctype.h $(INCRT)/signal.h $(INCRT)/stdio.h \
	$(INCRT)/sys/signal.h $(INCRT)/sys/stat.h \
	$(INCRT)/sys/types.h 


clean:
	rm -f $(OBJECTS)

clobber:
	rm -f $(OBJECTS) $(MAINS)

size: ctags
	$(SIZE) ctags

strip: ALL
	$(STRIP) $(MAINS)


partslist:
	@echo $(MAKEFILE) $(SOURCES) $(LOCALINCS)  |  tr ' ' '\012'  |  sort

productdir:
	@echo $(DIR) | tr ' ' '\012' | sort

product:
	@echo ctags  |  tr ' ' '\012' | \
	sed 's;^;$(DIR)/;'

srcaudit:
	@fileaudit $(MAKEFILE) $(LOCALINCS) $(SOURCES) READ_ME del.h.cb -o $(OBJECTS) $(MAINS)


