/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) ex_unix.c: version 25.1 created on 12/2/91 at 18:19:39	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)ex_unix.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* Copyright (c) 1979 Regents of the University of California */
/*	AT&T: #ident	"vi:port/ex_unix.c	1.15"		*/

#ident	"@(#)vi/mach:ex_unix.c	25.1"

#include "ex.h"
#include "ex_temp.h"
#include "ex_tty.h"
#include "ex_vis.h"

/*
 * Unix escapes, filtering
 */

/*
 * First part of a shell escape,
 * parse the line, expanding # and % and ! and printing if implied.
 */
unix0(warn)
	bool warn;
{
	register char *up, *fp;
	register short c;
	char printub, puxb[UXBSIZE + sizeof (int)];
	printub = 0;
	CP(puxb, uxb);
	c = getchar();
	if (c == '\n' || c == EOF)
		error("Incomplete shell escape command@- use 'shell' to get a shell");
	up = uxb;
	do {
		switch (c) {

		case '\\':
			if (any(peekchar(), "%#!"))
				c = getchar();
		default:
			if (up >= &uxb[UXBSIZE]) {
tunix:
				uxb[0] = 0;
				error("Command too long");
			}
			*up++ = c;
			break;

		case '!':
			if ((up != uxb) && (peekchar() == '!')) {
				/*
				 * If the command has a '!!' discard the
				 * previous '!' and the one we peeked at
				 * and substitute the previous command.
				 */
				getchar();
				fp = puxb;
				if (*fp == 0) {
					uxb[0] = 0;
					error("No previous command@to substitute for !");
				}
				printub++;
				while (*fp) {
					if (up >= &uxb[UXBSIZE])
						goto tunix;
					*up++ = *fp++;
				}
			} else if (up == uxb) {
				/* If up = uxb it means we are on the first
				 * character inside the shell command.
				 * (i.e., after the ":!")
				 *
				 * The user has just entered ":!!" which
				 * means that though there is only technically
				 * one '!' we know he really meant ":!!!". So
				 * substitute the last command for him.
				 */
				fp = puxb;
				if (*fp == 0) {
					uxb[0] = 0;
					error("No previous command@to substitute for !");
				}
				printub++;
				while (*fp) {
					if (up >= &uxb[UXBSIZE])
						goto tunix;
					*up++ = *fp++;
				}
			} else {
				/*
				 * Treat a lone "!" as just a regular character
				 * so commands like "mail machine!login" will
				 * work as usual (i.e., the user doesn't need
				 * to dereference the "!" with "\!").
				 */
				if (up >= &uxb[UXBSIZE]) {
					uxb[0] = 0;
					error("Command too long");
				}
				*up++ = c;
			} 
			break;

		case '#':
			fp = altfile;
			if (*fp == 0) {
				uxb[0] = 0;
				error("No alternate filename@to substitute for #");
			}
			goto uexp;

		case '%':
			fp = savedfile;
			if (*fp == 0) {
				uxb[0] = 0;
				error("No filename@to substitute for %%");
			}
uexp:
			printub++;
			while (*fp) {
				if (up >= &uxb[UXBSIZE])
					goto tunix;
				*up++ = *fp++;
			}
			break;
		}
		c = getchar();
	} while (c == '"' || c == '|' || !endcmd(c));
	if (c == EOF)
		ungetchar(c);
	*up = 0;
	if (!inopen)
		resetflav();
	if (warn)
		ckaw();
	if (warn && hush == 0 && chng && xchng != chng && value(vi_WARN) && dol > zero) {
		xchng = chng;
		vnfl();
		printf(mesg("[No write]|[No write since last change]"));
		noonl();
		flush();
	} else
		warn = 0;
	if (printub) {
		if (uxb[0] == 0)
			error("No previous command@to repeat");
		if (inopen) {
			splitw++;
			vclean();
			vgoto(WECHO, 0);
		}
		if (warn)
			vnfl();
		if (hush == 0)
			lprintf("!%s", uxb);
		if (inopen && Outchar != termchar) {
			vclreol();
			vgoto(WECHO, 0);
		} else
			putnl();
		flush();
	}
}

/*
 * Do the real work for execution of a shell escape.
 * Mode is like the number passed to open system calls
 * and indicates filtering.  If input is implied, newstdin
 * must have been setup already.
 */
ttymode
unixex(opt, up, newstdin, mode)
	char *opt, *up;
	int newstdin, mode;
{
	int pvec[2];
	ttymode f;
	char *strrchr(), *tmp_ptr;

	signal(SIGINT, SIG_IGN);
#ifdef SIGTSTP
	if (dosusp)
		signal(SIGTSTP, SIG_DFL);
#endif
	if (inopen)
		f = setty(normf);
	if ((mode & 1) && pipe(pvec) < 0) {
		/* Newstdin should be io so it will be closed */
		if (inopen)
			setty(f);
		error("Can't make pipe for filter");
	}
#ifndef VFORK
	pid = fork();
#else
	pid = vfork();
#endif
	if (pid < 0) {
		if (mode & 1) {
			close(pvec[0]);
			close(pvec[1]);
		}
		setrupt();
		if (inopen)
			setty(f);
		error("No more processes");
	}
	if (pid == 0) {
		if (mode & 2) {
			close(0);
			dup(newstdin);
			close(newstdin);
		}
		if (mode & 1) {
			close(pvec[0]);
			close(1);
			dup(pvec[1]);
			if (inopen) {
				close(2);
				dup(1);
			}
			close(pvec[1]);
		}
		if (io)
			close(io);
		if (tfile)
			close(tfile);
#ifndef VMUNIX
		close(erfile);
#endif
		signal(SIGHUP, oldhup);
		signal(SIGQUIT, oldquit);
		if (ruptible)
			signal(SIGINT, SIG_DFL);

		/* we want to print the shell that was actually used */
		/* but print the shell only, not the path to it if there */
		 if ( !( tmp_ptr = strrchr( svalue( vi_SHELL ), '/' ) ) )
			 tmp_ptr = svalue( vi_SHELL ); /* no path */
		 else
			 tmp_ptr++;	/* skip final "/" in path */
	 	execlp(svalue(vi_SHELL), tmp_ptr, opt, up, (char *) 0);

		printf("Invalid SHELL value: %s\n", svalue(vi_SHELL));
		flush();
		error(NOSTR);
	}
	if (mode & 1) {
		io = pvec[0];
		close(pvec[1]);
	}
	if (newstdin)
		close(newstdin);
	return (f);
}

/*
 * Wait for the command to complete.
 * F is for restoration of tty mode if from open/visual.
 * C flags suppression of printing.
 */
unixwt(c, f)
	bool c;
	ttymode f;
{

	waitfor();
#ifdef SIGTSTP
	if (dosusp)
		signal(SIGTSTP, onsusp);
#endif
	if (inopen)
		setty(f);
	setrupt();
	if (!inopen && c && hush == 0) {
		printf("!\n");
		flush();
		termreset();
		gettmode();
	}
}

/*
 * Setup a pipeline for the filtration implied by mode
 * which is like a open number.  If input is required to
 * the filter, then a child editor is created to write it.
 * If output is required, catch it from io which is created by unixex.
 * values for mode: 0 = get filter's output, send nothing to filter
 *                  1 = send lines from file to filter, ignore filter's output
 *                  2 = replace lines from file with filter's output
 */
vi_filter(mode)
	register int mode;
{
	static int pvec[2];
	ttymode f;	/* was register */
	register int nlines = lineDOL();

	mode++;
	/* new values for mode: 
	 * 1 = get filter's output, send nothing to filter
	 * 2 = send lines from file to filter, ignore filter's output
	 * 3 = replace lines from file with filter's output
	 */
	if (mode & 2) {
		/* create child editor process to feed data to filter */
		signal(SIGINT, SIG_IGN);
		if (pipe(pvec) < 0)
			error("Can't make pipe");
		pid2 = fork();
		io = pvec[0];
		if (pid2 < 0) {
			setrupt();
			close(pvec[1]);
			error("No more processes");
		}
		if (pid2 == 0) {	/* in child editor */
			setrupt();
			io = pvec[1];
			close(pvec[0]);
			putfile(1);
			exit(errcnt);	/* end of child editor */
		}
		close(pvec[1]);
		io = pvec[0];
		setrupt();
	}
	f = unixex("-c", uxb, (mode & 2) ? pvec[0] : 0, mode);
	if (mode == 3) {
		delete(0);
		addr2 = addr1 - 1;
	}
	if (mode == 1)
		deletenone();
	if (mode & 1) {
		if(FIXUNDO)
			undap1 = undap2 = addr2+1;
		ignore(append(getfile, addr2));
#ifdef UNDOTRACE
		if (trace)
			vudump("after append in filter");
#endif
	}
	close(io);
	io = -1;
	unixwt(!inopen, f);	/* wait for both children */
	netchHAD(nlines);
}

/*
 * Set up to do a recover, getting io to be a pipe from
 * the recover process.
 */
recover()
{
	static int pvec[2];

	if (pipe(pvec) < 0)
		error(" Can't make pipe for recovery");
	pid = fork();
	io = pvec[0];
	if (pid < 0) {
		close(pvec[1]);
		error(" Can't fork to execute recovery");
	}
	if (pid == 0) {
		char cryptkey[19];
		close(2);
		dup(1);
		close(1);
		dup(pvec[1]);
	        close(pvec[1]);
#ifdef CRYPT
		if(xflag) {
			strcpy(cryptkey, "CrYpTkEy=XXXXXXXXX");
			strcpy(cryptkey + 9, key);
			if(putenv(cryptkey) != 0)
				smerror(" Cannot copy key to environment");
			execlp(EXRECOVER, "exrecover", "-x", svalue(vi_DIRECTORY), file, (char *) 0);
		} else
			execlp(EXRECOVER, "exrecover", svalue(vi_DIRECTORY), file, (char *) 0);
#else
		execlp(EXRECOVER, "exrecover", svalue(vi_DIRECTORY), file, (char *) 0);
#endif /* CRYPT */
		close(1);
		dup(2);
		error(" No recovery routine");
	}
	close(pvec[1]);
}

/*
 * Wait for the children to complete.  (pids is an external array) 
 */
waitfor()
{
	int lstatus;

	while (( rpid = wait(&lstatus) ) != -1 ) {
		if (rpid == pid ) {
			status = lstatus;
			if ((status & 0377) == 0) {
				status = (status >> 8) & 0377;
			} else {
				printf("%d: terminated with signal %d", 
					rpid, status & 0177);
				if (status & 0200)
					printf(" -- core dumped");
				putchar('\n');
			}
		}
	}
	pid2 = -1;	
}

/*
 * The end of a recover operation.  If the process
 * exits non-zero, force not edited; otherwise force
 * a write.
 */
revocer()
{

	waitfor();
	if (pid == rpid && status != 0)
		edited = 0;
	else
		change();
}
