/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) ulim.c: version 25.1 created on 12/2/91 at 18:11:10	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)ulim.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*    @(#)ulim.c    1.0
 *
 *    The shell, ulimit and no_files types are defined in the file 
 *    "/etc/ulimrc" with the following format:
 *
 *        user_name <tab> shell <tab> ulimit <tab> [no_of_files]
 *
 *        smith	/bin/csh	512000	128
 *        
 *        ulimit may be marked as not to be changed with '-'
 *
 *        john	/bin/ksh	-	100
 *
 *        The fourth argument is optional
 *
 *        guest /bin/sh	10000
 *
 *
 *    kd0 - kelly - 7/10/87     ulim now handles a user name of 8 characters
 *    kd1 - kelly - 8/3/87      ulim now handles pathnames (specified in
 *                              /etc/ulimrc) of up to 128 characters.
 *    kd2 - kelly - 9/26/87     ulim now allows the user to execute shell
 *                              scripts rather than a shell from /etc/ulimrc
 *    hvh - henrik - 8/20/91    ulim now handles options for number of files
 *                              a user can access 
 *
 *
 *    Define 'LOGIN_ONLY' on the compile line to allow the use of ulim by
 *    login or 'exec /local/bin/ulim' only.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>    
#include <sys/resource.h>
#include <utmp.h>

#define LONG_STR     81
#define SHORT_STR    15
#define PATH_STR    128    
#define SET_LIMIT     2

char def_shell[] = "/bin/sh";

extern int    errno;
extern char   *sys_errlist[];

/*
 * pathend -- return the last component of a pathname, or the entire string
 */

char *
pathend(path)
char    *path;
{
    char *p, *strrchr();

    if (p = strrchr(path, '/'))
        return (p + 1);
    return (p);
}

main(argc,argv) 
char *argv[];
{
    int ttys, i, cool = 0, c, no_files; 
    struct utmp *getutent(), *up;
    struct rlimit rlp;    
    long ulimit(), u;
    FILE *fp, *fopen();
    char tmpstr[LONG_STR];
    char uname[SHORT_STR],
        shell[PATH_STR],    
        process[PATH_STR];    
    char u_str[LONG_STR], *Shell, *p;
    char *outarg[10];       /* hh1 - argumant list to pass to shell */


    ttys = ttyslot( );
    for( ; ttys >= 0; ttys-- )
        if((up = getutent()) == NULL) 
        {
            fprintf(stderr,"%s: Can't find utmp entry.\n",argv[0]);    
            exit( -10 ); 
        }

    if( (fp=fopen("/etc/ulimrc","r")) == NULL)
        fprintf(stderr,"%s: Cannot open /etc/ulimrc\n",argv[0]);
    else while( fgets( tmpstr, LONG_STR, fp ) != NULL ) 
    {
        if(( c=sscanf(tmpstr,"%s\t%s\t%s\t%ld\n", uname, shell, u_str, 
                &no_files )) == 3 || c == 4) 
        {     /* if the names don't match, get next name */
            if (strncmp(uname, up->ut_user, sizeof(up->ut_user)))
                continue;
            /* else, if login id is the right one, set ulimit */
            ++cool;

#ifdef LOGIN_ONLY
            if( up->ut_pid == getpid( ) ) 
            {
#endif /* LOGIN_ONLY */
                /* check for default option in ulimit '-' */
                if (strcmp(u_str, "-")) 
                {
                    if ((u = strtol(u_str, &p, 10)) <= 0 || p == u_str) 
                        fprintf(stderr, 
                                "%s: bad ulimit value '%s', using default.\n", 
                                argv[0], u_str);
                    else if (ulimit(SET_LIMIT, u) == -1) 
                        fprintf(stderr, "%s: ulimit call failed (%s)\n",
                                argv[0], sys_errlist[errno]);
                }

                /*  Start for no_files limit handling */
                if( c == 4 ) 
                { 
                    if (getrlimit(RLIMIT_NOFILE,&rlp)==-1) 
                    {
                        fprintf(stderr,"%s: getrlimit call failed\n",argv[0]);
                        perror("getrlimit RLIMIT_NOFILE");
                    }
                    rlp.rlim_cur=no_files; 
                    if (setrlimit(RLIMIT_NOFILE,&rlp)==-1) 
                    {
                        fprintf(stderr,"%s: setrlimit call failed\n",argv[0]); 
                        perror("setrlimit RLIMIT_NOFILE");
                    }
                } /* end of no_file handling */    
#ifdef LOGIN_ONLY
            } 
#endif /* LOGIN_ONLY */
            break;
        } else fprintf(stderr,"%s: Format error in /etc/ulimrc\n",argv[0]);
    }

    fclose(fp);

    if (!cool)
        strcpy(shell, def_shell);
    p = pathend(shell);
    strcpy(&process[1], p);
    process[0] = '-';            /* must have "-<shell_name>" */

/* sw0 - Set SHELL environment variable */
    Shell=(char *)malloc(strlen("SHELL=") + strlen(shell) + 1);
    strcpy(Shell,"SHELL=");
    strcat(Shell,shell);
    putenv(Shell);
    setuid(getuid( ));

    /* set up outarg to do execvp  */
    outarg[0] = process;
    for(i=1;i<argc;i++)
        outarg[i] = argv[i];
    outarg[i] = 0;
    printf("ulim : exec'ing %s\n",process);
    execvp(shell,outarg);
}
