#	START NEW ARIX SCCS HEADER
#
#	@(#) u.mk: version 25.1 created on 12/2/91 at 18:11:07
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)u.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#

#ident	"@(#)u:u.mk	25.1"
IROOT =
include $(IROOT)/macdefs

ETCINS		=	$(ROOT)/etc
BININS		=	$(ROOT)/bin
USRINS		=	$(ROOT)/usr/bin
LBININS		=	$(ROOT)/local/bin
LBINSRC		=	$(ROOT)/local/src

FILES		=\
		$(ETC)\
		$(BIN)\
		$(LBIN) \
		$(USR)

ETC		=	unlink

BIN		=	

LBIN		=	ulim

USR		=	uniq 

all:	$(FILES)

install: insulimrc insunlink insuniq insulim

unlink:
	$(CC)  $(CFLAGS) -o unlink unlink.c $(LDFLAGS)

insunlink: unlink
	$(INS) unlink $(ETCINS)/unlink 
	chmod 700 $(ETCINS)/unlink 
	chown root $(ETCINS)/unlink 
	chgrp sys $(ETCINS)/unlink 
uniq:
	$(CC)  $(CFLAGS) -o uniq uniq.c $(LDFLAGS)

insuniq: uniq
	$(INS) uniq $(USRINS)/uniq 
	chmod 755 $(USRINS)/uniq 
	chown bin $(USRINS)/uniq 
	chgrp bin $(USRINS)/uniq 

ulim:
	$(CC)  $(CFLAGS) -o ulim ulim.c $(LDFLAGS)

insulim: ulim
	$(INS) ulim $(LBININS)/ulim 
	chmod 4755 $(LBININS)/ulim 
	chown root $(LBININS)/ulim 
	chgrp sys $(LBININS)/ulim 
	$(INS) ulim.c $(LBINSRC)/ulim.c
	chmod 644 $(LBINSRC)/ulim.c
	chown root $(LBINSRC)/ulim.c
	chgrp sys $(LBINSRC)/ulim.c

insulimrc: 
	cat > ulimrc
	$(INS) ulimrc $(ETCINS)/ulimrc
	chmod 644 $(ETCINS)/ulimrc
	chown root $(ETCINS)/ulimrc
	chgrp sys $(ETCINS)/ulimrc

clean:
	rm -f *.o

clobber: clean
	rm -rf $(FILES) greplist tags ulimrc

ctags:
	@-if [ "$(SOURCE)" = "" ] ;\
	then 					\
	echo " usage: $(MAKE) -$(MAKEFLAGS)f b.mk ctags SOURCE=utility_name" ;\
	else				\
	ctags	$(SOURCE)	;\
	echo 'grep $$* \\' > greplist 	;\
	for i in $(SOURCE)  /dev/null	;\
	do 				\
	echo "$$i \\" >> greplist	;\
	done 				;\
	echo /dev/null >> greplist	;\
	chmod +x greplist		;\
	fi


