/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) tar.c: version 25.1 created on 12/2/91 at 18:09:38	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)tar.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT:#ident "tar:tar.c	1.18"	*/
/*	sw0 - judy	fixed 'f' option so that 'b' is not needed */


#ident	"@(#)t:tar.c	25.1"

#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
/* #include <sys/fs/s5dir.h>   */
#include <dirent.h> 
#include <grp.h>
#include <pwd.h>
#include <sys/acl.h>

extern void	exit();
extern FILE	*fopen();
extern char	*getcwd();
extern long	lseek();
extern char	*malloc();
extern char	*mktemp();
extern char	*strcat();
extern char	*strcpy();
extern time_t	time();
extern int	errno;
extern char	*sys_errlist[];
extern	struct	group	*getgrgid (), *getgrnam ();
extern	struct	passwd	*getpwuid(), *getpwnam ();
void	set_uid_gid ();
void	sub_dirs(); 

daddr_t bsrch();
#define TBLOCK	512
#define NBLOCK	20
#define NAMSIZ	100

#define	SYMLINK	1

#include <tar.h>

union hblock {
	char dummy[TBLOCK];
	struct header dbuf;
} dblock, tbuf[NBLOCK];

struct linkbuf {
	ino_t	inum;
	dev_t	devnum;
	int	count;
	char	pathname[NAMSIZ];
	struct	linkbuf *nextp;
} *ihead;

struct stat stbuf;

int	rflag, xflag, vflag, tflag, mt, cflag, mflag, oflag, chrflg;
int	term, chksum, wflag, recno, first, linkerrok, save_sec;
int	freemem = 1;
int	nblock = 1;

#ifdef	SYMLINK
int	follow_flag;
#endif

daddr_t	low;
daddr_t	high;

FILE	*tfile;
char	tname[] = "/tmp/tarXXXXXX";

char	*usefile;
char	magtape[]	= "/dev/rmt1";

/* stuff for archive drive	*/
#include <sys/ioctl.h>
#define RQSIZE 0x40000
#define TAPE 2
int	qflag,type,c;
char	*addr;
/* end archiive stuff 		*/

main(argc, argv)
int	argc;
char	*argv[];
{
	char *cp;
	char er_strng[64];		/* old copy of sys_errlist[errno] */
	void onintr(), onquit(), onhup();
					/* fflg & uflg used to reject     */
	int fflg = 0, uflg = 0;		/* multiple keys		  */
	int bflg = 0;			/* bflg used to insure b function */
					/* modifier is specified for read */
					/* of char special device	  */
	if (argc < 2)
		usage();

	tfile = NULL;
	usefile =  magtape;
	argv[argc] = 0;
	argv++;
	for ( cp = *argv++; *cp; cp++ )
		switch(*cp) {
		case 'f':
			if (bflg) {
				fprintf(stderr, "tar: function modifier f must precede function modifier b\n");
				usage();
			}
			fflg++;
			usefile = *argv++;
			if (nblock == 1)
				nblock = 0;
			break;
		case 'c':
			cflag++;
			rflag++;
			break;
		case 'u':
			if (++uflg > 1) {
				fprintf(stderr, "tar: Only one instance of the u key is allowed\n");
				usage();
			}
			mktemp(tname);
			if ((tfile = fopen(tname, "w")) == NULL) {
				fprintf(stderr, "tar: cannot create temporary file (%s)\n", tname);
				done(1);
			}
			fprintf(tfile, "!!!!!/!/!/!/!/!/!/! 000\n");
			/* FALL THROUGH */
		case 'r':
			rflag++;
			if (nblock != 1 && cflag == 0) {
noupdate:
				fprintf(stderr, "tar: Blocked tapes cannot be updated (yet)\n");
				done(1);
			}
			break;
		case 'v':
			vflag++;
			break;
		case 'w':
			wflag++;
			break;
		case 'x':
			xflag++;
			break;
		case 't':
			tflag++;
			break;
		case 'm':
			mflag++;
			break;

		case '-':
			break;

		case 'b':
			bflg++;
			nblock = atoi(*argv++);
			if (nblock > NBLOCK || nblock <= 0) {
				fprintf(stderr, "tar: invalid blocksize, %s. (Max %d)\n",
				*(argv - 1), NBLOCK);
				done(1);
			}
			if (rflag && !cflag)
				goto noupdate;
			break;
		case 'l':
			linkerrok++;
			break;
		case 'o':
			oflag++;
			break;
		case 'q':
			qflag++;
			usefile = magtape;
			break;
#ifdef	SYMLINK
		case 'L':		/* Follow symbolic links... */
			follow_flag++;
			break;
#endif
		case 'Z':		/* Save security (MACS, privs, acls) */
			save_sec++;
			break;
		default:
			fprintf(stderr, "tar: %c: unknown option\n", *cp);
			usage();
		}

	if ((xflag + tflag + rflag) > 1 || (uflg + rflag) > 2 || (cflag + rflag) > 2) {
		fprintf(stderr, "tar: Only one of the c, x, t, u or r keys is allowed\n");
		usage();
	}
	if (bflg  > 1 || fflg  > 1 || linkerrok > 1 ||
	   mflag  > 1 || oflag > 1 || vflag     > 1 || wflag > 1) {
		fprintf(stderr, "tar: Only one instance each of the b, f, m, o, v and w function modifiers is allowed\n");
		usage();
	}
	if ((linkerrok && xflag) || (linkerrok && tflag)) {
		fprintf(stderr, "tar: Function modifier l valid only with c, r and u keys\n");
		usage();
	}

	if (mflag && !xflag) {
		fprintf(stderr, "tar: Function modifier m valid only with x key\n");
		usage();
	}
	
	if (wflag && tflag) {
		fprintf(stderr, "tar: Function modifier w invalid with t key\n");
		usage();
	}
	if (oflag && !xflag) {
		fprintf(stderr, "tar: Function modifier o valid only with x key\n");
		usage();
	}
	if ((xflag || tflag || (rflag && !cflag)) && fflg && !bflg &&
						(strcmp(usefile, "-") != 0)) {
		if (stat(usefile, &stbuf) == -1) {
			fprintf(stderr, "tar: stat() of %s failed, %s\n", usefile, sys_errlist[errno]);
			done(1);
		}
		if ((stbuf.st_mode&S_IFMT) == S_IFCHR)
			chrflg++;
	}

	if (rflag) {
		if (signal(SIGINT, SIG_IGN) != SIG_IGN)
			(void) signal(SIGINT, onintr);
		if (signal(SIGHUP, SIG_IGN) != SIG_IGN)
			(void) signal(SIGHUP, onhup);
		if (signal(SIGQUIT, SIG_IGN) != SIG_IGN)
			(void) signal(SIGQUIT, onquit);

		if (strcmp(usefile, "-") == 0) {
			if (cflag == 0) {
				fprintf(stderr, "tar: Standard output archives available only for the c key\n");
				done(1);
			}
			mt = dup(1);
			nblock = 1;
		}
		else
		if ((mt = open(usefile,O_RDWR | O_NDELAY)) == -1) {
			strcpy(er_strng, sys_errlist[errno]);
			if (fflg) {
				if (cflag) {	/* rflag && fflg && cflag */
					if ((mt = creat(usefile, 0666)) == -1) {
						fprintf(stderr,
							"tar: cannot create %s\ntar: %s\n",
							usefile, sys_errlist[errno]);
						done(1);
					}
				}
				else {		/* rflag && fflg && !cflag */
					fprintf(stderr, "tar: cannot open %s\ntar: %s\n",
						usefile, sys_errlist[errno]);
					done(1);
				}
			}
			else {			/* rflag && !fflg */
				fprintf(stderr, "tar: cannot open %s, %s\n",
					usefile, er_strng);
				done(1);
			}
		}

		if((c = ioctl(mt,PERGET,&type)) != -1){
			if(type == TAPE){
				qflag++;
				type = 0;
			}
		}

		if (cflag == 0 && nblock == 0)
			nblock = 1;
		dorep(argv);
	}
	else if (xflag)  {
		if (strcmp(usefile, "-") == 0) {
			mt = dup(0);
			nblock = 1;
		}
		else
		if ((mt = open(usefile,O_RDONLY | O_NDELAY)) < 0 ) {
			fprintf(stderr, "tar: cannot open %s\n", usefile);
			done(1);
		}
		if((c = ioctl(mt,PERGET,&type)) != -1){
			if(type == TAPE){
				qflag++;
				type = 0;
			}
		}
		doxtract(argv);
	}
	else if (tflag) {
		if (strcmp(usefile, "-") == 0) {
			mt = dup(0);
			nblock = 1;
		}
		else
		if ((mt = open(usefile,O_RDONLY | O_NDELAY)) < 0 ) {
			fprintf(stderr, "tar: cannot open %s\n", usefile);
			done(1);
		}
		if((c = ioctl(mt,PERGET,&type)) != -1){
			if(type == TAPE){
				qflag++;
				type = 0;
			}
		}
		dotable();
	}
	else
		usage();
	done(0);
		/*NOTREACHED*/
}

usage()
{
	fprintf(stderr, 
#ifdef	SYMLINK
"tar: usage  tar [-]{txruc}[Lvwfblm] [tapefile] [blocksize] file1 file2...\n");
#else
"tar: usage  tar [-]{txruc}[vwfblm] [tapefile] [blocksize] file1 file2...\n");
#endif
	done(1);
}

dorep(argv)
char	*argv[];
{
	register char *cp, *cp2;
	char wdir[NAMSIZ];

	if (!cflag) {
		getdir();
		do {
			passtape();
			if (term)
				done(0);
			getdir();
		} while (!endtape());
		if (tfile != NULL) {
			char buf[200];

			strcat(buf, "sort +0 -1 +1nr ");
			strcat(buf, tname);
			strcat(buf, " -o ");
			strcat(buf, tname);
			(void) sprintf(buf, "sort +0 -1 +1nr %s -o %s; awk '$1 != prev {print; prev=$1}' %s >%sX;mv %sX %s",
				tname, tname, tname, tname, tname, tname);
			fflush(tfile);
			system(buf);
			freopen(tname, "r", tfile);
			fstat(fileno(tfile), &stbuf);
			high = stbuf.st_size;
		}
	}
	if(qflag){ 
		if((addr = malloc(RQSIZE)) == NULL){
			fprintf(stderr,"Cannot get enough memory\n");
			exit(1);
		}
	}

	getcwd(wdir, NAMSIZ);
	while (*argv && ! term) {
		cp2 = *argv;
		for (cp = *argv; *cp; cp++)
			if (*cp == '/')
				cp2 = cp;
		if (cp2 != *argv) {
			*cp2 = '\0';
			chdir(*argv);
			*cp2 = '/';
			cp2++;
		}

		putfile(*argv++, cp2);
		chdir(wdir);
	}
	putempty();
	putempty();
	flushtape();
	if (linkerrok == 1)
		for (; ihead != NULL; ihead = ihead->nextp)
			if (ihead->count != 0)
				fprintf(stderr,
					"Missing links to %s\n",
					 ihead->pathname);
}

endtape()
{
	if (dblock.dbuf.name[0] == '\0') {
		backtape();
		return(1);
	}
	else
		return(0);
}

getdir()
{
	register struct stat *sp;
	int i, major_node, minor_node;

	readtape( (char *) &dblock);
	if (dblock.dbuf.name[0] == '\0')
		return;
	sp = &stbuf;
	sscanf(dblock.dbuf.mode, "%o", &i);
	sp->st_mode = i;
	sscanf(dblock.dbuf.uid, "%o", &i);
	sp->st_uid = i;
	sscanf(dblock.dbuf.gid, "%o", &i);
	sp->st_gid = i;
	sscanf(dblock.dbuf.size, "%lo", &sp->st_size);
	sscanf(dblock.dbuf.mtime, "%lo", &sp->st_mtime);
	/* This will turn devmajor & devminor into something that
	   mknod () can use as a device */
	if ( (dblock.dbuf.typeflag == CHRTYPE) || 
	     (dblock.dbuf.typeflag == BLKTYPE) ){

		sscanf (dblock.dbuf.devmajor, "%o", &major_node);
		sscanf (dblock.dbuf.devminor, "%o", &minor_node);
		sp->st_rdev = (major_node << 8) + minor_node;
	}
	sscanf(dblock.dbuf.chksum, "%o", &chksum);
	if (chksum != checksum()) {
		fprintf(stderr, "directory checksum error\n");
		done(2);
	}
	if (tfile != NULL)
		fprintf(tfile, "%s %s\n", dblock.dbuf.name, dblock.dbuf.mtime);
}

passtape()
{
	long blocks;
	char buf[TBLOCK];

	if (dblock.dbuf.typeflag == LNKTYPE)
		return;
	blocks = stbuf.st_size;
	blocks += TBLOCK-1;
	blocks /= TBLOCK;

	while (blocks-- > 0)
		readtape(buf);
}

putfile(longname, shortname)
char *longname;
char *shortname;
{
	int infile;
	long blocks;
	char buf[TBLOCK];
	register char *cp, *cp2;
	struct dirent  *dbuf;
	int i, j, name_len;
#ifdef	SYMLINK
	char	linktarget[NAMSIZ];

	if (follow_flag) {
		if (stat(shortname, &stbuf) < 0) {
			fprintf(stderr, "tar: cannot stat %s\n",longname);
			return;
		}
	}
	else if (lstat(shortname, &stbuf) < 0) {
		fprintf(stderr, "tar: cannot lstat %s\n",longname);
		return;
	}
#else
		stat(shortname, &stbuf);
#endif

	if ( ((stbuf.st_mode & S_IFMT) == S_IFDIR) || ((stbuf.st_mode & S_IFMT) 
	    == S_IFREG ) ){

		infile = open(shortname,O_RDONLY | O_NDELAY);

		if (infile < 0) {
			fprintf(stderr, "tar: %s: cannot open file\n", longname);
			return;
		}
	}


	if (tfile != NULL && checkupdate(longname) == 0) {
		close(infile);
		return;
	}
	if (checkw('r', longname) == 0) {
		close(infile);
		return;
	}


	tomodes(&stbuf);


	/*POSIX says we need to put a `/` after a directory name, SO we need
	  to make sure there is room for the extra character.   mbm */

	name_len = strlen(longname);
	if ((stbuf.st_mode & S_IFMT) == S_IFDIR) 
		name_len++;   /* count the extra slash */

	if ( name_len  >= NAMSIZ ) {
	     	fprintf(stderr, "%s: file name too long\n", longname);
		close(infile);
		return;
	}

	cp2 = longname;
	for (cp = dblock.dbuf.name; (*cp++ = *cp2++) ;);
	
	/*Now put the slash after the dir name.*/
	if ((stbuf.st_mode & S_IFMT) == S_IFDIR) {
		close(infile);
		*--cp = '/';
		*++cp = '\0'; 
	}

#ifdef	SYMLINK
	/* Basically, put only a header out for the case of a symbolic link.
	 * This is done by doing a readlink on the symbolic link file and
	 * using the 'dblock.dbuf.linkname' field to store the target-path
	 * of the symbolic link.
         */
	if ((stbuf.st_mode & S_IFMT) == S_IFLNK) {
		if (readlink(shortname, linktarget, NAMSIZ - 1) < 0) {
			fprintf(stderr, "can't read symbolic link %s\n",
				longname);
			return;
		}
		sprintf(dblock.dbuf.linkname, "%s", linktarget);
		if (vflag)
			fprintf(stderr, "a %s symbolic link to %s\n",
			    longname, linktarget);

		/* In the tar archive, the symlink has no size */
		(void) sprintf(dblock.dbuf.size, "%011lo", 0);

		dblock.dbuf.typeflag = SYMTYPE;

		(void) sprintf(dblock.dbuf.chksum, "%07o", checksum());
		(void) writetape((char *)&dblock);
		return;
	}
#endif

	if (stbuf.st_nlink > 1) {
		struct linkbuf *lp;
		int found = 0;

		for (lp = ihead; lp != NULL; lp = lp->nextp) {
			if (lp->inum == stbuf.st_ino && lp->devnum == stbuf.st_dev) {
				found++;
				break;
			}
		}
		if (found) {
			strcpy(dblock.dbuf.linkname, lp->pathname);
			dblock.dbuf.typeflag = LNKTYPE;
			(void) sprintf(dblock.dbuf.size, "%011lo", 0); /*POSIXism */
			(void) sprintf(dblock.dbuf.chksum, "%07o", checksum());
			writetape( (char *) &dblock);
			if (vflag) {
				fprintf(stderr, "a %s ", longname);
				fprintf(stderr, "link to %s\n", lp->pathname);
			}
			lp->count--;
			close(infile);
			return;
		}
		else {
			lp = (struct linkbuf *) malloc(sizeof(*lp));
			if (lp == NULL) {
				if (freemem) {
					fprintf(stderr, "Out of memory. Link information lost\n");
					freemem = 0;
				}
			}
			else {
				lp->nextp = ihead;
				ihead = lp;
				lp->inum = stbuf.st_ino;
				lp->devnum = stbuf.st_dev;
				lp->count = stbuf.st_nlink - 1;
				strcpy(lp->pathname, longname);
			}
		}
	}


	if ( (dblock.dbuf.typeflag != REGTYPE) && (dblock.dbuf.typeflag != AREGTYPE) ){

		if (dblock.dbuf.typeflag == DIRTYPE)     
			(void) sprintf(dblock.dbuf.size, "%011lo", 0);
		(void) sprintf(dblock.dbuf.chksum, "%07o", checksum());
		writetape( (char *) &dblock);
		if (vflag)
			if (dblock.dbuf.typeflag == DIRTYPE)  {
				fprintf(stderr, "a %s - directory\n", longname);
			}else {
				fprintf(stderr, "a %s - special file\n", longname);
			}


		if ( save_sec ){
			/* Saves MACS, privs, ACLs */
			save_security ( longname );	
		}

		if (dblock.dbuf.typeflag == DIRTYPE) {    
				       /*process files in the directory */
			sub_dirs(longname,shortname);
		}
		return;
	}

	/*The following is a useless kludge to pass the NIST-PCTS 
	  cleanly.   If you can't beat um, join um */
	if (dblock.dbuf.typeflag == AREGTYPE)
		dblock.dbuf.typeflag = REGTYPE;


	blocks = (stbuf.st_size + (TBLOCK-1)) / TBLOCK;
	if (vflag) {
		fprintf(stderr, "a %s ", longname);
		fprintf(stderr, "%ld blocks\n", blocks);
	}
	(void) sprintf(dblock.dbuf.chksum, "%07o", checksum());
	writetape( (char *) &dblock);

	while ((i = read(infile, buf, TBLOCK)) > 0 && blocks > 0) {
		writetape(buf);
		blocks--;
	}
	close(infile);

	if (blocks != 0 || i != 0)
		fprintf(stderr, "%s: file changed size\n", longname);

	while (blocks-- >  0)
		putempty();

	if ( save_sec ){

		/* Saves MACS, privs, ACLs */
		save_security ( longname );	
	}

}

void
sub_dirs(longname, shortname)
char *longname;
char *shortname;
{

	struct	dirent *dbuf;
	char	buf[TBLOCK];
	register char	*tmp_ptr, *tmp_ptr2;
	int	index, jindex;
	DIR	*indir;
	long	diroffset;

		for (index = 0, tmp_ptr = buf; *tmp_ptr++ = longname[index++];);
		*--tmp_ptr = '/';
		tmp_ptr++;
		indir = opendir(shortname);
		if (indir == NULL) {
			fprintf(stderr, "tar: %s: cannot open directory\n", longname);
			return;
		}

		index = 0;
		chdir(shortname);
		while ((dbuf = readdir(indir)) != NULL && !term) {
			if (dbuf->d_ino == 0) {
				index++;
				continue;
			}
			if (strcmp(".", dbuf->d_name) == 0 || strcmp("..", dbuf->d_name) == 0) {
				index++;
				continue;
			}
			tmp_ptr2 = tmp_ptr;
			for (jindex=0; dbuf->d_name[jindex]; jindex++)
				*tmp_ptr2++ = dbuf->d_name[jindex];
			*tmp_ptr2 = '\0';
			diroffset = telldir(indir);
			closedir(indir);
			putfile(buf, tmp_ptr);
			indir = opendir(".");
			if (indir == NULL)
				fprintf(stderr, "tar: %s/.: cannot open directory\n", longname);
			index++;
			seekdir(indir, diroffset);
		}
		closedir(indir);
		chdir("..");

		return;
}


doxtract(argv)
char	*argv[];
{
	time_t timep[2];
	long blocks, bytes;
	char buf[TBLOCK];
	char **cp;
	int ofile;
	short devtype;			/* Used by mknod (), mr */

	for (;;) {
		getdir();
		if (endtape())
			break;

		if (*argv == 0)
			goto gotit;

		for (cp = argv; *cp; cp++)
			if (prefix(*cp, dblock.dbuf.name))
				goto gotit;
		passtape();
		continue;

gotit:
		if (checkw('x', dblock.dbuf.name) == 0) {
			passtape();
			continue;
		}

		checkdir(dblock.dbuf.name);

		if (dblock.dbuf.typeflag == LNKTYPE) {
			unlink(dblock.dbuf.name);
			if (link(dblock.dbuf.linkname, dblock.dbuf.name) < 0) {
				fprintf(stderr, "%s: cannot link\n", dblock.dbuf.name);
				continue;
			}
			if (vflag)
				fprintf(stderr, "%s linked to %s\n", dblock.dbuf.name, dblock.dbuf.linkname);
			continue;
		}

		if (dblock.dbuf.typeflag == CHRTYPE || dblock.dbuf.typeflag == 
		    BLKTYPE){

			devtype = dblock.dbuf.typeflag == CHRTYPE ?
				  S_IFCHR : S_IFBLK;
			if ( mknod (dblock.dbuf.name, stbuf.st_mode | devtype,
			     stbuf.st_rdev) == -1 )

				fprintf (stderr, "tar: %s - cannot create\n",
					 dblock.dbuf.name);

			else {

				fprintf (stderr, "x %s - special file\n", dblock.dbuf.name);
				set_uid_gid ();
			}
			
			continue;
		}

		else if (dblock.dbuf.typeflag == FIFOTYPE){

			if ( mknod (dblock.dbuf.name, stbuf.st_mode | S_IFIFO, 0) == -1)

				fprintf (stderr, "tar: %s - cannot create\n",
					 dblock.dbuf.name);

			else {

				fprintf (stderr, "x %s - named pipe\n", dblock.dbuf.name);
				set_uid_gid ();
			}

			continue;
		}

		else if (dblock.dbuf.typeflag == DIRTYPE){

			if (dblock.dbuf.name[strlen(dblock.dbuf.name) -1] == '/')
				dblock.dbuf.name[strlen(dblock.dbuf.name) -1] = '\0' ;

			if(access(dblock.dbuf.name,0) == -1) {
				if(mkdir(dblock.dbuf.name,stbuf.st_mode) == -1)
					fprintf(stderr,"tar: %s - cannot create\n", dblock.dbuf.name);
				else {
					fprintf(stderr,"x %s - directory\n", dblock.dbuf.name);
					set_uid_gid();
				}
			}else
				fprintf (stderr, "x %s - directory\n", dblock.dbuf.name);
			continue;
		}

#ifdef	SYMLINK
		/* If type is a symbolic link, do a symlink to create the
		 * symbolic link (symlink(target, linkfile)).
		 */
		else if (dblock.dbuf.typeflag == SYMTYPE) {
			if (symlink(dblock.dbuf.linkname, dblock.dbuf.name)<0) {
				fprintf(stderr, "%s: symbolic link failed\n",
					dblock.dbuf.name);
				continue;
			}
			if (vflag)
				fprintf(stderr, "x %s symbolic link to %s\n",
					dblock.dbuf.name, dblock.dbuf.linkname);

			continue;
		}
#endif
		else if (dblock.dbuf.typeflag == ACLTYPE){

			restore_acl ();
			continue;
		}

		if ((ofile = creat(dblock.dbuf.name, stbuf.st_mode & 07777)) < 0) {
			fprintf(stderr, "tar: %s - cannot create\n", dblock.dbuf.name);
			passtape();
			continue;
		}

		/* POSIX 1003.1 requires that the uid & gid be over-ridden
		   if uname & gname are present */

		set_uid_gid ();

		blocks = ((bytes = stbuf.st_size) + TBLOCK-1)/TBLOCK;
		if (vflag)
			fprintf(stderr, "x %s, %ld bytes, %ld tape blocks\n", dblock.dbuf.name, bytes, blocks);
		while (blocks-- > 0) {
			readtape(buf);
			if (bytes > TBLOCK) {
				if (write(ofile, buf, TBLOCK) < 0) {
					fprintf(stderr, "tar: %s: HELP - extract write error\n", dblock.dbuf.name);
					done(2);
				}
			} else
				if (write(ofile, buf, (int) bytes) < 0) {
					fprintf(stderr, "tar: %s: HELP - extract write error\n", dblock.dbuf.name);
					done(2);
				}
			bytes -= TBLOCK;
		}
		close(ofile);

		if (mflag == 0) {
			time_t timep[2];

		timep[0] = time(NULL);
		timep[1] = stbuf.st_mtime;
		utime(dblock.dbuf.name, timep);
		}
	}
}

dotable()
{
	for (;;) {
		getdir();
		if (endtape())
			break;
		if (vflag)
			longt(&stbuf);
		printf("%s", dblock.dbuf.name);
		if (dblock.dbuf.typeflag == LNKTYPE)
			printf(" linked to %s", dblock.dbuf.linkname);
#ifdef	SYMLINK
		if (dblock.dbuf.typeflag == SYMTYPE)
			printf(" symbolic link to %s", dblock.dbuf.linkname);
#endif
		printf("\n");
		passtape();
	}
}

putempty()
{
	char buf[TBLOCK];
	char *cp;

	for (cp = buf; cp < &buf[TBLOCK]; )
		*cp++ = '\0';
	writetape(buf);
}

longt(st)
register struct stat *st;
{
	register char *cp;
	char *ctime();

	pmode(st);
	printf("%6u%6u", st->st_uid, st->st_gid);
	printf("%9lu", st->st_size);
	cp = ctime(&st->st_mtime);
	printf(" %-12.12s %-4.4s ", cp+4, cp+20);
}
int	m1[] = { 1, TUREAD, 'r', '-' };
int	m2[] = { 1, TUWRITE, 'w', '-' };
int	m3[] = { 2, TSUID, 's', TUEXEC, 'x', '-' };
int	m4[] = { 1, TGREAD, 'r', '-' };
int	m5[] = { 1, TGWRITE, 'w', '-' };
int	m6[] = { 2, TSGID, 's', TGEXEC, 'x', '-' };
int	m7[] = { 1, TOREAD, 'r', '-' };
int	m8[] = { 1, TOWRITE, 'w', '-' };
int	m9[] = { 2, TSVTX, 't', TOEXEC, 'x', '-' };

int	*m[] = { m1, m2, m3, m4, m5, m6, m7, m8, m9};

pmode(st)
register struct stat *st;
{
	register int **mp;

	for (mp = &m[0]; mp < &m[9];)
		select(*mp++, st);
}

select(pairp, st)
int *pairp;
struct stat *st;
{
	register int n, *ap;

	ap = pairp;
	n = *ap++;
	while (--n>=0 && (st->st_mode&*ap++)==0)
		ap++;
	printf("%c", *ap);
}

checkdir(name)
register char *name;
{
	register char *cp=name;
	register struct group *group;
	register struct passwd *passwd;
	int i, pid;

	for (cp++; *cp; cp++) {	/* start at *name++ */
		if (*cp == '/') {
			*cp = '\0';
			if (access(name, 01) < 0) {
				pid = fork();			/* pid == 0 implies   */
				if (pid == 0) {			/*	child process */
					execl("/bin/mkdir", "mkdir", name, 0);
					execl("/usr/bin/mkdir", "mkdir", name, 0);
					exit(1);
					fprintf(stderr, "tar: cannot find mkdir!\n");
					done(0);
				}
								/* pid != 0 implies   */
				if (pid == -1) {		/* 	parent process*/
					fprintf(stderr,
					"tar: fork from checkdir(%s) failed\ntar: %s\n",
					name, sys_errlist[errno]);
					exit(1);
				}
				while (wait(&i) != pid);

		/* POSIX 1003.1 requires that the uid & gid be over-ridden
		   if uname & gname are present */
				passwd = getpwnam (dblock.dbuf.uname);
				group = getgrnam (dblock.dbuf.gname);

				if (!oflag) {
					stbuf.st_uid = (passwd == NULL ? stbuf.st_uid 
						        : passwd->pw_uid);
					stbuf.st_gid = (group == NULL ? stbuf.st_gid 
						        : group->gr_gid);
					chown(name, stbuf.st_uid, stbuf.st_gid);
				}
			}
			*cp = '/';
		}
	}
}

void
onintr()
{
	(void) signal(SIGINT, SIG_IGN);
	term++;
}

void
onquit()
{
	(void) signal(SIGQUIT, SIG_IGN);
	term++;
}

void
onhup()
{
	(void) signal(SIGHUP, SIG_IGN);
	term++;
}

tomodes(sp)
register struct stat *sp;
{
	register char *cp;
	register struct group *group;
	register struct passwd *passwd;

	for (cp = dblock.dummy; cp < &dblock.dummy[TBLOCK]; cp++)
		*cp = '\0';

	if ((stbuf.st_mode & S_IFMT) == S_IFLNK)
		sp->st_size = 0;

	group = getgrgid (sp->st_gid);	/* Fetch group name of file owner */
	passwd = getpwuid (sp->st_uid);	/* Fetch user name of file owner */

	(void) sprintf(dblock.dbuf.mode, "%07o", sp->st_mode & 07777);
	(void) sprintf(dblock.dbuf.uid, "%07o", sp->st_uid);
	(void) sprintf(dblock.dbuf.gid, "%07o", sp->st_gid);
	(void) sprintf(dblock.dbuf.size, "%011lo", sp->st_size);
	(void) sprintf(dblock.dbuf.mtime, "%011lo", sp->st_mtime);

	/* POSIX extensions to tar */
	(void) strncpy (dblock.dbuf.magic, TMAGIC, TMAGLEN);
	(void) strncpy (dblock.dbuf.version, TVERSION, TVERSLEN);
	(void) strncpy (dblock.dbuf.uname, passwd == NULL  ? "" : passwd->pw_name, 31);
	(void) strncpy (dblock.dbuf.gname, group == NULL ? "" : group->gr_name, 31);

	/* This used to exit, now it continues, POSIX 1003.1, mr */
	if ( !(stbuf.st_mode & S_IFREG) ) {

		if ( (stbuf.st_mode & S_IFMT) == S_IFCHR){

			dblock.dbuf.typeflag = CHRTYPE;
			(void) sprintf (dblock.dbuf.devmajor, "%07o", 
			  (stbuf.st_rdev >> 8) & 0xff);
			(void) sprintf (dblock.dbuf.devminor, "%07o", 
			  stbuf.st_rdev & 0xff);
		}
	
		else if ( (stbuf.st_mode & S_IFMT) == S_IFBLK){

			dblock.dbuf.typeflag = BLKTYPE;
			(void) sprintf (dblock.dbuf.devmajor, "%07o", 
			  (stbuf.st_rdev >> 8) & 0xff);
			(void) sprintf (dblock.dbuf.devminor, "%07o", 
			  stbuf.st_rdev & 0xff);
		}

		else if ( (stbuf.st_mode & S_IFMT) == S_IFIFO)

			dblock.dbuf.typeflag = FIFOTYPE;

		else if ( (stbuf.st_mode & S_IFMT) == S_IFDIR)

			dblock.dbuf.typeflag = DIRTYPE;

	}

}

checksum()
{
	register i;
	register char *cp;

	for (cp = dblock.dbuf.chksum; cp < &dblock.dbuf.chksum[sizeof(dblock.dbuf.chksum)]; cp++)
		*cp = ' ';
	i = 0;
	for (cp = dblock.dummy; cp < &dblock.dummy[TBLOCK]; cp++)
		i += *cp;
	return(i);
}

checkw(c, name)
char *name;
{
	if (wflag) {
		printf("%c ", c);
		if (vflag)
			longt(&stbuf);
		printf("%s: ", name);
		if (response() == 'y'){
			return(1);
		}
		return(0);
	}
	return(1);
}

response()
{
	int c;

	c = getchar();
	if (c != '\n')
		while (getchar() != '\n');
	else c = 'n';
	return(c);
}

checkupdate(arg)
char	*arg;
{
	char name[100];
	long	mtime;
	daddr_t seekp;
	daddr_t	lookup();

	rewind(tfile);
	for (;;) {
		if ((seekp = lookup(arg)) < 0)
			return(1);
		fseek(tfile, seekp, 0);
		fscanf(tfile, "%s %lo", name, &mtime);
		if (stbuf.st_mtime > mtime)
			return(1);
		else
			return(0);
	}
}

done(n)
{
	unlink(tname);
	exit(n);
}

prefix(s1, s2)
register char *s1, *s2;
{
	while (*s1)
		if (*s1++ != *s2++)
			return(0);
	if (*s2)
		return(*s2 == '/');
	return(1);
}

#define	N	200
int	njab;
daddr_t
lookup(s)
char *s;
{
	register i;
	daddr_t a;

	for(i=0; s[i]; i++)
		if(s[i] == ' ')
			break;
	a = bsrch(s, i, low, high);
	return(a);
}

daddr_t
bsrch(s, n, l, h)
daddr_t l, h;
char *s;
{
	register i, j;
	char b[N];
	daddr_t offset, offset1;

	njab = 0;

loop:
	if(l >= h)
		return((daddr_t)-1);
	offset = l + (h-l)/2 - N/2;
	if(offset < l)
		offset = l;
	fseek(tfile, offset, 0);
	fread(b, 1, N, tfile);
	njab++;
	for(i=0; i<N; i++) {
		if(b[i] == '\n')
			break;
		offset++;
	}
	if(offset >= h)
		return((daddr_t)-1);
	offset1 = offset;
	j = i;
	for(i++; i<N; i++) {
		offset1++;
		if(b[i] == '\n')
			break;
	}
	i = cmp(b+j, s, n);
	if(i < 0) {
		h = offset;
		goto loop;
	}
	if(i > 0) {
		l = offset1;
		goto loop;
	}
	return(offset);
}

cmp(b, s, n)
char *b, *s;
{
	register i;

	if(b[0] != '\n')
		exit(2);
	for(i=0; i<n; i++) {
		if(b[i+1] > s[i])
			return(-1);
		if(b[i+1] < s[i])
			return(1);
	}
	return(b[i+1] == ' '? 0 : -1);
}

readtape(buffer)
char *buffer;
{
	int i, j;
	int retval;

	if(qflag) {
		retval = qreadtape(buffer);
		return(retval);
	}

	if (recno >= nblock || first == 0) {
		if (first == 0 && nblock == 0)
			j = NBLOCK;
		else
			j = nblock;
		if ((i = read(mt, tbuf, TBLOCK*j)) < 0) {
			fprintf(stderr, "Tar: tape read error, %s\n", sys_errlist[errno]);
			if (chrflg)
				fprintf(stderr, "Tar: warning, blocksize not specified, defaulted to %d\n", nblock);
			done(3);
		}
		if (first == 0) {
			if ((i % TBLOCK) != 0) {
				fprintf(stderr, "Tar: tape blocksize error\n");
				done(3);
			}
			i /= TBLOCK;
			if (rflag && i != 1) {
				fprintf(stderr, "Tar: Cannot update blocked tapes \n");
				done(4);
			}
/*sw0*/
			if (i != nblock) {
				fprintf(stderr, "Tar: blocksize = %d\n", i);
				nblock = i;
			}
		}
		recno = 0;
	}
	first = 1;
	copy(buffer, &tbuf[recno++]);
	return(TBLOCK);
}

writetape(buffer)
char *buffer;
{
	int retval, local_block;
	if(qflag) {
		retval = qwritetape(buffer);
		return(retval);
	}

	first = 1;
	local_block = (nblock == 0) ? 1 : nblock ;
	if (recno >= local_block) {
		if (write(mt, tbuf, TBLOCK*local_block) < 0) {
			fprintf(stderr, "Tar: tape write error\n");
			done(2);
		}
		recno = 0;
	}
	copy(&tbuf[recno++], buffer);
	if (recno >= local_block) {
		if (write(mt, tbuf, TBLOCK*local_block) < 0) {
			fprintf(stderr, "Tar: tape write error\n");
			done(2);
		}
		recno = 0;
	}
	return(TBLOCK);
}

backtape()
{
	lseek(mt, (long) -TBLOCK, 1);
	if (recno >= nblock) {
		recno = nblock - 1;
		if (read(mt, tbuf, TBLOCK*nblock) < 0) {
			fprintf(stderr, "Tar: tape read error after seek, %s\n", sys_errlist[errno]);
			done(4);
		}
		lseek(mt, (long) -TBLOCK, 1);
	}
}

flushtape()
{
	if(qflag)
		write(mt,addr,TBLOCK*(recno - 1));
	else
		write(mt, tbuf, TBLOCK*nblock);
}

copy(to, from)
register char *to, *from;
{
	register i;

	i = TBLOCK;
	do {
		*to++ = *from++;
	} while (--i);
}

qreadtape(buffer)
char *buffer;
{
	int i, j;
	int nadd;

	if(first == 0){
		addr = malloc(RQSIZE);
		if ((i = read(mt, addr, RQSIZE)) < 0) {
			fprintf(stderr, "Tar: tape read error\n");
			done(3);
		}
		if ((i % TBLOCK) != 0) {
			fprintf(stderr, "Tar: tape blocksize error\n");
			done(3);
		}
		i /= TBLOCK;
		if (rflag && i != 1) {
			fprintf(stderr, "Tar: Cannot update blocked tapes (yet)\n");
			done(4);
		}
		if (i != nblock && i != 1) {
			fprintf(stderr, "Tar: blocksize = %d\n", i);
			nblock = i;
		}
		recno = 0;
	}
	else if((recno*TBLOCK) >= RQSIZE){
		if ((i = read(mt, addr, RQSIZE)) < 0) {
			fprintf(stderr, "Tar: tape read error\n");
			done(3);
		}
		recno = 0;
	}
	first = 1;
	copy(buffer, addr + (recno++ * TBLOCK));
	return(TBLOCK);
}

qwritetape(buffer)
char *buffer;
{

	first = 1;
	if ((recno * TBLOCK) >= RQSIZE){
			if (write(mt, addr, TBLOCK*recno) < 0) {
				fprintf(stderr, "Tar: tape write error\n");
				done(2);
			}
			recno = 0;
			
	}
	copy(addr + (recno++ * TBLOCK), buffer);
	return(TBLOCK);
}


/* This routine forces tar to use the new uname & gname fields, if present,
   over the uid & gid fund in the header, mr */
void
set_uid_gid ()
{
	register struct group *group;
	register struct passwd *passwd;

	passwd = getpwnam (dblock.dbuf.uname);
	group = getgrnam (dblock.dbuf.gname);

	if (!oflag){

		stbuf.st_uid = (passwd == NULL ? stbuf.st_uid : passwd->pw_uid);
		stbuf.st_gid = (group == NULL ? stbuf.st_gid : group->gr_gid);
		chown(dblock.dbuf.name, stbuf.st_uid, stbuf.st_gid);
	}

	return;
}


int
save_security (full_path)
char	*full_path;
{
	struct	secure_tar st;
	struct	stat	acl_statd, acl_stat;
	char	acl_buf [2 * 10 * 1024];
	long	blocks, data_length;
	int	counter;

	/* Must explicitly zero out secure_tar array */
	memset ( (char *)&st, 0, sizeof (struct secure_tar));

	if ( acl (full_path, ACLSTAT_DEFAULT, &acl_statd) != -1){

		if ( acl (full_path, GETACL_DEFAULT, acl_buf, acl_statd.st_size) == -1)

			st.dflt_acl_length = 0;

		else {

			st.dflt_acl = (char *)sizeof (struct secure_tar);
			st.dflt_acl_length = acl_statd.st_size;
		}
	}

	if ( acl (full_path, ACLSTAT, &acl_stat) != -1){

		if ( acl ( full_path, GETACL, acl_buf + st.dflt_acl_length, acl_stat.st_size)
		     == -1)

			st.reg_acl_length = 0;

		else {

			st.reg_acl = (char *)(sizeof (struct secure_tar) +
				      st.dflt_acl_length);
			st.reg_acl_length = acl_stat.st_size;
		}
	}

	/* If there are either default or regular ACLs, write the ACL file to
	   tape, otherwise don't */
	if ( st.dflt_acl_length || st.reg_acl_length ){

		acl_tomodes ( data_length = sizeof (struct secure_tar) + st.dflt_acl_length + 
		    st.reg_acl_length);
		dblock.dbuf.name [0] = '+';
		strcpy (&dblock.dbuf.name[1], full_path);
		(void) sprintf(dblock.dbuf.chksum, "%07o", checksum());
		writetape ( (char *) &dblock);
	}

	else {

		return (0);
	}

	blocks = (data_length + (TBLOCK-1)) / TBLOCK;

	/* store the acl header stuff in the data block section */
	writetape ( (char *)&st);
	blocks--;
	
	for ( counter = 0; counter < st.dflt_acl_length + st.reg_acl_length; counter += 
	      TBLOCK){

		writetape ( (char *)(acl_buf + counter) );
		blocks--;
	}

	while (blocks--)

		putempty ();

	return (0);
}


acl_tomodes (data_size)
uint	data_size;
{
	register char *cp;

	for (cp = dblock.dummy; cp < &dblock.dummy[TBLOCK]; cp++)
		*cp = '\0';

	/* (void) sprintf(dblock.dbuf.mode, "%07o", 00);
	(void) sprintf(dblock.dbuf.uid, "%07o", 00);
	(void) sprintf(dblock.dbuf.gid, "%07o", 00); */
	(void) sprintf(dblock.dbuf.size, "%011lo", data_size);
	/* (void) sprintf(dblock.dbuf.mtime, "%011lo", 00); */
	/* POSIX extensions to tar */
	(void) strncpy (dblock.dbuf.magic, TMAGIC, TMAGLEN);
	(void) strncpy (dblock.dbuf.version, TVERSION, TVERSLEN);
	(void) strncpy (dblock.dbuf.uname, "", 31);
	(void) strncpy (dblock.dbuf.gname, "", 31);

	dblock.dbuf.typeflag = ACLTYPE;
}


int
restore_acl ()
{
	struct	secure_tar	st;
	char	buf[TBLOCK], acl_buf[2 * 10 * 1024];
	char	*ptr_acl_buf = acl_buf;
	long	blocks;

	blocks = (stbuf.st_size - sizeof (struct secure_tar) + TBLOCK - 1) / TBLOCK;

	readtape ( (char *)&st );

	while (blocks--){

		readtape (ptr_acl_buf);
		ptr_acl_buf += TBLOCK;
	}

	if (st.dflt_acl_length){

		acl (&dblock.dbuf.name[1], SETACL_DEFAULT, acl_buf, st.dflt_acl_length);
	}

	if (st.reg_acl_length){

		acl (&dblock.dbuf.name[1], SETACL, &acl_buf[st.dflt_acl_length], st.reg_acl_length);
	}

	return (0);
}
