/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sysarix.c: version 1.7 created on 2/22/90 at 21:04:20	*/
/*							*/
/*	Copyright (c) 1988 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sysarix.c	1.7	2/22/90 Copyright (c) 1988 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include <stdio.h>
#include <sys/sysarix.h>

#define NEL(x)	(sizeof(x) / sizeof(*x))

int	arg[8];
char	buf[1024];
long	Avenrun[5];

extern int	errno;
extern void	perror();

main(argc,argv)
register int	argc;
register char	*argv[];
{
	register int	cmd, ret;
	register char	*av;
	extern	 char 	*strrchr();

	if ((av = strrchr(argv[0],'/')) == NULL)
		av = argv[0];
	else
		av++;
	if (strcmp(av,"loadavg") == 0)
		cmd = ARIXGETLA;
	else {
		switch (argc) {
		case 8:
			arg[6] = atoi(argv[7]);
			/* fall through! */
		case 7:
			arg[5] = atoi(argv[6]);
			/* fall through! */
		case 6:
			arg[4] = atoi(argv[5]);
			/* fall through! */
		case 5:
			arg[3] = atoi(argv[4]);
			/* fall through! */
		case 4:
			arg[2] = atoi(argv[3]);
			/* fall through! */
		case 3:
			arg[1] = atoi(argv[2]);
			/* fall through! */
		case 2:
			cmd = atoi(argv[1]);
			break;
		default:
			fprintf(stderr,"\nusage: %s cmd_num [args....]\n",argv[0]);
			fprintf(stderr,"\tdo a sysarix system call (see sysarix(2))\n");
			fprintf(stderr,"\tunsupplied arguments default to 0\n");
			return (-1);
		}
	}

	switch (cmd) {
	case ARIXCCDEBUG:
		return (ccdebug(argc,argv));
	case ARIXPMARG:
	case ARIXGETHZ:
		break;		/* use integer arguments */
	case ARIXSNAME:
/* arg1 = a string that will fit (including the null)
 *	  within the nodename field of struct utsname (see uname(2)), returns
 *	  0 if nodename was changed, else -1
 */
		arg[1] = (int)argv[2];		/* should be a string */
		break;
	case ARIXSWPI:
		fprintf(stderr,"Use the /etc/swap program for ARIXSWPI.\n");
		return (1);
	case ARIXGETLA:
		arg[1] = (int)&Avenrun[0];	/* store in Avenrun array */
		break;
	case ARIXMEMSIZE:
/* Returns the value of the selected kernel memory variable:
 *	arg1 = one of the XMEM_ defines
 *	arg2 = (XMEM_ALL only) pointer to XMEM_NUM longs
 */
		arg[2] = (int)&arg[2];	/* store in arg array for XMEM_ALL */
		break;
	default:
		fprintf(stderr,"%s: sorry, %d is not a vaild command\n"
		        ,argv[0],cmd);
		return(-1);
	}

	ret = sysarix(cmd, arg[1], arg[2], arg[3], arg[4], arg[5], arg[6]);
	if (ret < 0) {
		perror("sysarix");
		return (errno);
	}
	
	switch (cmd) {
	case ARIXPMARG:
	case ARIXGETHZ:
	case ARIXCCDEBUG:
	case ARIXSNAME:
	default:
		printf("Return value: %d (0x%x)\n", ret, ret);
		break;		/* use integer arguments */
	case ARIXGETLA:
/* Returns the load average table.
 *	arg1 = pointer to the load average table (20 bytes long)
 */
		prt_loadavg();
		break;
	case ARIXMEMSIZE:
/* Returns the value of the selected kernel memory variable:
 *	arg1 = one of the following XMEM_ defines
 *	arg2 = (XMEM_ALL only) pointer to XMEM_NUM longs
 */
		if (arg[1] == XMEM_ALL) {
			printf(" AVAILRMEM\tAVAILSMEM\tFREEMEM\t\t");
			printf("MAXMEM\t\tPHYSMEM\n");
			for (cmd = 2; cmd < 2 + XMEM_NUM; cmd++)
				printf("%6d(0x%05x) ", arg[cmd],arg[cmd]);
			printf("\n");
		}
		else
			printf("Return value: %d (0x%x)\n", ret, ret);
		break;
	}
	return (0);
}

ccdebug(argc,argv)
register int	argc;
register char	*argv[];
{
register char	oldcc, newcc, tcc;

	argc--;
	argv++;
	if (argc > 1) {
		newcc = *argv[1];
		if (newcc == '-')
			newcc = -1;
		else
			if (newcc == '^') {
				tcc = *(argv[1]+1);
				if ((tcc >= 'a') && (tcc <= 'z'))
					tcc &= ~(040);	/* toupper() */
				if ((tcc >= '@') && (tcc <= '_'))
					newcc = tcc - '@';
			}
		oldcc = sysarix(ARIXCCDEBUG,1,newcc);
		if (errno) {
			perror("sysarix: ccdebug set");
			return (1);
		}
		if (newcc == -1) {
			fprintf(stderr,
			"sysarix: old ccdebug %s%c' is now turned off\n",
				((oldcc < ' ') ? "'^" : "'"),
				((oldcc < ' ') ? (oldcc | 0x40) : oldcc));
		} else	{
			fprintf(stderr,
			"sysarix: old ccdebug %s%c' is now changed to %s%c'\n",
				((oldcc < ' ') ? "'^" : "'"),
				((oldcc < ' ') ? (oldcc | 0x40) : oldcc),
				((newcc < ' ') ? "'^" : "'"),
				((newcc < ' ') ? (newcc | 0x40) : newcc));
		}
	} else	{
		oldcc = sysarix(ARIXCCDEBUG,0);
		if (errno) {
			perror("sysarix: ccdebug get");
			return (2);
		}
		if (oldcc == -1) {
			fprintf(stderr,
				"sysarix: current ccdebug is turned off\n");
		} else	{
			fprintf(stderr,"sysarix: current ccdebug is %s%c'\n",
					((oldcc < ' ') ? "'^" : "'"),
					((oldcc < ' ') ? (oldcc | 0x40):oldcc));
		}
	}
	return (0);
}

prt_loadavg()
{
register int	i;

	/*
	**	Avenrun order: (5s,1m,5m,15m)
	*/
	if (((Avenrun[3] / 10) % 100) < 10)
		printf("load %d.0%d ",(Avenrun[3]/1000),
			((Avenrun[3] / 10) % 100));
	else
		printf("load %d.%d ",(Avenrun[3]/1000),
			((Avenrun[3] / 10) % 100));
	for (i = 0; i < 3; i++)
		if (((Avenrun[i] / 10) % 100) < 10)
			printf("%d.0%d ",(Avenrun[i] / 1000),
				((Avenrun[i] / 10) % 100));
		else
			printf("%d.%d ",(Avenrun[i] / 1000),
				((Avenrun[i] / 10) % 100));
	printf("\n");
	return (0);
}
