


     SXT(M)		    Altos UNIX System V			SXT(M)



     Name
	  sxt -	pseudo-device driver

     Description
	  sxt is a pseudo-device driver	that interposes	a discipline
	  between the standard tty line	disciplines and	a real device
	  driver.  The standard	disciplines manipulate virtual tty
	  structures (channels)	declared by the	sxt driver.  sxt acts
	  as a discipline manipulating a real tty structure declared
	  by a real device driver.  The	sxt driver is currently	only
	  used by the shl(C) command.

	  Virtual ttys are named /dev/sxt???  and are allocated	in
	  groups of up to eight.  To allocate a	group, a program
	  should exclusively open a file with a	name of	the form
	  /dev/sxt??0 (channel 0) and then execute a SXTIOCLINK	ioctl
	  call to initiate the multiplexing.

	  Only one channel, the	controlling channel, can receive input
	  from the keyboard at a time; others attempting to read will
	  be blocked.

	  There	are two	groups of ioctl(S) commands supported by sxt.
	  The first group contains the standard	ioctl commands
	  described in termio(M), with the addition of the following:

	       TIOCEXCL	Set exclusive use mode:	no further opens are
			permitted until	the file has been closed.

	       TIOCNXCL	Reset exclusive	use mode: further opens	are
			once again permitted.

	  The second group are directives to sxt itself.  Some of
	  these	may only be executed on	channel	0.

	       SXTIOCLINK    Allocate a	channel	group and multiplex
			     the virtual ttys onto the real tty.  The
			     argument is the number of channels	to
			     allocate.	This command may only be
			     executed on channel 0.  Possible errors
			     include:

			     EINVAL The	argument is out	of range.

			     ENOTTY The	command	was not	issued from a
				    real tty.

			     ENXIO  linesw is not configured with sxt.

			     EBUSY  An SXTIOCLINK command has already
				    been issued	for this real tty.




     Page 1					     (printed 3/20/91)






     SXT(M)		    Altos UNIX System V			SXT(M)



			     ENOMEM There is no	system memory
				    available for allocating the
				    virtual tty	structures.

			     EBADF  Channel 0 was not opened before
				    this call.

	       SXTIOCSWTCH   Set the controlling channel.  Possible
			     errors include:

			     EINVAL An invalid channel number was
				    given.

			     EPERM  The	command	was not	executed from
				    channel 0.

	       SXTIOCWF	    Cause a channel to wait until it is	the
			    controlling	channel.  This command will
			    return the error, EINVAL, if an invalid
			    channel number is given.

	       SXTIOCUBLK   Turn off the loblk control flag in the
			    virtual tty	of the indicated channel.  The
			    error EINVAL will be returned if an
			    invalid number or channel 0	is given.

	       SXTIOCSTAT   Get	the status (blocked on input or
			    output) of each channel and	store in the
			    sxtblock structure referenced by the
			    argument.  The error EFAULT	will be
			    returned if	the structure cannot be
			    written.

	       SXTIOCTRACE  Enable tracing.  Tracing information is
			    written to the console.  This command has
			    no effect if tracing is not	configured.

	       SXTIOCNOTRACE
			    Disable tracing.  This command has no
			    effect if tracing is not configured.

     Files
	  /dev/sxt??[0-7]	      virtual tty devices
	  /usr/include/sys/sxt.h      driver specific definitions

     See Also
	  shl(C), stty(C), ioctl(S), open(S), termio(M)








     Page 2					     (printed 3/20/91)



