


     LOCALE(M)		    Altos UNIX System V		     LOCALE(M)



     Name
	  locale - the international locale

     Syntax
	  language [ _ [ territory ] [ . [ codeset ] ] ]
	  "C"

     Description
	  The international locale is a	definition of the local
	  conventions to be used by Altos UNIX System V	libraries (and
	  hence	utilities and applications) for	features whose
	  behavior varies internationally.

	  The locale is	specified by a character string	of the form
	  language_territory.codeset, where:

	  language    represents both the language of text files being
		      used, and	the preferred language for messages
		      (where the utility or application	is capable of
		      displaying messages in many languages),

	  territory   represents the geographical location (usually
		      the country) determining such factors as
		      currency and numeric formats, and

	  codeset     represents the character set in use for the
		      internal representation of text.

	  The locale string ``french_canada.8859'' could therefore
	  represent a Canadian user using the French language,
	  processing data using	the ISO	8859/1 standard	international
	  character set.

	  Each element (language, territory or codeset)	can be up to
	  14 characters	long, and should use only alphanumeric ASCII
	  characters (see ascii(M)).

	  Note that the	locale is not required to be completely
	  specified:  territory	and codeset are	optional.  When	a
	  locale is incompletely specified, missing values are sought
	  in the following sequence:

	  1. For each subclass,	such as	LC_TIME	, in an	environment
	     variable of the same name as the subclass.

	  2. In	the LANG environment variable.

	  3. In	the file /etc/default/lang .

	  The special locale string ``C'', used	to represent the
	  minimal environment needed for the C programming language,
	  is taken to be equivalent to ``english_us.ascii''.



     Page 1					     (printed 3/20/91)






     LOCALE(M)		    Altos UNIX System V		     LOCALE(M)



	  The format of	the file /etc/default/lang is at least one
	  line,	of the form:

	       LANG="language_territory.codeset"

	  A partly specified locale string will	be expanded to the
	  first	LANG = entry in	which the specified locale fields
	  match.

	  Thus if the /etc/default/lang	file contains the following:

	       LANG=english_us.ascii
	       LANG=english_uk.8859
	       LANG=french_france.8859

	  A locale string ``english_uk'' will get expanded to
	  ``english_uk.8859'', whereas a locale	string ``french'' will
	  get expanded to ``french_france.8859''.

	  The information used to configure a particular locale	is
	  generated by the utilities chrtbl(M),	coltbl(M), mestbl(M),
	  montbl(M), numtbl(M) and timtbl(M).  The output files
	  produced by these utilities (ctype, collate, currency,
	  messages, numeric and	time respectively) must	be installed
	  in the correct place in the directory	structure
	  /usr/lib/lang.  The correct directory	name is	found by
	  substituting the language, territory and codeset names into
	  the string ``/usr/lib/lang/language/territory/codeset''.
	  The files should be installed	into this directory with their
	  existing file	name (such as ctype).

	  A suggested naming convention	for locales is as follows:

	  language
	       The name	of the language, in English, such as:
	       english,	french,	german.

	  territory
	       The name	of the nation, in English, such	as:  us, uk,
	       canada, france, germany,	switzerland.

	  codeset
	       An identification of the	codeset, such as:  ascii,
	       8859.

     See Also
	  chrtbl(M), coltbl(M),	environ(M), mestbl(M), montbl(M),
	  numtbl(M), setlocale(S), timtbl(M)

     Value Added
	  locale is an extension of AT&T System	V provided in Altos
	  UNIX System V.



     Page 2					     (printed 3/20/91)



