


     SYMS(F)		    Altos UNIX System V		       SYMS(F)



     Name
	  syms - common	object file symbol table format

     Syntax
	  #include  <syms.h>

     Description
	  Common object	files contain information to support symbolic
	  software testing [see	sdb(CP)].  Line	number entries,
	  linenum(F), and extensive symbolic information permit
	  testing at the C source level.  Every	object file's symbol
	  table	is organized as	shown below.

		    File name 1.
			 Function 1.
			      Local symbols for	function 1.
			 Function 2.
			      Local symbols for	function 2.
			 ...
			 Static	externs	for file 1.

		    File name 2.
			 Function 1.
			      Local symbols for	function 1.
			 Function 2.
			      Local symbols for	function 2.
			 ...
			 Static	externs	for file 2.
		    ...

		    Defined global symbols.
		    Undefined global symbols.

	  The entry for	a symbol is a fixed-length structure.  The
	  members of the structure hold	the name (null padded),	its
	  value, and other information.	 The C structure is given
	  below.

	  #define  SYMNMLEN  8
	  #define  FILNMLEN  14
	  #define  DIMNUM    4

	  struct  syment
	  {
	      union			    /* all ways	to get symbol name */
	      {
		  char	      _n_name[SYMNMLEN]; /* symbol name	*/
		  struct
		  {
		      long    _n_zeroes;    /* == 0L when in string table */
		      long    _n_offset;    /* location	of name	in table */
		  } _n_n;



     Page 1					     (printed 3/20/91)






     SYMS(F)		    Altos UNIX System V		       SYMS(F)



		  char	      *_n_nptr[2];  /* allows overlaying */
	      }	_n;
	      long	      n_value;	    /* value of	symbol */
	      short	      n_scnum;	    /* section number */
	      unsigned short  n_type;	    /* type and	derived	type */
	      char	      n_sclass;	    /* storage class */
	      char	      n_numaux;	    /* number of aux entries */
	  };

	  #define  n_name    _n._n_name
	  #define  n_zeroes  _n._n_n._n_zeroes
	  #define  n_offset  _n._n_n._n_offset
	  #define  n_nptr    _n._n_nptr[1]

	  Meaningful values and	explanations for them are given	in
	  both syms.h and Common Object	File Format.  Anyone who needs
	  to interpret the entries should seek more information	in
	  these	sources.  Some symbols require more information	than a
	  single entry;	they are followed by auxiliary entries that
	  are the same size as a symbol	entry.	The format follows.

	  union	auxent
	  {
		 struct
		 {
			long		x_tagndx;
			union
			{
			       struct
			       {
					unsigned short	x_lnno;
					unsigned short	x_size;
			       } x_lnsz;
			       long	x_fsize;
			} x_misc;
			union
			{
			       struct
			       {
					long   x_lnnoptr;
					long   x_endndx;
			       }	x_fcn;
			       struct
			       {
					unsigned short	x_dimen[DIMNUM];
			       }	x_ary;
			}		x_fcnary;
			unsigned short	x_tvndx;
		 }	x_sym;
		 struct
		 {
			char   x_fname[FILNMLEN];



     Page 2					     (printed 3/20/91)






     SYMS(F)		    Altos UNIX System V		       SYMS(F)



		 }	x_file;
		  struct
		  {
			  long	  x_scnlen;
			  unsigned short  x_nreloc;
			  unsigned short  x_nlinno;
		  }	  x_scn;

		 struct
		 {
			long		x_tvfill;
			unsigned short	x_tvlen;
			unsigned short	x_tvran[2];
		 }	x_tv;
	  };

	  Indexes of symbol table entries begin	at zero.

     See Also
	  sdb(CP), a.out(F), linenum(F).

     Notes
	  On machines on which ints are	equivalent to longs, all longs
	  have their type changed to int.  Thus	the information	about
	  which	symbols	are declared as	longs and which, as ints, does
	  not show up in the symbol table.





























     Page 3					     (printed 3/20/91)



