


     DIRENT(F)		    Altos UNIX System V		     DIRENT(F)



     Name
	  dirent - filesystem-independent directory entry

     Syntax
	  #include <sys/types.h>
	  #include <sys/dirent.h>

     Description
	  Different file system	types may have different directory
	  entries.  The	dirent structure defines a file-system-
	  independent directory	entry, which contains information
	  common to directory entries in different file	system types.
	  A set	of these structures is returned	by the getdents(S)
	  system call.

	  The dirent structure is defined below.

	  struct    dirent {
			 long		d_ino;
			 off_t		     d_off;
			 unsigned short	     d_reclen;
			 char		d_name[1];
		    };

	  The d_ino is a number	which is unique	for each file in the
	  file system.	The field d_off	is the offset of that
	  directory entry in the actual	file system directory.	The
	  field	d_name is the beginning	of the character array giving
	  the name of the directory entry.  This name is null
	  terminated and may have at most MAXNAMLEN characters.	 This
	  results in file system independent directory entries being
	  variable length entities.  The value of d_reclen is the
	  record length	of this	entry.	This length is defined to be
	  the number of	bytes between the current entry	and the	next
	  one, so that it will always result in	the next entry being
	  on a long boundary.

     Files
	  /usr/include/sys/dirent.h

     See Also
	  getdents(S)

     Standards Conformance
	  dirent is conformant with:
	  AT&T SVID Issue 2, Select Code 307-127;
	  and The X/Open Portability Guide II of January 1987.








     Page 1					     (printed 3/20/91)



