


     PACK(C)		    Altos UNIX System V		       PACK(C)



     Name
	  pack,	pcat, unpack - compresses and expands files

     Syntax
	  pack [ - ] name ...

	  pcat name ...

	  unpack name ...

     Description
	  pack attempts	to store the specified files in	a compressed
	  form.	 Wherever possible, each input file name is replaced
	  by a packed file name.z with the same	access modes, access
	  and modified dates, and the owner of name.  If pack is
	  successful, name will	be removed.  Packed files can be
	  restored to their original form using	unpack or pcat.

	  pack uses Huffman (minimum redundancy) codes on a byte-by-
	  byte basis.  If the -	argument is used, an internal flag is
	  set that causes pack to display information about the	file
	  compression.	Additional occurrences of - in place of	name
	  will cause the internal flag to be set and reset.

	  The amount of	compression obtained depends on	the size of
	  the input file and the character frequency distribution.
	  Because a decoding tree forms	the first part of each .z
	  file,	it is usually not worthwhile to	pack files smaller
	  than three blocks, unless the	character frequency
	  distribution is very scattered, which	may occur with printer
	  plots	or pictures.

	  Typically, text files	are reduced to 60-75% of their
	  original size.  Load modules,	which use a larger character
	  set and have a more uniform distribution of characters, show
	  little compression, the packed versions being	about 90% of
	  the original size.

	  pack returns a value that is the number of files that	it
	  failed to compress.

	  No packing will occur	if:

	  -    The file	appears	to be already packed

	  -    The filename has	more than 12 characters

	  -    The file	has links

	  -    The file	is a directory

	  -    The file	cannot be opened



     Page 1					     (printed 3/20/91)






     PACK(C)		    Altos UNIX System V		       PACK(C)



	  -    No disk storage blocks will be saved by packing

	  -    A file called name.z already exists

	  -    The .z file cannot be created

	  -    An I/O error occurred during processing

	  The last segment of the filename must	contain	no more	than
	  12 characters	to allow space for the appended	.z extension.
	  Directories cannot be	compressed.

	  Pcat does for	packed files what cat(C) does for ordinary
	  files.  The specified	files are unpacked and written to the
	  standard output.  Thus to view a packed file named name.z
	  use:

	       pcat name.z

	  or just:

	       pcat name

	  To make an unpacked copy, say	nnn, of	a packed file named
	  name.z without destroying name.z, enter the command:

	       pcat name >nnn

	  Pcat returns the number of files it was unable to unpack.
	  Failure may occur if:

	  -    The filename (exclusive of the .z) has more than	12
	       characters

	  -    The file	cannot be opened

	  -    The file	does not appear	to be the output of pack

	  unpack expands files created by pack.	 For each file name
	  specified in the command, a search is	made for a file	called
	  name.z (or just name,	if name	ends in	.z).  If this file
	  appears to be	a packed file, it is replaced by its expanded
	  version.  The	new file has the .z suffix stripped from its
	  name,	and has	the same access	modes, access and modification
	  dates, and owner as those of the packed file.

	  unpack returns a value that is the number of files it	was
	  unable to unpack.  Failure may occur for the same reasons
	  that it may in pcat, as well as in a file where the
	  ``unpacked'' name already exists, or if the unpacked file
	  cannot be created.




     Page 2					     (printed 3/20/91)






     PACK(C)		    Altos UNIX System V		       PACK(C)



     Standards Conformance
	  pack,	pcat and unpack	are conformant with:
	  AT&T SVID Issue 2, Select Code 307-127;
	  and The X/Open Portability Guide II of January 1987.



















































     Page 3					     (printed 3/20/91)



