
#
# segmulti.awk (Online Diagnostics)
#


{
	notmulti = 1;
	if ($1 !~ /[^0-9]/) {
		count = $1 + 0;
		stfld = 3;
	} else {
		count = 1;
		stfld = 2;
	}

	for (i=stfld; i <= NF; i++) {
		if ($i == "mdc:") {
			notmulti = 0;
			#count = 1;
			for (j=i+1; j <= NF; j++) {
				if ($j == "slot") {
					k=j+1;
					slot=substr($k,1,length($k)-1);
				} else if ($j == "port") {
					k=j+2;
					port = $k;
				} else if ($j ~ /\):$/) {
					k=j-1;
					count*=(substr($k,2,length($k)-1) + 0);
				}
			}
      
	
			emsg = "";
			for (jj=k+2; jj<=NF; jj++) 
			   emsg = emsg " " $jj;

			etype = "gen";
			if (emsg == " bad packet count received") {
				etype = "bpc";
			} else if (emsg == " bad packet length received") {
				etype = "bpl";
			} else if (emsg == " bad receiver packet") {
				etype = "brp";
			} else if (emsg == " bad secondary packet" ) {
				etype = "bsp";
			} else if (emsg == " carrier present too long") {
				etype = "ctl";
			} else if (emsg == " CRC error received") {
				etype = "crc";
			} else if (emsg == " framing error") {
				etype = "fram";
			} else if (emsg == " parity error") {
				etype = "prt";
			} else if (emsg == " RS232 receiver overrun") {
				etype = "232";
			} else if (emsg == " input char(s) lost") {
				etype = "chl";
			} else if (emsg == " SDLC receiver overrun") {
				etype = "sdl";
			} else if (emsg == " no response from secondary") {
				etype = "nrs";
			} else if (emsg == " packet from bad address") {
				etype = "pba";
			}
			printf("%d mdc%s mdc Slot:%s Addr:%s %s on multidrop slot %d port %d\n", count, etype, slot, port, emsg, slot, port);
			break;
		}
	}
	if (notmulti) {
		print $0
	}
}

