
#
# segmisc.awk (Online Diagnostics)
#

{
	if ($1 !~ /[^0-9]/) {
		count = $1 + 0;
		stfld = 3;
	} else {
		count = 1;
		stfld = 2;
	}

        emsg = "";
	for (j=2; j <= NF; j++) 
	      emsg = emsg " " $j;

	if (emsg ~ / NMI on EISA slot [0-9]/) {
            split(emsg, arr);
            printf("%d  misnmi slot %d\n", count, arr[5]);
        } else if (emsg ~ / Error encountered on Base I\/O Board/) {
            printf("%d  misbiob - -\n", count);
        } else if (emsg ~ / Out of swap space/) {
            printf("%d  misswap - -\n", count);
        } else if (emsg ~ / POWER FAILURE DETECTED \!\!/) {
            printf("%d  mispfd - -\n", count);
        } else if (emsg ~ / POWER FAILURE IGNORED \- POWER RETURNED/) {
            printf("%d  mispfi - -\n", count);
        } else if (emsg ~ / INITIATING SHUTDOWN PROCEDURES \(SHUTKILL\)/) {
            printf("%d  misisp - -\n", count);
        } else if (emsg ~ / POWER FAILURE SHUTDOWN \(SHUTKILL\) COMPLETED\./) {
            printf("%d  mispcmp - -\n", count);
        }

print $0 

}

