
#
# segkernel.awk (Online Diagnostics)
#

{
	notkernel = 1;
	if ($1 !~ /[^0-9]/) {
		count = $1 + 0;
		stfld = 3;
	} else {
		count = 1;
		stfld = 2;
	}

	for (i=2; i <= NF; i++) {
		if ($i == "kernel:") {
			notkernel = 0;
			emsg = "";
			for (j=i+1; j <= NF; j++) 
			   emsg = emsg " " $j;

			if (emsg ~ / \*\* ABNORMAL System Shutdown \*\*/) {
		                printf("%d  krnabs - -\n", count);
	                } else if (emsg ~ / bad block on dev [0-9]*\/[0-9]*/) {
                                split(emsg, arr);
		                printf("%d  krnbblk dev %s\n", count, arr[5]);
	                } else if ((emsg ~ / Bad free count on dev [0-9]*\/[0-9]*/) || (emsg ~ / bad count on dev [0-9]*\/[0-9]*/)) {
                                split(emsg, arr);
          			if (arr[2] == "free")
 				  cnt=6
 				else
                                  cnt=5

		                printf("%d  krnsupr dev %s\n", count, arr[cnt]);
	                } else if (emsg ~ / error on dev [A-Za-z]+ \([0-9]*\/[0-9]*\)/) {
                                split(emsg, arr);
		                printf("%d  krngde %s %s \n", count, arr[4], arr[5]);
	                } else if (emsg ==  " iaddress > 2^24") {
		                printf("%d  krnibnf - -\n", count);
	                } else if (emsg ~ / Inode table overflow/) {
		                printf("%d  krnito - -\n", count);
	                } else if (emsg ~ / interrupt from unknown device, vec=[0-9]*/) {
                                split(emsg, arr);
		                printf("%d  krnuint - %s\n", count, arr[5]);
	                } else if (emsg ~ / stray interrupt on vector [0-9]*/) {
                                split(emsg, arr);
		                printf("%d  krnsint vec= %s\n", count, arr[5]);
	                } else if (emsg ~ / no file/) {
		                printf("%d  krnopen - -\n", count);
	                } else if (emsg ~ / no space on dev [0-9]*\/[0-9]*/) {
                                split(emsg, arr);
		                printf("%d  krnnfbl dev %s\n", count, arr[5]);
	                } else if (emsg ~ / Out of inodes on dev [0-9]*\/[0-9]*/) {
                                split(emsg, arr);
		                printf("%d  krnoin dev %s\n", count, arr[6]);
	                } else if ((emsg ~ / blkdev/) || (emsg ~ / devtab/)) {
		                printf("%d  krnndsk - -\n", count);
	                } else if (emsg ~ / swap IO error/) {
		                printf("%d  krnswpe - -\n", count);
	                } else if (emsg ~ / memory failure - parity error/) {
		                printf("%d  krnprty - -\n", count);
	                } else if (emsg ~ / no fs/) {
		                printf("%d  krnnofs - -\n", count);
	                } else if (emsg ~ / Out of swap/) {
		                printf("%d  krniswp - -\n", count);
     			} else {
		                printf("%d  krngen - -\n", count);
			}
			break;
		}
	}
	if (notkernel) 
	   print $0
}

