:
#ident "@(#)installpkg.r	1.3 91/02/26"
#
#	      UNIX is a registered trademark of AT&T
#		Portions Copyright 1976-1989 AT&T
#	Portions Copyright 1980-1989 Microsoft Corporation
#    Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
#	Portions Copyright 1990-1991 Altos Computer Systems
#		      All Rights Reserved
#
# ----------------------------------------------------------------------
# PURPOSE:  Install application software either 3b2 or PLUS style.
# ----------------------------------------------------------------------
# CONTENTS FILE LAYOUT:
# KEY_NAME TYPE NAME
# KEY_NAME is the date+pid+number if needed to make unique
# TYPE is 1 of PLUS stlye and 2 for 3b2 style.
# NAME is the Name file.

trap "trap '' 1 2 3 9 15; cd /; rm -rf ${TMPDIR} ${CPLOG} & echo You have canceled the installation.; exit 1" 1 2 3 9 15

INDIR=/usr/lib/installed
CONTENTS=${INDIR}/CONTENTS
TMPDIR=/usr/tmp/install$$

FDMESS="Please insert the floppy disk.\n\nIf the program installation \
requires more than one floppy disk, be sure to insert the disks in the \
proper order, starting with disk number 1.\nAfter the first floppy disk, \
instructions will be provided for inserting the remaining floppy disks."

# Check if root is performing the operation
id | grep "(root)" > /dev/null
if [ "$?" = "0" ]
then
	id | grep "euid=" > /dev/null
	if [ "$?" = "0" ] #Did get root above; no euid string
	then
		id | grep "euid=0(root)" > /dev/null
		if [ "$?" = 0 ]
		then
			UID=0
		else
			UID=1
		fi
	else
		UID=0
	fi
else
	UID=1
fi
if [ "$UID" != 0 ]
then echo "You must be root or super-user to install software."
     exit 1
fi

if [ -z "$TERM" ]
then TERM=AT386-M
fi
CLEAR=`tput clear 2>/dev/null`

cd /
if [ ! -d /usr/options ]
then
	rm -rf /usr/options
	mkdir /usr/options
	chmod 755 /usr/options
fi
if [ ! -d /install ]
then
	rm -rf /install
	mkdir /install
	chmod 755 /install
fi

/etc/mount | grep "^/install" > /dev/null 2>&1
if [ $? = 0 ]
then
	message -d "Cannot run installpkg.  The /install directory is currently \
mounted.  Please unmount /install and then try again."
	exit 1
fi

MES1=

#
# Use CMOS information to determine number of floppy drives
# Note: this assumes the PC/AT architecture and is inherently non-portable.
#
FDCMOS=`/etc/cmos | grep "^10" | sed 's/10 //' 2>/dev/null`

case "$FDCMOS" in
20)	# 1.2MB as drive 0 only
	FDMULT=0
	;;
40)	# 1.44MB as drive 0 only
	FDMULT=0
	;;
42)	# 1.44MB as drive 0, 1.2MB as drive 1
	FDMULT=1
	;;
24)	# 1.2MB as drive 0, 1.44MB as drive 1
	FDMULT=1
	;;
*)	# unsupported configuration
	echo "Unsupported floppy drive configuration: aborted."
	exit 1
	;;
esac

if [ $FDMULT -eq 1 ]
then
	while :
	do
		echo "\nThis system has two floppy drives.\n\
Strike ENTER to install from drive 0\n\
or 1 to install from drive 1.  \c"
		read ans
		if [ "$ans" = 1 ]
		then
			DRIVE=/dev/dsk/f1
			FDRIVE=/dev/rdsk/f1
			FD=1
			break
		elif [ "$ans" = "" -o "$ans" = 0 ]
		then
			DRIVE=/dev/dsk/f0
			FDRIVE=/dev/rdsk/f0
			FD=0
			break
		fi
	done
else
	DRIVE=/dev/dsk/f0
	FDRIVE=/dev/rdsk/f0
	FD=0
fi
while [ 1 ]
do
	message -c $MES1 $FDMESS
	if [ $? != 0 ]
	then exit 1
	fi
	echo "$CLEAR"
	echo "\n\n\tInstallation is in progress -- do not remove the floppy disk."
	/etc/mount $DRIVE /install -r > /dev/null 2>&1
	if [ $? = 0 ]
	then
		/etc/umount $DRIVE > /dev/null 2>&1
		break
	fi

	dd if=$FDRIVE of=/dev/null bs=15b count=3 > /dev/null 2>&1
	if [ $? = 0 ]
	then exec /usr/lbin/Install.sh $FDRIVE $FD
	fi

	MES1="Cannot determine the 'type' of floppy.\n"
done
/etc/mount $DRIVE /install -r > /dev/null 2>&1
if [ ! -r /install/install/INSTALL ]
then
	echo "Improperly built software removable medium."
	/etc/umount /install > /dev/null 2>&1
	exit
fi
cd /tmp
trap "trap '' 1 2 3 9 15; cd /; rm -f /tmp/$$*; /etc/umount /install; exit 1" 1 2 3
cp /install/install/INSTALL $$INSTALL
chmod +x $$INSTALL
/tmp/$$INSTALL $DRIVE /install "`basename ${DRIVE}` drive" ||
	echo 'WARNING: Installation may not have completed properly.'
trap '' 1 2 3
cd /
rm -f $$INSTALL
/etc/umount /install > /dev/null 2>&1
rm -rf /tmp/$$*
if [ -f /etc/.new_unix ]
then
	sync; sync
	exec /etc/conf/bin/idreboot
fi
exit 0
