#ident	"@(#)vtkd.h	1.2	90/08/08"
#ifndef _SYS_VTKD_H
#define _SYS_VTKD_H
#ident "@(#) vtkd.h 22.1 90/01/15 "
#ident "@(#)vtkd.h	1.2 89/09/29"
#ident "@(#) vtkd.h 1.7 89/07/27 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*
 *	Copyright (C) The Santa Cruz Operation, 1984-1989.
 *	Copyright (C) Microsoft Corporation, 1984-1989.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, Microsoft Corporation
 *	and AT&T, and should be treated as Confidential.
 */

#define MONO_BASE	0xb0000	/* location of mono display memory */
#define COLOR_BASE	0xb8000	/* location of color display memory */
#define EGA_BASE	0xa0000	/* location of ega display memory */

/* keyboard types */
#define	KB_84		1	/* 84 key keyboard */
#define KB_101		2	/* 101/102 key keyboard */
#define KB_OTHER	3	/* other (unknown) keyboard */

/*
 * ioctls supported by the VT
 */
#define VTIOC		('v' << 8)
#define VT_OPENQRY	(VTIOC | 1)	/* inquires if this vt already open */
#define VT_SETMODE	(VTIOC | 2)	/* set vt into auto or process mode */
#define VT_GETMODE	(VTIOC | 3)	/* returns mode vt is currently in  */
#define VT_RELDISP	(VTIOC | 4)	/* tells vt when display released   */
#define VT_ACTIVATE	(VTIOC | 5)	/* activates specified vt 	    */

/*
 * modes of VT_RELDISP
 */
#define VT_FALSE	0	/* user will not release display	*/
#define VT_TRUE		1	/* user releases display		*/
#define VT_ACKACQ	2	/* user acknowleges the acquire signal	*/

struct vt_mode {
	char	mode;	/* mode to set vt into				*/
	char	waitv;	/* if != 0, vt hangs on writes when not active	*/
	short	relsig;	/* signal to use for release request		*/
	short	acqsig;	/* signal to use for release request		*/
	short	frsig;	/* signal to use for forced release		*/
};

#define VT_AUTO		0	/* this vts switching is automatic	    */
#define VT_PROCESS	1	/* this vts switching controlled by process */

#define	KIOC		('K' << 8)
#define	KDDISPTYPE	(KIOC | 1)	/* return display type to user	    */
#define KDMAPDISP	(KIOC | 2)	/* map display into user space      */
#define KDUNMAPDISP	(KIOC | 3)	/* unmap display from user space    */
#define KDGKBMODE	(KIOC | 6)	/* get keyboard translation mode    */
#define KDSKBMODE	(KIOC | 7)	/* set keyboard translation mode    */
#define KDMKTONE	(KIOC | 8)	/* vpix error sound generation      */
#define KDGETMODE	(KIOC | 9)	/* get text/graphics mode  	    */
#define KDSETMODE	(KIOC | 10)	/* set text/graphics mode	    */
#define KDADDIO		(KIOC | 11)	/* add I/O address to list	    */
#define KDDELIO		(KIOC | 12)	/* delete I/O address from list     */
#define KIOCDOSMODE     (KIOC | 16)     /* set DOSMODE			    */
#define KIOCNONDOSMODE  (KIOC | 17)     /* clear DOSMODE		    */
#define KDDISPINFO	(KIOC | 18)	/* get display start and size	    */
#define KDGKBSTATE	(KIOC | 19)	/* get state of keyboard shift keys */

#define KDENABIO	(KIOC | 60) 	/* enable IOPL 			    */
#define KDDISABIO	(KIOC | 61)	/* disable IOPL			    */
#define KIOCINFO	(KIOC | 62)	/* tell user what device we are     */
#define KIOCSOUND	(KIOC | 63)	/* start sound generation	    */ 
#define KDGKBTYPE	(KIOC | 64)	/* get keyboard type		    */
#define KDGETLED	(KIOC | 65)	/* get current led states	    */
#define KDSETLED	(KIOC | 66)	/* set current led states	    */

/*
 * return values for kddisptype
 */
#define KD_MONO		01	/* monochrome display adapter */
#define KD_HERCULES	02	/* Hercules monochrome graphics adapter */
#define KD_CGA		03	/* Color    graphics adapter	*/
#define KD_EGA		04	/* Enhanced graphics adapter	*/
#define KD_VGA		05	/* Video    graphics adapter	*/

/*
 * arguments to KDSETMODE/KDGETMODE
 */
#define KD_TEXT		0	/* ansi x3.64 emulation mode		    */
#define KD_TEXT0	0	/* more of the same			    */
#define KD_GRAPHICS	1	/* graphics mode			    */
#define KD_TEXT1	2	/* enter Xenix textmode from DOS textmode   */

/*
 * arguments to KDSKBMODE
 */
#define K_RAW		0x00	/* keyboard send raw up/down scan code      */
#define K_XLATE		0x01	/* keyboard translates scan codes to ascii  */

struct kdytinfo {	/* device specific info for kd vt driver */
	unsigned char		kbmode;		/* keyboard mode */
	unsigned char		dmode;		/* display mode */
	unsigned char		flags;		/* flags */
/*	struct ansistate	as;		/* ansi terminal state */
};

struct kbentry {
	unsigned char	kb_table;	/* which table to use */
	unsigned char	kb_index;	/* which entry in table */
	unsigned char	kb_value;	/* value to get/set in table */
};

#define MKDIOADDR	64	/* max no. of I/O addresses supported */

struct kd_dispinfo {
	char    *vaddr;		/* display memory address */
	paddr_t	physaddr;	/* display memory address */
	unsigned long size;	/* display memory size */
};

struct kd_disparam {
	long	type; 		/* display type */
	char	*addr;		/* display memory address */
};

struct kd_memloc {
	char	*vaddr;		/* virtual address to map to */
	char	*physaddr;	/* physical address to map to */
	long	length;		/* size in bytes to map */
	long	ioflg;		/* enable I/O addresses if non-zero */
};

#endif	/* _SYS_VTKD_H */
