#ident	"@(#)sysinfo.h	1.2	90/08/08"
#ifndef _SYS_SYSINFO_H
#define _SYS_SYSINFO_H
#ident "@(#) sysinfo.h 22.1 90/01/15 "
#ident "@(#)sysinfo.h	1.2 89/09/29"
#ident "@(#) sysinfo.h 1.6 89/07/27 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* #ident	"@)#(head.sys:sysinfo.h	1.3.1.1" */

/*
 *	System Information.
 */

struct sysinfo {
	time_t	cpu[5];
#define	CPU_IDLE	0
#define	CPU_USER	1
#define	CPU_KERNEL	2
#define	CPU_WAIT	3
#define CPU_SXBRK	4
	time_t	wait[3];
#define	W_IO	0
#define	W_SWAP	1
#define	W_PIO	2
	long	bread;
	long	bwrite;
	long	lread;
	long	lwrite;
	long	phread;
	long	phwrite;
	long	swapin;
	long	swapout;
	long	bswapin;
	long	bswapout;
	long	pswitch;
	long	syscall;
	long 	remcall;	/* REMOTE: remote call */
	long    fileop;		/* REMOTE: remote fileop */
	long    serve;		/* REMOTE: remote server */
	long	sysread;
	long	syswrite;
	long	sysfork;
	long	sysexec;
	long	runque;
	long	runocc;
	long	swpque;
	long	swpocc;
	long	iget;
	long	namei;
	long	dirblk;
	long	readch;
	long	writech;
	long	rcvint;
	long	xmtint;
	long	mdmint;
	long	rawch;
	long	canch;
	long	outch;
	long	msg;
	long	sema;
	long	pnpfault;
	long	wrtfault;
};

extern struct sysinfo sysinfo;

struct syswait {
	short	iowait;
	short	swap;
	short	physio;
};

struct dinfo {
			/* ELEMENT FOR sar -Du */
	time_t	serve;		/* ticks in serve() since boot */
			/* ELEMENTS FOR sar -Dc */
	long	isyscall;	/* # of incoming syscalls since boot */
	long	isysread;	/* # of incoming read's since boot */
	long	ireadch;	/* char's read by incoming read's */
	long	isyswrite;	/* # of incoming write's since boot */
	long	iwritech;	/* char's written by incoming writes */
	long	isysexec;	/* # of incoming exec's since boot */
	long	osyscall;	/* # of outgoing syscalls since boot */
	long	osysread;	/* # of outgoing read's since boot */
	long	oreadch;	/* char's read by outgoing read's */
	long	osyswrite;	/* # of outgoing write's since boot */
	long	owritech;	/* char's written by outgoing writes */
	long	osysexec;	/* # of outgoing exec's since boot */
			/* ELEMENTS FOR sar -S*/
	long	nservers;	/* sum of all servers since boot */
	long	srv_que;	/* sum of server Q lgth since boot */
	long	srv_occ;	/* ticks server Q found occupied */
	long	rcv_que;	/* sum of receive Q lgth since boot */
	long	rcv_occ;	/* clock ticks receive Q occupied */
};
struct rcinfo {
	long	cbread;		/* read blocks sent to remote server*/
					/* (not found in cache) */
	long	cbwrite;	/* write blocks not found in local cache*/
	long	clread;		/* total blocks in remote read */
	long	clwrite;	/* total blocks in remote write */
	long	snd_dis;	/* cache disable messages sent (server) */
	long	snd_msg;	/* total RFS messages sent */
	long	rcv_dis;	/* cache disable messages received (client) */
	long	rcv_msg;	/* total RFS messages received */
	long	dis_bread;	/* # of per-file blocks flushed from cache*/
	long	blk_inval;	/* # of per-file blocks flushed from cache*/
	long	inval;		/* # of per-file cache flushes */
};
extern struct dinfo dinfo;
extern struct rcinfo rcinfo;
extern	int minserve;		/* DU tunable: sever low water mark */
extern	int maxserve;		/* DU tunable: sever high water mark */
extern	int nservers;		/* total servers in system */
extern	int idleserver;		/* idle servers in system */
extern	int msglistcnt;		/* receive descriptors in msg queue */


struct minfo {
	unsigned long 	freemem[2]; 	/* freemem in pages */
					/* "double" long format	*/
					/* freemem[0] least significant */
	long	freeswap;	/* free swap space */
	long    vfault;  	/* translation fault */
	long    demand;		/*  demand zero and demand fill pages */
	long    swap;		/*  pages on swap */
	long    cache;		/*  pages in cache */
	long    file;		/*  pages on file */
	long    pfault;		/* protection fault */
	long    cw;		/*  copy on write */
	long    steal;		/*  steal the page */
	long    freedpgs;	/* pages are freed */
	long    vfpg; 		/* pages are freed by vhand*/
	long    sfpg;		/* pages are freed by sched*/
	long    vspg;		/* pages are freed/swapped by vhand */
	long    sspg;		/* pages are freed/swapped by sched */
	long    unmodsw;	/* getpages finds unmodified pages on swap */
	long	unmodfl;	/* getpages finds unmodified pages in file */ 
#ifdef	i386			/* psk */
	long    psoutok;        /* swapping out a process */
	long    psinfail;       /* swapping in a process failed */
	long    psinok;         /* swapping in a process succeeded */
	long    rsout;          /* swapping out a region */
	long    rsin;           /* swapping in a region */
#endif
};

extern struct minfo minfo;
extern struct syswait syswait;

struct syserr {
	long	inodeovf;
	long	fileovf;
	long	textovf;
	long	procovf;
};

extern struct syserr syserr;

struct shlbinfo {
	long	shlbs;		/* Max # of libs a process can link in	*/
				/*   at one time.			*/
	long	shlblnks;	/* # of times processes that have used	*/
				/*   static shared libraries.		*/
	long	shlbovf;	/* # of processes needed more shlibs	*/
				/*   than the system imposed limit.	*/
	long	shlbatts;	/* # of times processes have attached	*/
				/*   run time libraries.		*/
};

extern struct shlbinfo shlbinfo;

struct bpbinfo {
	long	usr;		/* usr time for the co-processor	*/
	long	sys;		/* system time for the co-processor	*/
	long	idle;		/* idle time for the co-processor	*/
	long	syscall;	/* # of system calls since boot on the  */
				/*	co-processor			*/
};

extern struct bpbinfo bpbinfo[];

#endif	/* _SYS_SYSINFO_H */
