#ident	"@(#)statfs.h	1.2	90/08/08"
#ifndef _SYS_STATFS_H
#define _SYS_STATFS_H
#ident "@(#) statfs.h 22.1 90/01/15 "
#ident "@(#)statfs.h	1.2 89/09/29"
#ident "@(#) statfs.h 1.7 89/07/27 "
/*
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 * Structure returned by the statfs() system call.
 */

struct	statfs {
	short	f_fstyp;	/* File system type */
	long	f_bsize;	/* Block size */
	long	f_frsize;	/* Fragment size (if supported) */
	long	f_blocks;	/* Total number of blocks on file system */
	long	f_bfree;	/* Total number of free blocks */
	long	f_files;	/* Total number of file nodes (inodes) */
	long	f_ffree;	/* Total number of free file nodes */
	char	f_fname[6];	/* Volume name */
	char	f_fpack[6];	/* Pack name */
};

/*
 * Extension of statfs structure for kernel use only. Used to obtain
 * additional information from filesystem concerning POSIX functionality
 * Used to implement pathconf() and fpathconf() system calls.
 */

struct statfs2 {
	short	f_fstyp;	/* File system type */
	long	f_bsize;	/* Block size */
	long	f_frsize;	/* Fragment size (if supported) */
	long	f_blocks;	/* Total number of blocks on file system */
	long	f_bfree;	/* Total number of free blocks */
	long	f_files;	/* Total number of file nodes (inodes) */
	long	f_ffree;	/* Total number of free file nodes */
	char	f_fname[6];	/* Volume name */
	char	f_fpack[6];	/* Pack name */

	/* additional fields for POSIX */

	short	f_valid;	/* Set by filesystem if understood */ 
	short	f_chown_res; /* Restricted Chown functionality */
	short	f_no_trunc;	/* Error on long component vs. truncation */
	long	f_name_max;	/* Maximum name (component) length */
	long	f_path_max;	/* Maximum path length */
	long	f_link_max;	/* Maximum number of links */
	long	f_pipebuf;	/* Maximum buffer size for atomic pipe I/O */
};

#endif	/* _SYS_STATFS_H */
