/*
 *	@(#) sess.h 2.1 88/05/18 
 *
 *	Copyright (C) The Santa Cruz Operation, 1984, 1985, 1986, 1987.
 *	Copyright (C) Microsoft Corporation, 1984, 1985, 1986, 1987.
 *	Copyright (C) Intel Corporation, 1984.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, Microsoft Corporation, Intel Corporation,
 *	and AT&T, and should be treated as Confidential.
 */
/***
**
**
**  AUTHOR: Rajiv Chugh 
**
**  Intel Corporation
**  ISO-S
**  2402 W. Beardsley Road
**  Phoenix, Arizona  85027
**
*/
/*
* TITLE:  Data structure declarations for the OpenNET Session driver.
* DATE:	  December 4, 1984
*/

/*
* Session request codes
*/

# define  PASSOP       0x20
# define  ACTOP	       0x21
# define  SWRITE       0x24
# define  SREAD	       0x22
# define  SEOMWRITE    0x32
# define  GSTAT	       0x12
# define  SSTAT	       0x26
# define  CLOSEVC      0x27
# define  ABORTVC      0x25
# define  SREADI       0xa2   /* Not available to Application-level user */
# define  PASSOPI      0xa0   /* Not available to Application-level user */
# define  TESTSEND     0x30   /* Not available to Application-level user */
# define  TESTRECEIVE  0x31   /* Not available to Application-level user */


/*
* defines for Nameserver interface
*/

# define EADDRSIZE     35   /*	Max length of Ethernet Address */
# define MAXNAMSIZE    17   /*	Maximum process name size */

/*
*  Structures to extract parameters passed to Session and return results
*/

/*
*  Structure to extract parameters passed for ACTIVE OPEN/
*  PASSIVE OPEN and return results
*/

struct	  s_open  
  {
    int	       so_rsvd1[2];  /* Reserved */
    unsigned   so_ato;
    unsigned   so_pc;	     /* Used only for ACTIVE OPEN */
    unsigned   so_err;
    int	     (*so_anr)();    /* Used only by the kernel interface */
    char       so_pnames[MAXNAMSIZE * 2];
  };

/*
*  Structure to extract parameters passed for SEND MESSAGE/
*  RECEIVE MESSAGE and return results
*/

struct s_sr 
  {
    int	     (*ssr_anr)();
    caddr_t    ssr_sleep;	  /* Used by the kernel RECEIVE interface */
    unsigned   ssr_err;
    unsigned   ssr_count;
    unsigned   ssr_bklen;
    faddr_t    ssr_bkptr;
    unsigned   ssr_eomflag;	  /*  Meaningful only for a Receive */
    unsigned   tsr_cid;		  /*  Reserved for use by Xenixcomm */
    unsigned   tsr_err;		  /*  Reserved for use by Xenixcomm */
    unsigned   tsr_nbks;	  /*  Reserved for use by Xenixcomm */
    unsigned   tsr_bytecount;	  /*  Reserved for use by Xenixcomm */
    faddr_t    tsr_bkptr;	  /*  Reserved for use by Xenixcomm */
    unsigned   tsr_bklen;	  /*  Reserved for use by Xenixcomm */
    unsigned   tsr_eomflag;	  /*  Reserved for use by Xenixcomm */
    unsigned   tsr_fid;		  /*  Reserved for use by Xenixcomm */
  };  

/*
*  Structure to return results for GET STATUS
*/

struct s_gstat 
  {
    unsigned   sg_err;
    unsigned   sg_state;
    unsigned   sg_lnet;
    unsigned   sg_lhost[3];
    unsigned   sg_lport;
    unsigned   sg_rnet;
    unsigned   sg_rhost[3];
    unsigned   sg_rport;
    unsigned   sg_pc;
    unsigned   sg_ato;
    unsigned   sg_nsent;
    unsigned   sg_nrec;
    int	       (*sg_anr)();	  /* Used only by the kernel interface */
    char       sg_pnames[MAXNAMSIZE * 2];
  };

/*
*  Structure to extract parameters for SET STATUS
*/

struct s_sstat 
  {
    int	       ss_rsvd[2];
    int	       (*ss_anr)();	  /* Used only by the kernel interface */
    unsigned   ss_nsent;
    unsigned   ss_nrec;
  };

struct s_acvc 
  {
    int	       sa_rsvd[2];
    unsigned   sa_err;
  };  

/*
*---------------------------------------------------------------------------
* 
*  The structures below this line need not concern an Application-level
*  user.
*/

/*
* Misc Constants.
*/

# define PSESS	    PRIBIO	       /* PRIBIO is declared in param.h */
# define TRUE	    1
# define FALSE	    0
# define NVC	    21	  /* Maximum number of VCs + 1 */
# define S_KERN	    0x40
# define D_KERN	    0
# define D_USER	    1
# define SPL	    spl5
# define D_BOOTED   (2)
# define DS_DELAY   200	  /* Roughly 0.5 secs. Kludge for iNA problem */

/*
* Connection State Enumerated Types 
*/

# define NORM		1
# define OPEN		2
# define OPEND		3
# define CPEND		4
# define CLOSED		5 
# define ABORT		6

/*
* Sundry Constants
*/

# define REMABORT	     0x0E
# define TOUT		     0x10

/*
* TCL driver request type codes
*/

# define TRQ_AOPEN	('c' << 8 | 1)
# define TRQ_POPEN	('c' << 8 | 2)
# define TRQ_STAT	('c' << 8 | 3)
# define TRQ_DEFSTAT	('c' << 8 | 4)
# define TRQ_SEND	('c' << 8 | 5)
# define TRQ_EOMSEND	('c' << 8 | 6)
# define TRQ_RECEIVE	('c' << 8 | 7)
# define TRQ_CLOSE	('c' << 8 | 8)
# define TRQ_ABORT	('c' << 8 | 9)
# define TRQ_NORM	('c' << 8 | 10)

struct dcb 
  {
    unsigned   d_state;
    char       d_lname[MAXNAMSIZE];	/* Local Process name */
    char       d_rname[MAXNAMSIZE];		/* Remote Process name */
    unsigned   d_lnet;
    unsigned   d_lhost[3];
    unsigned   d_lport;		  /* Local port number for the VC */
    unsigned   d_rnet;		  /* Remote net ID */
    unsigned   d_rhost[3];	  /* Remote host ID */
    unsigned   d_rport;		  /* Remote port number for the VC */
    unsigned   d_cid;
    unsigned   d_pc;
    unsigned   d_ato;
    int	       (*d_anr)();
    unsigned   d_nsent;
    unsigned   d_nrec;
  };

/*  Structures necessary to interface with the iNA 951 driver */

/* Structure of ACTIVE OPEN and PASSIVE OPEN */ 

struct	tclopen 
  {
    unsigned  to_lport;
    unsigned  to_rhost[3];
    unsigned  to_rnet;
    unsigned  to_rport;
    unsigned  to_pc;
    unsigned  to_ato;
    unsigned  to_err;
    unsigned  to_cid;
    int	      (*to_anr)();
  };

/* Structure for STATUS and DEFERRED STATUS */

struct	tclstat 
  {
    unsigned   tst_cid;
    faddr_t    tst_bkptr;
    unsigned   tst_bklen;
    unsigned   tst_err;
  };

/* structures for SEND and RECEIVE */

struct tclsen 
  {
    unsigned   ts_cid;
    unsigned   ts_err;
    unsigned   ts_nbks;
    unsigned   ts_count;
    faddr_t    ts_bkptr;
    unsigned   ts_bklen;
  };

struct tclrec 
  {
    unsigned   tr_cid;
    unsigned   tr_err;
    unsigned   tr_nbks;
    unsigned   tr_count;
    faddr_t    tr_bkptr;
    unsigned   tr_bklen;
    unsigned   tr_eomflag;
    unsigned   tr_fid;
  };

/* structure to do ABORT/CLOSE */

struct tclac  
  {
    unsigned tac_cid;
    unsigned tac_err;
  };

/*
*  Structure of the request block passed by Session to an asynchronous
*  notification routine
*/

struct s_anrargs  
  {
    unsigned	san_fid;
    unsigned	san_err;
    unsigned	san_cmd;
    unsigned	san_count;
    unsigned	san_bklen;
    faddr_t	san_bkptr;
    unsigned	san_eomflag;
  };

/*
*  Structure to extract information returned by the driver DEFERRED STATUS
*  Call 
*/

struct t_retstat 
  {
    char	te_tcl_state;
    unsigned	te_def_ato;
    long	te_def_rt;
    unsigned	te_def_pc;
    char	te_max_cdb;
    char	te_num_cdb;
    unsigned	te_lnet;
    unsigned	te_lhost[3];
    unsigned	te_rsvd1[5];
    char	te_conn_state;
    unsigned	te_lref;
    unsigned	te_lport;
    unsigned	te_rnet;
    unsigned	te_rhost[3];
    unsigned	te_rport;
    unsigned	te_pc;
    unsigned	te_ato;
    unsigned	te_rref;
    long	te_rt;
    unsigned	te_rsvd2[11];
    char	te_options;
    char	te_max_tpdu;
    unsigned	te_max_tpdu_len;
  };
