#ident	"@(#)security.h	1.2	90/08/08"
#ifndef _SYS_SECURITY_H
#define _SYS_SECURITY_H
#ident "@(#) security.h 22.3 90/04/25 "
#ident "@(#)security.h	1.2 89/09/29"
#ident "@(#) security.h 1.10 89/07/27 "

#define SCO
#ifdef SecureWare

#ifndef __SECURITY__
#define __SECURITY__

/*
 * General Purpose Defines and Macros for Security Modules
 *
 * Copyright (c) 1987, 1988, SecureWare, Inc.
 * All rights reserved.
 *
 * @)#(security.h	2.9 14:54:20 4/27/89
 *
 */

#ifdef SCO
/*
 *      Portions Copyright (C) Corollary, Inc., 1986, 1987, 1988, 1989.
 *      All Rights Reserved.
 *      This Module contains Proprietary Information of
 *      Corollary, Inc., and should be treated as Confidential.
 */

#endif
/*
 * This Module contains Proprietary Information of SecureWare, Inc.
 * and should be treated as Confidential.
 */

#ifndef BITS
#ifdef SCO
#define BITS(type)	(8 * (int)sizeof(type))
#else
#include <values.h>
#endif
#endif


/* These macros are for the manipulation of the mask_t type. */

#define	WORD_OF_BIT(bit)	((bit) / BITS(mask_t))
#define	BIT_IN_WORD(bit)	(1 << ((bit) % BITS(mask_t)))


	/* add bit to multi-word vector mask */
#define ADDBIT(mask,bit)  \
	mask[WORD_OF_BIT(bit)] |= BIT_IN_WORD(bit)

	/* remove bit from multi-word vector mask */
#define RMBIT(mask,bit)  \
	mask[WORD_OF_BIT(bit)] &= ~BIT_IN_WORD(bit)

	/* test bit in multi-word vector mask */
#define ISBITSET(mask,bit)  \
	((mask[WORD_OF_BIT(bit)] & BIT_IN_WORD(bit)) != 0)



/*  system privileges defined at this time  */

#define	SEC_SUSPEND_AUDIT	0	/* Process does its own auditing */
#define SEC_CONFIG_AUDIT	1	/* Process to configure audit */
#define SEC_WRITE_AUDIT		2	/* Process can write audit records */
#define	SEC_SUID		3	/* Process can exec SUID programs */
#define	SEC_PROMAIN		4	/* Process ignores promains if set */
#define	SEC_LABEL_TERMINAL	5	/* Allow setting of terminal label */
#define	SEC_SETID		6	/* Permit setting of SUID/SGID bits */
#define	SEC_SETOWNER		7	/* Permit giving away files */
#define	SEC_MAX_SPRIV		7



/*******************************************************************/
/* IMPORTANT NOTE:  Changes in the size below MUST be reflected in */
/*		    the insecure version of <sys/security.h> .     */
/*******************************************************************/

/* size of privilege vector needed in units of mask_t */
#define	SEC_SPRIVVEC_SIZE	(WORD_OF_BIT(SEC_MAX_SPRIV) + 1)



/*  some default file mode settings */

#define	SEC_DEFAULT_MODE	0700
#define	SEC_CORE_MODE		0600


/*  System calls that share the security() interface to the kernel. */

#define	SEC_STOPIO		0
#define	SEC_GETLUID		1
#define	SEC_SETLUID		2
#define	SEC_STATPRIV		3
#define	SEC_CHPRIV		4


/*  The different kind of privilege vectors. */

#define	SEC_EFFECTIVE_PRIV	1


#ifdef SYSV_3

/* FS_SECURITY() filesystem switch functions for 5.3 systems */

#define SEC_FS_GETMODE		1	/* get s5 inode mode */
#define SEC_FS_SETMODE		2	/* set s5 inode mode */
#endif

/* Audit specific discretionary access id structure */

#include <sys/audit.h>

/* Security Parallel Proc/User Structure */

struct security_info {
	struct inode *si_pr_root;	/* promain root of process */
	char	si_in_promain;		/* 1 = in promain, 0 = not in promain */
	char	si_name_in_promain;	/* 1 = in promain, 0 = not in promain */
	char	si_luid_set;		/* 1 = u_luid set, 0 = u_luid not set */
	char	si_in;			/* 1 = source in promain for link(2) */
	ushort	si_pruid;		/* promain user id (PRUID) */
	ushort	si_luid;		/* login user id (LUID) */
	ushort	si_event_type;		/* audit event class */
	ushort	si_record_type;		/* audit record type */
	short	si_privilege;		/* privilege # for EPERM */
	ushort	si_access;		/* access denial code */
	short	si_objtype;		/* object type code */
	short	si_audit_recalc;	/* recalculate audit mask */
	uint	si_objid;		/* object id */
	uint	si_syscall;		/* syscall number */
	dac_t	si_audit_old;		/* old audit values */
	dac_t	si_audit_new;		/* new DAC values */
	mask_t	si_emask[AUDIT_MASK_SIZE];	/* audit event mask */
	mask_t	si_emask_cont[AUDIT_MASK_SIZE];	/* audit event control mask */
	mask_t	si_emask_disp[AUDIT_MASK_SIZE];	/* audit disposition mask */
	priv_t	si_privs_used[SEC_SPRIVVEC_SIZE];	/* use of priv audit */
	priv_t	si_epriv[SEC_SPRIVVEC_SIZE];	/* effective privileges */
};

extern struct security_info *secinfo;
extern struct security_info *sip;
#ifdef SCO
extern struct security_info *at_sip[];
#endif


extern void sec_init();
extern void sec_move_initial_code();
#ifdef M_XENIX
extern void sec_make_safe();
extern char **sec_icode_arg0();
extern char *sec_icode_aflag();
extern char *sec_icode_lflag();
#endif
extern int sec_core_mode();
extern int exec_allowed();
extern int pass_dir_protection();
extern int io_allowed();
extern int issetluid();
extern void update_modes();
extern void privs_copy();
#ifdef SYSV_3
extern int s5security();
#else
extern int sec_text_available();
#endif

extern void promain_copy();
extern void exit_promain();
extern int promain_ipcaccess();
extern int file_access();
extern int promain_determine_ownership();
extern void create_promain();
extern void set_dir_location();
extern void check_enter_promain_hierarchy();
extern void check_exit_promain_hierarchy();
extern void promain_placement();
extern int promain_in();
extern int promain_file_link();

extern int security();


#endif
#endif
#endif	/* _SYS_SECURITY_H */
