#ident "@(#)scsicmd.h	2.2 90/09/27"
#ident "@(#)scsicmd.h	1.4 89/11/16"
#ident "@(#) scsicmd.h 21.1 89/09/11 "
#ifndef _SYS_SCSICMD_H
#define _SYS_SCSICMD_H
/*
 *	Copyright (C) The Santa Cruz Operation, 1989.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 */
/*
 *
 *	Copyright (C) Altos Computer Systems, 1989.
 *	This Module contains Proprietary Information of
 *	Altos Computer Systems and should be treated as Confidential.
 *
 */

/*
**	this file contains all the SCSI specific ioctl defines
*/

/*
 *	10/25/89	panas
 *	- added ioctl to read scsi kernel tables
 *	- moved DISKSPARE ioctl from 'ioctl.h' to here (and renumber)
 */

#define SCSIUSERCMD	(('D'<<8)|64)	/* compare ioctl list in dio.h	*/
#define SCSICMDLEN	12

#define STP	0
#define SDSK	1
#define SROM	2

#define SCSIGETCFG	(('D'<<8)|65)	/* next in line */
#define ENTRY_USED	1		/* table entry used in kernel	*/
#define ENTRY_NULL	2		/* table entry not used 	*/
#define ENTRY_NOTVALID	3		/* table entry number out of range */

#define DISKSPARE 	(('D'<<8)|66)	/* reassign SCSI bad sector */

/* Command switches for scsicfg() system call */

#define GET_BASE_MAJOR	0	/* return major number assigned to scsindex 0 */
#define INDEX_TO_SLOT	1	/* translate scsindex to slot value */
#define GET_CFGINFO	2	/* return config table entry for host adapter */

struct scsi_cfg {
	int		index;		/* DEVCFG index			*/
	unsigned char	flag;		/* entry flag			*/
	unsigned char	id;		/* SCSI id			*/
	unsigned char	lun;		/* SCSI lun			*/
	unsigned char	ha_num;		/* SCSI host adapter number	*/
	dev_t		devnum;		/* device number (major only)	*/
	char		ha_name[9];	/* host adapter driver name	*/
};

#if defined(M_I386) || defined(i386)
#pragma pack(2)
#endif

struct scsicmd {
	faddr_t	data_ptr;	/* pointer to user data read or written */
	ulong	data_len;	/* length of user data at data_ptr or 0	*/
	ushort	is_write;	/* data i/o direction: 0 read, 1 write	*/
	uchar_t	cdb[SCSICMDLEN];/* command description block (0 padded)	*/
	uchar_t	host_sts;	/* to be returned upon completion	*/
	uchar_t	target_sts;	/* to be returned upon completion	*/
};						

#if defined(M_I386) || defined(i386)
#pragma pack()
#endif

#endif	/* _SYS_SCSICMD_H */
