#ident "@(#)pic.h	1.2 90/08/07"
#ifndef _SYS_PIC_H
#define _SYS_PIC_H
#ident "@(#) pic.h 22.1 90/01/15 "
/*
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* #ident	"@)#(head.sys:pic.h	1.3" */

/* Definitions for 8259 Programmable Interrupt Controller */

#define PIC_NEEDICW4    0x01            /* ICW4 needed */
#define	PIC_SINGLE	0x02		/* no cascade mode */
#define	PIC_ADI4	0x04		/* address interval = 4 */
#define	PIC_LEVELED	0x08		/* level-triggered */
#define PIC_EDGED	0x00		/* edge-triggered */
#define PIC_ICW1BASE    0x10            /* base for ICW1 */

#define PIC_86MODE      0x01            /* MCS 86 mode */
#define PIC_AUTOEOI     0x02            /* do auto eoi's */
#define PIC_SLAVEBUF    0x08            /* put slave in buffered mode */
#define PIC_MASTERBUF   0x0C            /* put master in bnuffered mode */
#define PIC_SPFMODE     0x10            /* special fully nested mode */
#define PIC_READISR     0x0B            /* Read the ISR */
#define PIC_NSEOI       0x20            /* Non-specific EOI command */

#define PIC_VECTBASE    0x40            /* Vectors for external interrupts */
					/* start at 64.                    */
/*
 * Interrupt configuration information specific to a particular computer.
 * These constants are used to initialize tables in modules/pic/space.c.
 * NOTE: The master pic must always be pic zero.
 */

#if (defined(AT386)||defined(MC386))	/* AT386 or MC386 board */

#define NPIC    2                       /* 2 PICs */
/* Port addresses */
#define MCMD_PORT       0x20            /* master command port */
#define MIMR_PORT       0x21            /* master intr mask register port */
#define MELC_PORT       0x4d0           /* master edge/level control
						register port on ISP */
#define SCMD_PORT       0xA0            /* slave command port */
#define SIMR_PORT       0xA1            /* slave intr mask register port */
#define SELC_PORT       0x4d1           /* slave edge/level control
						register port on ISP */
#define MASTERLINE      0x02            /* slave on IR2 of master PIC */
#define SLAVEBASE       8               /* slave IR0 interrupt number */
#define PICBUFFERED     0               /* PICs not in buffered mode */
#define I82380          0               /* i82380 chip not used */

#endif

#endif	/* _SYS_PIC_H */
