#ident	"@(#)nmap.h	1.2	90/08/08"
#ifndef _SYS_NMAP_H
#define _SYS_NMAP_H
#ident "@(#) nmap.h 22.1 90/01/15 "
#ident "@(#)nmap.h	1.2 89/09/29"
#ident "@(#) nmap.h 1.2 89/07/27 "
/*
 *	Copyright (C) The Santa Cruz Operation, 1988, 1989.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 */
							/* BEGIN SCO_INTL */
/* Channel mapping ioctl's */

#define	NMIOC  ('n'<< 8)	/* So not to conflict with LDIOCs */
#define NMSMAP (NMIOC|1)	/* set no-map */
#define NMGMAP (NMIOC|2)	/* get no-map */
#define NMNMAP (NMIOC|3)	/* clear no-map */

#ifdef i386
typedef	struct nmtab	*nmp_t;
typedef	struct nmseq	*nmsp_t;
typedef	unsigned char	*nmcp_t;
#else
typedef	struct nmtab	far *nmp_t;
typedef	struct nmseq	far *nmsp_t;
typedef	unsigned char	far *nmcp_t;
#endif

/* Nmap control structure */

struct nmap {
	unsigned char	n_count;	/* Usage count of this map */
	nmp_t		n_p;		/* Ptr. to sequence table */
	struct buf	*n_bp;		/* Ptr. to table buffer header */
};

/* Nmap sequence table structs */

struct nmtab {
	unsigned char	n_iseqs;	/* Number of input sequences */
	unsigned char	n_aseqs;	/* Number of input + output sequences */
	short		n_seqidx[1];	/* Array of sequence offsets */
};

struct nmseq {
	unsigned char	n_nmcnt;	/* Sequence trailer length */
	char		n_nmseq[1];	/* Sequence lead-in(null terminated) */
};

extern struct nmap nmap[];
							/* END SCO_INTL */

#endif	/* _SYS_NMAP_H */
