/*      @(#)in_pcb.h	3.3 LAI System V.3 STREAMS TCP/IP  source        */
/*
 * System V STREAMS TCP - Release 3.0 
 *
 * Copyright 1987, 1988, 1989 Lachman Associates, Incorporated (LAI) 
 * All Rights Reserved. 
 *
 * The copyright above and this notice must be preserved in all copies of this
 * source code.  The copyright above does not evidence any actual or intended
 * publication of this source code. 
 *
 * This is unpublished proprietary trade secret source code of Lachman
 * Associates.  This source code may not be copied, disclosed, distributed,
 * demonstrated or licensed except as expressly authorized by Lachman
 * Associates. 
 *
 * System V STREAMS TCP was jointly developed by Lachman Associates and
 * Convergent Technologies. 
 */
/*
 * Copyright (c) 1985 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef in_pcb_h
#define in_pcb_h
#ident	"@(#)in_pcb.h	6.8 :/source/uts/common/netinet/s.in_pcb.h 1/3/87 21:50:00"

/*
 * Common structure pcb for internet protocol implementation. Here are stored
 * pointers to local and foreign host table entries, local and foreign socket
 * numbers, and pointers up (to a socket structure) and down (to a
 * protocol-specific) control block. 
 */

struct inpcb {
	struct inpcb   *inp_next, *inp_prev;
	/* pointers to other pcb's */
	struct inpcb   *inp_head;	/* pointer back to chain of inpcb's
					 * for this protocol */
	short           inp_state;	/* old so_state from sockets */
	short           inp_tstate;	/* TLI state for this endpoint */
	short           inp_error;	/* error on this pcb */
	short           inp_minor;	/* minor device number allocated */
	queue_t        *inp_q;	/* queue for this minor dev */
	struct in_addr  inp_faddr;	/* foreign host table entry */
	struct in_addr  inp_laddr;	/* local host table entry */
	u_short         inp_fport;	/* foreign port */
	u_short         inp_lport;	/* local port */
#define inp_proto	inp_lport       /* overload port field for protocol */
	caddr_t         inp_ppcb;	/* pointer to per-protocol pcb */
	struct route    inp_route;	/* placeholder for routing entry */
	mblk_t         *inp_options;	/* IP options */
	ushort          inp_protoopt;	/* old so_options from sockets */
	ushort          inp_linger;	/* time to linger while closing */
	ushort          inp_protodef;	/* old pr_flags from sockets */
	int		inp_addrlen;	/* address length client likes */
	short		inp_family;	/* address family client likes */
};

#define	INPLOOKUP_WILDCARD	1
#define	INPLOOKUP_SETLOCAL	2

#ifdef INKERNEL
#define qtoinp(q) ((struct inpcb *) (q)->q_ptr)
struct inpcb   *in_pcblookup(), *inpnewconn();
#endif
#endif				/* in_pcb_h */
