/*      @(#)in.h	3.4 LAI System V.3 STREAMS TCP/IP  source        */
/*
 * System V STREAMS TCP - Release 3.0 
 *
 * Copyright 1987, 1988, 1989 Lachman Associates, Incorporated (LAI) 
 * All Rights Reserved. 
 *
 * The copyright above and this notice must be preserved in all copies of this
 * source code.  The copyright above does not evidence any actual or intended
 * publication of this source code. 
 *
 * This is unpublished proprietary trade secret source code of Lachman
 * Associates.  This source code may not be copied, disclosed, distributed,
 * demonstrated or licensed except as expressly authorized by Lachman
 * Associates. 
 *
 * System V STREAMS TCP was jointly developed by Lachman Associates and
 * Convergent Technologies. 
 */
/*
 * Copyright (c) 1985 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef in_h
#define in_h
#ident	"@(#)in.h	6.8 :/source/uts/common/sys/s.in.h 5/14/87 13:00:24"

#define IPM_ID		200	/* Module ID for IP stream */
#define ICMPM_ID	201	/* Module ID for ICMP stream */
#define TCPM_ID		202	/* Module ID for TCP stream */
#define UDPM_ID		203	/* Module ID for UDP stream */
#define ARPM_ID		204	/* Module ID for ARP stream */
#define APPM_ID		205	/* Module ID for ProcARP stream */
#define RIPM_ID         206     /* Module ID for RIP stream */

/*
 * Constants and structures defined by the internet system, Per RFC 790,
 * September 1981. 
 */

/*
 * Protocols 
 */
#define	IPPROTO_IP		0	/* dummy for IP */
#define	IPPROTO_ICMP		1	/* control message protocol */
#define	IPPROTO_GGP		3	/* gateway^2 (deprecated) */
#define	IPPROTO_TCP		6	/* tcp */
#define	IPPROTO_EGP		8	/* exterior gateway protocol */
#define	IPPROTO_PUP		12	/* pup */
#define	IPPROTO_UDP		17	/* user datagram protocol */
#define	IPPROTO_IDP		22	/* xns idp */

#define	IPPROTO_RAW		255	/* raw IP packet */
#define	IPPROTO_MAX		256


/*
 * Ports < IPPORT_RESERVED are reserved for privileged processes (e.g. root).
 * Ports > IPPORT_USERRESERVED are reserved for servers, not necessarily
 * privileged. 
 */
#define	IPPORT_RESERVED		1024
#define	IPPORT_USERRESERVED	5000

/*
 * Link numbers 
 */
#define	IMPLINK_IP		155
#define	IMPLINK_LOWEXPER	156
#define	IMPLINK_HIGHEXPER	158

/*
 * Internet address (a structure for historical reasons) 
 */
struct in_addr {
	u_long          s_addr;
};

/*
 * Definitions of bits in internet address integers. On subnets, the
 * decomposition of addresses to host and net parts is done according to
 * subnet mask, not the masks here. 
 */
#define	IN_CLASSA(i)		(((long)(i) & 0x80000000) == 0)
#define	IN_CLASSA_NET		0xff000000
#define	IN_CLASSA_NSHIFT	24
#define	IN_CLASSA_HOST		0x00ffffff
#define	IN_CLASSA_MAX		128

#define	IN_CLASSB(i)		(((long)(i) & 0xc0000000) == 0x80000000)
#define	IN_CLASSB_NET		0xffff0000
#define	IN_CLASSB_NSHIFT	16
#define	IN_CLASSB_HOST		0x0000ffff
#define	IN_CLASSB_MAX		65536

#define	IN_CLASSC(i)		(((long)(i) & 0xe0000000) == 0xc0000000)
#define	IN_CLASSC_NET		0xffffff00
#define	IN_CLASSC_NSHIFT	8
#define	IN_CLASSC_HOST		0x000000ff
#define	IN_CLASSD(i)		(((long)(i) & 0xf0000000) == 0xe0000000)
#define	IN_MULTICAST(i)		(((long)(i) & 0xf0000000) == 0xe0000000)

#define	IN_EXPERIMENTAL(i)	(((long)(i) & 0xe0000000) == 0xe0000000)
#define	IN_BADCLASS(i)		(((long)(i) & 0xf0000000) == 0xf0000000)

#define	INADDR_ANY		(u_long)0x00000000
#define	INADDR_BROADCAST	(u_long)0xffffffff	/* must be masked */

#ifndef INKERNEL
#define INADDR_NONE		0xfffffff		/* -1 return */
#endif /* INKERNEL */

#define	IN_LOOPBACKNET		127			/* official! */
/*
 * Socket address, internet style. 
 */
struct sockaddr_in {
	short           sin_family;
	u_short         sin_port;
	struct in_addr  sin_addr;
	char            sin_zero[8];
};

/*
 * The transport providers allow any address length between
 * IN_MINADDRLEN and IN_MAXADDRLEN.  The minimum length corresponds to
 * a sockaddr_in without the sin_zero field.  The maximum length is
 * the size of the sockaddr_in structure.
 *
 * in_chkaddrlen returns true if the given length is valid.
 */

#define IN_MINADDRLEN	(sizeof(struct sockaddr_in) - 8)
#define IN_MAXADDRLEN	(sizeof(struct sockaddr_in))
#define in_chkaddrlen(x) ((x) >= IN_MINADDRLEN && (x) <= IN_MAXADDRLEN)

/*
 * Options for use with [gs]etsockopt at the IP level. 
 */
#define	IP_OPTIONS	1	/* set/get IP per-packet options */

#if !defined(vax) && !defined(i386) && !defined(ntohl)
/*
 * Macros for number representation conversion. 
 */
#define	ntohl(x)	(x)
#define	ntohs(x)	(x)
#define	htonl(x)	(x)
#define	htons(x)	(x)
#endif

#if !defined(ntohl) && (defined(i386) || defined(vax))
u_short         ntohs(), htons();
u_long          ntohl(), htonl();
#endif

#ifdef INKERNEL
struct iocblk_in {
	struct iocblk   iocblk;
	queue_t        *ioc_transport_client;
	queue_t        *ioc_network_client;
	int             ioc_ifflags;
};

/*
 * Useful defines, should be in stream.h 
 */
#define msgbavail(bp) ((bp)->b_datap->db_lim - (bp)->b_wptr)
#define msgblen(bp)	((bp)->b_wptr - (bp)->b_rptr)
#define INET

struct in_addr	in_makeaddr();
extern u_long	in_netof(), in_lnaof();
#endif

#endif				/* in_h */
