/*
 * System V STREAMS TCP - Release 3.0 
 *
 * Copyright 1987, 1988, 1989 Lachman Associates, Incorporated (LAI) 
 * All Rights Reserved. 
 *
 * The copyright above and this notice must be preserved in all copies of this
 * source code.  The copyright above does not evidence any actual or intended
 * publication of this source code. 
 *
 * This is unpublished proprietary trade secret source code of Lachman
 * Associates.  This source code may not be copied, disclosed, distributed,
 * demonstrated or licensed except as expressly authorized by Lachman
 * Associates. 
 *
 * System V STREAMS TCP was jointly developed by Lachman Associates and
 * Convergent Technologies. 
 */
/*
 * Copyright (c) 1985 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/* @(#)protosw.h	3.1 LAI System V.3 STREAMS TCP/IP  source        */
#ifndef protosw_h
#define protosw_h
#ident	"@(#)protosw.h	6.7 :/source/uts/common/net/s.protosw.h 12/3/86 19:57:15"

/* protosw.h	6.2	83/09/19	 */

/*
 * Protocol switch table. 
 *
 * Each protocol has a handle initializing one of these structures, which is
 * used for protocol-protocol and system-protocol communication. 
 *
 * In the Convergent streams model, these protocols are implemented via user
 * level ioctls which connect each protosw entry to a streams clone device. 
 */
struct protosw {
	short           pr_type;/* socket type used for */
	struct domain  *pr_domain;	/* domain protocol a member of */
	short           pr_protocol;	/* protocol number */
	short           pr_flags;	/* see below */
	dev_t           pr_device;	/* device to use for this proto */
	struct protosw *pr_next;/* next link in chain for this family */
};

/*
 * Note that in BSD these values are enforced via timeouts called through
 * protosw, in the Convergent implementation they are more on the order of
 * suggestions that drivers can use. 
 */

#define	PR_SLOWHZ	2	/* 2 slow timeouts per second */
#define	PR_FASTHZ	5	/* 5 fast timeouts per second */

/*
 * Values for pr_flags 
 */
#define	PR_ATOMIC	0x01	/* exchange atomic messages only */
#define	PR_ADDR		0x02	/* addresses given with messages */
/* in the current implementation, PR_ADDR needs PR_ATOMIC to work */
#define	PR_CONNREQUIRED	0x04	/* connection required by protocol */
/* note that PR_WANTRCVD is ignored in the streams implementation */
#define	PR_WANTRCVD	0x08	/* want PRU_RCVD calls */
#define	PR_RIGHTS	0x10	/* passes capabilities */
#define PR_BINDPROTO	0x20	/* pass protocol */

/*
 * These values are currently used by the network and transport layers of the
 * IP streams implementation, but since they were already here in the BSD
 * implementation, why break them? 
 *
 * N.B. The IMP code, in particular, pressumes the values of some of the
 * commands; change with extreme care. TODO (from BSD): spread out codes so
 * new ICMP codes can be accomodated more easily 
 */
#define	PRC_IFDOWN		0	/* interface transition */
#define	PRC_ROUTEDEAD		1	/* select new route if possible */
#define	PRC_QUENCH		4	/* some said to slow down */
#define	PRC_MSGSIZE		5	/* message size forced drop */
#define	PRC_HOSTDEAD		6	/* normally from IMP */
#define	PRC_HOSTUNREACH		7	/* ditto */
#define	PRC_UNREACH_NET		8	/* no route to network */
#define	PRC_UNREACH_HOST	9	/* no route to host */
#define	PRC_UNREACH_PROTOCOL	10	/* dst says bad protocol */
#define	PRC_UNREACH_PORT	11	/* bad port # */
#define	PRC_UNREACH_NEEDFRAG	12	/* IP_DF caused drop */
#define	PRC_UNREACH_SRCFAIL	13	/* source route failed */
#define	PRC_REDIRECT_NET	14	/* net routing redirect */
#define	PRC_REDIRECT_HOST	15	/* host routing redirect */
#define	PRC_REDIRECT_TOSNET	16	/* redirect for type of service & net */
#define	PRC_REDIRECT_TOSHOST	17	/* redirect for tos & host */
#define	PRC_TIMXCEED_INTRANS	18	/* packet lifetime expired in transit */
#define	PRC_TIMXCEED_REASS	19	/* lifetime expired on reass q */
#define	PRC_PARAMPROB		20	/* header incorrect */

#define	PRC_NCMDS		21

#ifdef PRC_REQUESTS
char           *prcrequests[] = {
				 "IFDOWN", "ROUTEDEAD", "#2", "#3",
			     "QUENCH", "MSGSIZE", "HOSTDEAD", "HOSTUNREACH",
	     "NET-UNREACH", "HOST-UNREACH", "PROTO-UNREACH", "PORT-UNREACH",
	 "FRAG-UNREACH", "SRCFAIL-UNREACH", "NET-REDIRECT", "HOST-REDIRECT",
	    "TOSNET-REDIRECT", "TOSHOST-REDIRECT", "TX-INTRANS", "TX-REASS",
				 "PARAMPROB"
};
#endif

/*
 * These are now used by the options management requests for BSD
 * compatibility.   
 */
#define	PRCO_GETOPT	0
#define	PRCO_SETOPT	1

#define	PRCO_NCMDS	2

#ifdef PRCOREQUESTS
char           *prcorequests[] = {
				  "GETOPT", "SETOPT",
};
#endif

#ifdef INKERNEL
extern struct protosw *pffindproto(), *pffindtype();
#endif
#endif				/* protosw_h */
