/*      @(#)if.h	3.2 LAI System V.3 STREAMS TCP/IP  source        */
/*
 * System V STREAMS TCP - Release 3.0 
 *
 * Copyright 1987, 1988, 1989 Lachman Associates, Incorporated (LAI) 
 * All Rights Reserved. 
 *
 * The copyright above and this notice must be preserved in all copies of this
 * source code.  The copyright above does not evidence any actual or intended
 * publication of this source code. 
 *
 * This is unpublished proprietary trade secret source code of Lachman
 * Associates.  This source code may not be copied, disclosed, distributed,
 * demonstrated or licensed except as expressly authorized by Lachman
 * Associates. 
 *
 * System V STREAMS TCP was jointly developed by Lachman Associates and
 * Convergent Technologies. 
 */
/*
 * Copyright (c) 1985 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef if_h
#define if_h
#ident	"@(#)if.h	6.13 :/source/uts/common/net/s.if.h 6/12/87 17:11:03"

#define LOOPM_ID	100	/* Module ID for Loopback stream */
#define ENETM_ID	101	/* Module ID for Ethernet stream */
#define SLIPM_ID	102	/* Module ID for SLIP stream */
#define IFX25M_ID	103	/* Module ID for IP/X.25 stream */

/* flags for interface status (should be common among protos */

#define	IFF_UP		0x1	/* interface is up */
#define	IFF_BROADCAST	0x2	/* broadcast address valid */
#define	IFF_DEBUG	0x4	/* turn on debugging */
#define	IFF_LOOPBACK	0x8	/* is a loopback net */
#define	IFF_POINTOPOINT	0x10	/* interface is point-to-point link */
#define	IFF_NOTRAILERS	0x20	/* avoid use of trailers */
#define	IFF_RUNNING	0x40	/* resources allocated */
#define	IFF_NOARP	0x80	/* no address resolution protocol */
/* next two not supported now, but reserved: */
#define	IFF_PROMISC	0x100	/* receive all packets */
#define	IFF_ALLMULTI	0x200	/* receive all multicast packets */
/* Convergent intelligent board support code */
#define IFF_INTELLIGENT	0x400	/* protocol code on board */

#define IFF_ONEPACKET	0x800	/* one-packet mode */

/* flags set internally only: */
#define	IFF_CANTCHANGE	(IFF_BROADCAST | IFF_POINTOPOINT | IFF_RUNNING)

/*
 * Struct used for one-packet mode params in if ioctls
 */
struct onepacket {
	int	spsize;		/* short packet size */
	int	spthresh;	/* short packet threshold */
};
	
/*
 * Interface request structure used for socket ioctl's.  All interface
 * ioctl's must have parameter definitions which begin with ifr_name.  The
 * remainder may be interface specific. 
 */
struct ifreq {
#define	IFNAMSIZ	16
	char            ifr_name[IFNAMSIZ];	/* if name, e.g. "en0" */
	union {
		struct sockaddr ifru_addr;
		struct sockaddr ifru_dstaddr;
		struct sockaddr ifru_broadaddr;
		short           ifru_flags;
		int             ifru_metric;
		caddr_t         ifru_data;
		char            ifru_enaddr[6];
		struct onepacket ifru_onepacket;
	}               ifr_ifru;
#define	ifr_addr	ifr_ifru.ifru_addr	/* address */
#define	ifr_dstaddr	ifr_ifru.ifru_dstaddr	/* other end of p-to-p link */
#define	ifr_broadaddr	ifr_ifru.ifru_broadaddr	/* broadcast address */
#define	ifr_flags	ifr_ifru.ifru_flags	/* flags */
#define	ifr_metric	ifr_ifru.ifru_metric	/* metric */
#define	ifr_data	ifr_ifru.ifru_data	/* for use by interface */
#define ifr_enaddr	ifr_ifru.ifru_enaddr	/* ethernet address */
#define ifr_onepacket	ifr_ifru.ifru_onepacket	/* one-packet mode params */
};

/*
 * Structure used in SIOCGIFCONF request. Used to retrieve interface
 * configuration for machine (useful for programs which must know all
 * networks accessible). 
 */
struct ifconf {
	int             ifc_len;/* size of associated buffer */
	union {
		caddr_t         ifcu_buf;
		struct ifreq   *ifcu_req;
	}               ifc_ifcu;
#define	ifc_buf	ifc_ifcu.ifcu_buf	/* buffer address */
#define	ifc_req	ifc_ifcu.ifcu_req	/* array of structures returned */
};

/*
 * The ifstats structures are linked by each unit into a chain.  Note that
 * interfaces have to know their own name to play this game. 
 */

struct ifstats {
	struct ifstats *ifs_next;	/* next if on chain */
	char           *ifs_name;	/* interface name */
	short           ifs_unit;	/* unit number */
	short           ifs_active;	/* non-zero if this if is running */
	struct ifaddr  *ifs_addrs;	/* list of addresses */
	short           ifs_mtu;/* Maximum transmission unit */

	/* generic interface statistics */
	int             ifs_ipackets;	/* packets received on interface */
	int             ifs_ierrors;	/* input errors on interface */
	int             ifs_opackets;	/* packets sent on interface */
	int             ifs_oerrors;	/* output errors on interface */
	int             ifs_collisions;	/* collisions on csma interfaces */
	/* end statistics */
};


/*
 * The ifaddr structure contains information about one address of an
 * interface.  They are maintained by the different address families, are
 * allocated and attached when an address is set, and are linked together so
 * all addresses for an interface can be located. 
 */
struct ifaddr {
	struct ifaddr  *ifa_next;	/* next address for interface */
	struct sockaddr ifa_addr;	/* address of interface */
	struct ifstats *ifa_ifs;/* back-pointer to interface stats */
};

#define SLIPDISC 3		/* serial line discipline for IP */

#endif				/* if_h */
