/*
 *	@(#) namei.h 1.1 88/05/18 
 *
 *	Copyright (C) The Santa Cruz Operation, 1988.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, Microsoft Corporation
 *	and AT&T, and should be treated as Confidential.
 *
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#if defined(M_I8086) || defined(M_I286)
#define	nchp_t	struct namecache far *
#define	nchpp_t	struct namecache far * far *
#else
#define	nchp_t	struct namecache *
#define	nchpp_t	struct namecache **
#endif

/*
 * This structure describes the elements in the cache of recent
 * names looked up by namei.
 */
struct	namecache {
	nchp_t	nc_forw;		/* hash chain, MUST BE FIRST */
	nchp_t	nc_back;		/* hash chain, MUST BE FIRST */
	nchp_t	nc_nxt;			/* LRU chain */
	nchpp_t	nc_prev;		/* LRU chain */
	inodep_t nc_ip;			/* inode the name refers to */
	ino_t	nc_ino;			/* ino of parent of name */
	dev_t	nc_dev;			/* dev of parent of name */
	dev_t	nc_idev;		/* dev of the name ref'd */
	long	nc_id;			/* referenced inode's id */
	char	nc_name[DIRSIZ];	/* segment name */
};

#ifdef M_KERNEL

#if defined(M_I8086) || defined(M_I286)
extern struct namecache far namecache[];
#else
extern struct namecache namecache[];
#endif

#endif	/* M_KERNEL */

/*
 * namei operations and modifiers
 */
#define	LOOKUP		0	/* perform name lookup only */
#define	CREATE		1	/* setup for file creation */
#define	DELETE		2	/* setup for file deletion */
#define	LOCKPARENT	0x10	/* see the top of namei */
#define NOCACHE		0x20	/* name must not be left in cache */
