#ident	"@(#)mvwtk.h	1.2	90/08/08"
#ifndef _SYS_MVWTK_H
#define _SYS_MVWTK_H
#ident "@(#) mvwtk.h 22.1 90/01/15 "
#ident "@(#)mvwtk.h	1.2 89/09/29"
#ident "@(#) mvwtk.h 1.2 89/07/21 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 */

/*
 *	Copyright (C) JSB Computer Systems Ltd, 1988.
 *
 *	This Module contains Proprietary Information of
 *	JSB Computer Systems Ltd, and should be treated
 *	as Confidential.
 */

#include "sys/mvwtoolkit.h"

typedef struct tk_error       TK_ERROR;
typedef struct kwdata         KWDATA;
typedef struct tk_rtty_data   TK_RTTY_DATA;
typedef struct tk_ptty_data   TK_PTTY_DATA;
typedef union  tk_indata      TK_INDATA;

typedef struct v1wdata        V1WDATA;

#ifdef                                          FAR_KDS
typedef KWDATA              far * KWDATAP;
typedef TK_RTTY_DATA        far * TKRTTYDP;
typedef TK_PTTY_DATA        far * TKPTTYDP;
typedef WPAGE               far * WPAGEP;
typedef WPUTC               far * WPUTCP;
typedef WCONF               far * WCONFP;
typedef WKEYS               far * WKEYSP;
typedef WSIG                far * WSIGP;
typedef WCLD_DATA           far * WCLD_DATAP;
typedef WTCAP               far * WTCAPP;
typedef MENU                far * MENUP;
typedef MENU_ACTION         far * MENU_ACTIONP;
typedef MENU_OPTION         far * MENU_OPTIONP;
typedef V1WDATA             far * V1WDATAP;
typedef MVWVER              far * MVWVERP;
#else
typedef KWDATA                  * KWDATAP;
typedef TK_RTTY_DATA            * TKRTTYDP;
typedef TK_PTTY_DATA            * TKPTTYDP;
typedef WPAGE                   * WPAGEP;
typedef WPUTC                   * WPUTCP;
typedef WCONF                   * WCONFP;
typedef WKEYS                   * WKEYSP;
typedef WSIG                    * WSIGP;
typedef WCLD_DATA               * WCLD_DATAP;
typedef WTCAP                   * WTCAPP;
typedef MENU                    * MENUP;
typedef MENU_ACTION             * MENU_ACTIONP;
typedef MENU_OPTION             * MENU_OPTIONP;
typedef V1WDATA                 * V1WDATAP;
typedef MVWVER                  * MVWVERP;
#endif

#ifdef                                          FAR_KDS
typedef int                 far * TKINTDP;
typedef int                 far * TKCHARDP;
typedef int                 far * TKSHORTDP;
#else
typedef int                     * TKINTDP;
typedef int                     * TKCHARDP;
typedef int                     * TKSHORTDP;
#endif

/*  This is fledgling toolkit stuff, herein known as Version 1: */

#define V1WIOCINIT      (('W' << 8) | 1)
#define V1WIOCDNIT      (('W' << 8) | 2)
#define V1WIOCGETD      (('W' << 8) | 3)
#define V1WIOCSETD      (('W' << 8) | 4)
#define V1WIOCSPID      (('W' << 8) | 5)
#define V1WIOCSGRP      (('W' << 8) | 6)
struct v1wdata       /* window data for WIOC ioctl's */
{
    short     w_height, w_width;
    short     r_row, r_col;
    short     v_row, v_col;
    short     c_row, c_col;
};

/* End of Toolkit Version 1 specifics */

#define      SLV_ASLP           1
#define      CTRL_ASLP          2
#define      CTRL_AWK           4
#define      SLV_AWK            8
#define      SLV_FINISHED       16
#define      CTL_FINISHED       32

/* mustn't allow signals to fail the toolkit requests when slave
   on a sleep.  Any signal will get actioned anyway on the switch
   back to user level. */
#define  TKTTYPRI  (PZERO-1)

#define            XPOPEN         1

#ifdef                 FARPTR
struct tcdata
{
    int           tcsize;
    int           li;
    int           co;
    unsigned char XGS;
    char far      *tcbuf;
    char          tc_fname[19];
    int far       *tcoffsets;
};
#else
struct tcdata
{
    int           tcsize;
    int           li;
    int           co;
    unsigned char XGS;
    char          *tcbuf;
    char          tc_fname[19];
    int           *tcoffsets;
};
#endif

struct tk_error
{
    int request;
    int werrno;
};

struct kwdata       /* window data for WIOC ioctl's (for kernel) */
{
    short    s_row;     /* physical row of top left window corner             */
    short    s_col;     /* physical col of top left window corner             */
    short    e_row;     /* physical row of bottom right window corner         */
    short    e_col;     /* physical col of bottom right window corner         */
    short    v_row;     /* physical row position of top left of virtual screen*/
    short    v_col;     /* physical col position of top left of virtual screen*/
    short    c_row;     /* current cursor row position on virtual screen      */
    short    c_col;     /* current cursor col position on virtual screen      */
    int      rw_flags;  /* read/write flag settings                           */
    char     r_flags;   /* read flag settings                                 */
    int      handle;    /* lightweight window handle                          */
    char     title[36]; /* the window title                                   */
    char     devnam[16];/* the file system device name of this window         */
    int      werrno;    /* error code                                         */
    dev_t    mindno;    /* used on WIOCGTTY                                   */
};

#define    WDATASIZE   (sizeof(struct wdata))

struct tk_rtty_data
{
    struct buf  *tk_bp;         /* pointer to buf structure for "mutual mem"  */
    MVWADDR     tk_kaddr;       /* kernel address of "mutual memory" area     */
#ifdef                     FARPTR
    unsigned short tk_sel;      /* descriptor for "mutual mem" area           */
#endif
    PTTYPTR     tk_uiptty;      /* pointer to iosptty structure of sub u/i    */
    TTYPTR      tk_uitty;       /* substitute user interface tty              */
    KWDATAP     tk_wdp_info;    /* wdata structure used in special WIOCGETD   */
    int         tk_uirqptty;    /* identifies the ptty on which a u/i rq made */
};

                 /* Note: if any extensions are made to this, bear in
                          mind the size of the structure being incorporated -
                          This is per pseudo-tty data!!
                          For example, WTCAP was too big to include */
union tk_indata
{
    KWDATA        kwdata;
    WPAGE         wpage;
    WPUTC         wputc;
    WCONF         wconf;
    WKEYS         wkeys;
    WSIG          wsig;
    WCLD_DATA     wsig_close;
    MENU          menu;
    MENU_ACTION   menu_action;
    V1WDATA       v1wdata;
    MVWVER        mvw_version;
};

struct tk_ptty_data
{
    TK_INDATA       tk_indata;
    char            tk_flags;
    int             tk_request;
    int             tk_req_state;
    int             tk_werrno;
    int             tk_info;       /* additional data area                    */
};

                            /* flags for tk_flags:                            */
#define    TKWINDOW      1  /* The window is a toolkit window                 */
#define    TKSIGCLOSE    2  /* Perform signal on close of this window         */
#define    TKSLVCLOSD    4  /* Slave has closed                               */
#define    TKMVWSUSPEND  8  /* mview is suspended via WIOCSUSPEND on this pty */

                            /* bit settings for tk_req_state:                 */
#define   TK_BUSY             1  /* a request has not yet been fully serviced */
#define   TK_RQREADY          2  /* a request is ready for servicing          */
#define   TK_CTLR_ATTENDING   4  /* controller attending                      */
#define   TK_BUF_FULL         8  /* Slave/controller shared buffer has data   */
#define   TK_BUF_EMPTY       16  /* Slave/controller shared buffer has no data*/
#define   TK_RQ_RESULT       32  /* The final result of the request has come  */
#define   TK_HOLD_CTLR       64  /* Hold controller                           */

/* additional toolkit ioctls (for controller): */
#define      WIOC              ('W' << 8)
#define      WIOCRQOK          (WIOC | 100)
#define      WIOCRQERR         (WIOC | 101)
#define      WIOCPUTCRES       (WIOC | 102)
#define      WIOCACTIVITY      (WIOC | 103)
#define      WIOCGETRQID       (WIOC | 104)
#define      WIOCIRQOK         (WIOC | 105)

#define IPREADY       0x01
#define OPREADY       0x02
#define IPOPREADY     0x03
#define RQ            0x06
#define TKUIACT       0x0e

/* The following are the high priority toolkit requests, never
   squeezed out by high volume o/p on the foreground window: */

#define high_priority_rq(request)  (request == WIOCREGCLD ||\
                                    request == WIOCDECLARE)

struct proc *mvw_get_proc();

extern int (*mvws_make_request[])();
extern int (*mvwc_service_request[])();

int mvwc_v1wiocinit(),
    mvwc_wiocsetd(),    mvwc_wiocpromote(),
    mvwc_wiocputc(),
    mvwc_wiocgetc_a(),  mvwc_wiocsetc_a(),
    mvwc_wiockeys(),
    mvwc_wiocwhich(),
    mvwc_wiocsigs(),
    mvwc_wiocgetd(),
    mvwc_wiocregcld(),
    mvwc_wiocsuspend(),
    mvwc_wiocsetmenu(), mvwc_wiocdomenu(),
    mvwc_wiocstart(),
    mvwc_wioctcsiz(),   mvwc_wioctcget(),
    mvwc_wiocgetcnf(),  mvwc_wiocsetcnf(), mvwc_wiocversion();

int mvws_v1wiocinit(),
    mvws_wiocgtty(),    mvws_wiocpromote(),
    mvws_wiocskbd(),
    mvws_wiocputc(),
    mvws_wiocgetc_a(),  mvws_wiocsetc_a(),
    mvws_wiocdeclare(), mvws_wiockeys(),
    mvws_wiocwhich(),
    mvws_wiocsigs(),
    mvws_wiocgetd(),
    mvws_wiocmake(),
    mvws_wiocregcld(),
    mvws_wiocsuspend(), mvws_wiocresume(),
    mvws_wiocsetmenu(), mvws_wiocdomenu(),
    mvws_wiocstart(),   
    mvws_wioctcsiz(),   mvws_wioctcget(),
    mvws_wiocgetcnf(),  mvws_wiocsetcnf(),
    mvws_wiocsigrelse(), mvws_wiocversion();

#define         NUMIPSEQS       12    /* NUMIPSEQS & IPBUFSIZE should tally */
#define         IPBUFSIZE      128    /* with same in user-level            */

#ifdef                         SYSV
#define    mvw_getablk()       geteblk()
#define    mvw_bufaddr(bp)     (caddr_t)(paddr(bp))
#else
#define    mvw_getablk()       getablk(0)
#define    mvw_bufaddr(bp)     ptok(bp->b_paddr)
#endif

MVWADDR mvw_malloc_blk();


/* The following macro definition is for support of address
   calculation on 286 machines for indirect addresses in
   some toolkit calls (e.g. WIOCSETC_A, WIOCGETC_A, WIOCPUTC...) */

#ifdef          SCO_222
#ifdef          FARPTR
#define    mvw_seg_desc(addr)       ftoseg(addr)
#define    mvw_model_addr(seg,off)  ((u.u_renv & XE_LDATA)         \
                                         ? off                         \
                                         : sotofar(seg, (caddr_t)(off)))
#else
#define    mvw_seg_desc(addr)       0
#define    mvw_model_addr(seg,off)  off
#endif       /* FARPTR */
#else
#define    mvw_seg_desc(addr)       0
#define    mvw_model_addr(seg,off)  off
#endif       /* SCO_222 */

#endif	/* _SYS_MVWTK_H */
